/* $Id: wmh.h,v 1.2 2003/04/14 00:01:29 ggibecka Exp $
******************************************************************************

   LibGGI WMH extension API header file

   Copyright (C) 2001 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_WMH_H
#define _GGI_WMH_H

#include <ggi/ggi.h>

__BEGIN_DECLS

int ggiWmhInit(void);
int ggiWmhExit(void);

int ggiWmhAttach(ggi_visual_t vis);
int ggiWmhDetach(ggi_visual_t vis);

/* Moving/Resizing the window
 */
int ggiWmhMove		(ggi_visual_t vis,int  x,int  y);
int ggiWmhGetPos	(ggi_visual_t vis,int *x,int *y);
int ggiWmhResize	(ggi_visual_t vis,int x,int y);
int ggiWmhGetSize	(ggi_visual_t vis,int *x,int *y);
int ggiWmhAllowResize	(ggi_visual_t vis,int xmin,int ymin,int xmax,int ymax,int xstep,int ystep);
int ggiWmhMaximize	(ggi_visual_t vis,int xperc,int yperc);

/* Set the window title
 */
int ggiWmhSetTitle	(ggi_visual_t vis, const char *title);

/* Move the window in the window stack
 */
enum ordercmd { ZO_TOP, ZO_ONE_UP, ZO_ONE_DOWN, ZO_BOTTOM };
int ggiWmhZOrder	(ggi_visual_t vis,enum ordercmd command);

/* Icon stuff.
 */
#define GGI_WMH_MAPSTATE_NORMAL		0
#define GGI_WMH_MAPSTATE_ICON		1
#define GGI_WMH_MAPSTATE_WITHDRAWN	2

int ggiWmhIconify	(ggi_visual_t vis,int icon);
int ggiWmhMoveIcon	(ggi_visual_t vis,int x,int y);
int ggiWmhSetIconTitle	(ggi_visual_t vis, const char *title);
/* Icon Pixmaps and flags ? */

__END_DECLS

#endif /* _GGI_WMH_H */
