/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.PersonName;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.dict.VRMap;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmElementImpl;
import org.dcm4cheri.data.DcmObjectHandlerImpl;
import org.dcm4cheri.data.FragmentElement;
import org.dcm4cheri.data.PersonNameImpl;
import org.dcm4cheri.data.SAXHandlerAdapter;
import org.dcm4cheri.data.StringElement;
import org.dcm4cheri.data.ValueElement;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.helpers.DefaultHandler;

abstract class DcmObjectImpl
implements DcmObject {
    static UIDDictionary DICT = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    protected static final Logger log = Logger.getLogger("dcm4che.data.DcmObject");
    protected ArrayList list = new ArrayList();
    private static final int MIN_TRUNCATE_STRING_LEN = 16;

    DcmObjectImpl() {
    }

    public DcmHandler getDcmHandler() {
        return new DcmObjectHandlerImpl(this);
    }

    public DefaultHandler getSAXHandler() {
        return new SAXHandlerAdapter(this.getDcmHandler());
    }

    public Charset getCharset() {
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.list.clear();
    }

    public boolean contains(int n) {
        return Collections.binarySearch(this.list, new DcmElementImpl(n)) >= 0;
    }

    public int vm(int n) {
        int n2 = Collections.binarySearch(this.list, new DcmElementImpl(n));
        return n2 >= 0 ? ((DcmElement)this.list.get(n2)).vm() : -1;
    }

    public DcmElement get(int n) {
        int n2 = Collections.binarySearch(this.list, new DcmElementImpl(n));
        return n2 >= 0 ? (DcmElement)this.list.get(n2) : null;
    }

    public DcmElement remove(int n) {
        int n2 = Collections.binarySearch(this.list, new DcmElementImpl(n));
        return n2 >= 0 ? (DcmElement)this.list.remove(n2) : null;
    }

    public ByteBuffer getByteBuffer(int n) {
        DcmElement dcmElement = this.get(n);
        return dcmElement != null ? dcmElement.getByteBuffer() : null;
    }

    public String getString(int n, String string) throws DcmValueException {
        return this.getString(n, 0, string);
    }

    public String getString(int n) throws DcmValueException {
        return this.getString(n, 0, null);
    }

    public String getString(int n, int n2) throws DcmValueException {
        return this.getString(n, n2, null);
    }

    public String getString(int n, int n2, String string) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return string;
        }
        return dcmElement.getString(n2, this.getCharset());
    }

    public String[] getStrings(int n) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getStrings(this.getCharset());
    }

    public String getBoundedString(int n, int n2, String string) throws DcmValueException {
        return this.getBoundedString(n, n2, 0, string);
    }

    public String getBoundedString(int n, int n2) throws DcmValueException {
        return this.getBoundedString(n, n2, 0, null);
    }

    public String getBoundedString(int n, int n2, int n3) throws DcmValueException {
        return this.getBoundedString(n, n2, n3, null);
    }

    public String getBoundedString(int n, int n2, int n3, String string) throws DcmValueException {
        DcmElement dcmElement = this.get(n2);
        if (dcmElement == null || dcmElement.vm() <= n3) {
            return string;
        }
        return dcmElement.getBoundedString(n, n3, this.getCharset());
    }

    public String[] getBoundedStrings(int n, int n2) throws DcmValueException {
        DcmElement dcmElement = this.get(n2);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getBoundedStrings(n, this.getCharset());
    }

    public Integer getInteger(int n) throws DcmValueException {
        return this.getInteger(n, 0);
    }

    public Integer getInteger(int n, int n2) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return null;
        }
        return new Integer(dcmElement.getInt(n2));
    }

    public int getInt(int n, int n2) throws DcmValueException {
        return this.getInt(n, 0, n2);
    }

    public int getInt(int n, int n2, int n3) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return n3;
        }
        return dcmElement.getInt(n2);
    }

    public int[] getInts(int n) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getInts();
    }

    public float getFloat(int n, float f) throws DcmValueException {
        return this.getFloat(n, 0, f);
    }

    public float getFloat(int n, int n2, float f) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return f;
        }
        return dcmElement.getFloat(n2);
    }

    public float[] getFloats(int n) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getFloats();
    }

    public double getDouble(int n, double d) throws DcmValueException {
        return this.getDouble(n, 0, d);
    }

    public double getDouble(int n, int n2, double d) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return d;
        }
        return dcmElement.getDouble(n2);
    }

    public double[] getDoubles(int n) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getDoubles();
    }

    public Date getDate(int n) throws DcmValueException {
        return this.getDate(n, 0);
    }

    public Date getDate(int n, int n2) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return null;
        }
        return dcmElement.getDate(n2);
    }

    public Date[] getDates(int n) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null) {
            return null;
        }
        return dcmElement.getDates();
    }

    public Date getDateTime(int n, int n2) throws DcmValueException {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.isEmpty()) {
            return null;
        }
        DcmElement dcmElement2 = this.get(n2);
        if (dcmElement2 == null || dcmElement2.isEmpty()) {
            return dcmElement.getDate();
        }
        return new Date(dcmElement.getDate().getTime() + dcmElement2.getDate().getTime());
    }

    public Dataset getItem(int n) {
        return this.getItem(n, 0);
    }

    public Dataset getItem(int n, int n2) {
        DcmElement dcmElement = this.get(n);
        if (dcmElement == null || dcmElement.vm() <= n2) {
            return null;
        }
        return dcmElement.getItem(n2);
    }

    protected DcmElement put(DcmElement dcmElement) {
        if (log.isDebugEnabled()) {
            log.debug("put " + dcmElement);
        }
        if ((dcmElement.tag() & 0xFFFF) == 0) {
            return dcmElement;
        }
        int n = this.list.size();
        if (n == 0 || dcmElement.compareTo(this.list.get(n - 1)) > 0) {
            this.list.add(dcmElement);
        } else {
            int n2 = Collections.binarySearch(this.list, dcmElement);
            if (n2 >= 0) {
                this.list.set(n2, dcmElement);
            } else {
                this.list.add(-(n2 + 1), dcmElement);
            }
        }
        return dcmElement;
    }

    public DcmElement putAE(int n) {
        return this.put(StringElement.createAE(n));
    }

    public DcmElement putAE(int n, String string) {
        return this.put(string != null ? StringElement.createAE(n, string) : StringElement.createAE(n));
    }

    public DcmElement putAE(int n, String[] stringArray) {
        return this.put(StringElement.createAE(n, stringArray));
    }

    public DcmElement putAS(int n) {
        return this.put(StringElement.createAS(n));
    }

    public DcmElement putAS(int n, String string) {
        return this.put(string != null ? StringElement.createAS(n, string) : StringElement.createAS(n));
    }

    public DcmElement putAS(int n, String[] stringArray) {
        return this.put(StringElement.createAS(n, stringArray));
    }

    public DcmElement putAT(int n) {
        return this.put(ValueElement.createAT(n));
    }

    public DcmElement putAT(int n, int n2) {
        return this.put(ValueElement.createAT(n, n2));
    }

    public DcmElement putAT(int n, int[] nArray) {
        return this.put(ValueElement.createAT(n, nArray));
    }

    public DcmElement putAT(int n, String string) {
        return this.putAT(n, Integer.parseInt(string, 16));
    }

    public DcmElement putAT(int n, String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            nArray[n2] = Integer.parseInt(stringArray[n2], 16);
            ++n2;
        }
        return this.putAT(n, nArray);
    }

    public DcmElement putCS(int n) {
        return this.put(StringElement.createCS(n));
    }

    public DcmElement putCS(int n, String string) {
        return this.put(string != null ? StringElement.createCS(n, string) : StringElement.createCS(n));
    }

    public DcmElement putCS(int n, String[] stringArray) {
        return this.put(StringElement.createCS(n, stringArray));
    }

    public DcmElement putDA(int n) {
        return this.put(StringElement.createDA(n));
    }

    public DcmElement putDA(int n, Date date) {
        return this.put(date != null ? StringElement.createDA(n, date) : StringElement.createDA(n));
    }

    public DcmElement putDA(int n, Date[] dateArray) {
        return this.put(StringElement.createDA(n, dateArray));
    }

    public DcmElement putDA(int n, Date date, Date date2) {
        return this.put(StringElement.createDA(n, date, date2));
    }

    public DcmElement putDA(int n, String string) {
        return this.put(string != null ? StringElement.createDA(n, string) : StringElement.createDA(n));
    }

    public DcmElement putDA(int n, String[] stringArray) {
        return this.put(StringElement.createDA(n, stringArray));
    }

    public DcmElement putDS(int n) {
        return this.put(StringElement.createDS(n));
    }

    public DcmElement putDS(int n, float f) {
        return this.put(StringElement.createDS(n, f));
    }

    public DcmElement putDS(int n, float[] fArray) {
        return this.put(StringElement.createDS(n, fArray));
    }

    public DcmElement putDS(int n, String string) {
        return this.put(string != null ? StringElement.createDS(n, string) : StringElement.createDS(n));
    }

    public DcmElement putDS(int n, String[] stringArray) {
        return this.put(StringElement.createDS(n, stringArray));
    }

    public DcmElement putDT(int n) {
        return this.put(StringElement.createDT(n));
    }

    public DcmElement putDT(int n, Date date) {
        return this.put(date != null ? StringElement.createDT(n, date) : StringElement.createDT(n));
    }

    public DcmElement putDT(int n, Date[] dateArray) {
        return this.put(StringElement.createDT(n, dateArray));
    }

    public DcmElement putDT(int n, Date date, Date date2) {
        return this.put(StringElement.createDT(n, date, date2));
    }

    public DcmElement putDT(int n, String string) {
        return this.put(string != null ? StringElement.createDT(n, string) : StringElement.createDT(n));
    }

    public DcmElement putDT(int n, String[] stringArray) {
        return this.put(StringElement.createDT(n, stringArray));
    }

    public DcmElement putFL(int n) {
        return this.put(ValueElement.createFL(n));
    }

    public DcmElement putFL(int n, float f) {
        return this.put(ValueElement.createFL(n, f));
    }

    public DcmElement putFL(int n, float[] fArray) {
        return this.put(ValueElement.createFL(n, fArray));
    }

    public DcmElement putFL(int n, String string) {
        return this.put(string != null ? ValueElement.createFL(n, Float.parseFloat(string)) : ValueElement.createFL(n));
    }

    public DcmElement putFL(int n, String[] stringArray) {
        return this.put(ValueElement.createFL(n, StringUtils.parseFloats(stringArray)));
    }

    public DcmElement putFD(int n) {
        return this.put(ValueElement.createFD(n));
    }

    public DcmElement putFD(int n, double d) {
        return this.put(ValueElement.createFD(n, d));
    }

    public DcmElement putFD(int n, double[] dArray) {
        return this.put(ValueElement.createFD(n, dArray));
    }

    public DcmElement putFD(int n, String string) {
        return this.put(string != null ? ValueElement.createFD(n, Double.parseDouble(string)) : ValueElement.createFD(n));
    }

    public DcmElement putFD(int n, String[] stringArray) {
        return this.put(ValueElement.createFD(n, StringUtils.parseDoubles(stringArray)));
    }

    public DcmElement putIS(int n) {
        return this.put(StringElement.createIS(n));
    }

    public DcmElement putIS(int n, int n2) {
        return this.put(StringElement.createIS(n, n2));
    }

    public DcmElement putIS(int n, int[] nArray) {
        return this.put(StringElement.createIS(n, nArray));
    }

    public DcmElement putIS(int n, String string) {
        return this.put(string != null ? StringElement.createIS(n, string) : StringElement.createIS(n));
    }

    public DcmElement putIS(int n, String[] stringArray) {
        return this.put(StringElement.createIS(n, stringArray));
    }

    public DcmElement putLO(int n) {
        return this.put(StringElement.createLO(n));
    }

    public DcmElement putLO(int n, String string) {
        return this.put(string != null ? StringElement.createLO(n, string, this.getCharset()) : StringElement.createLO(n));
    }

    public DcmElement putLO(int n, String[] stringArray) {
        return this.put(StringElement.createLO(n, stringArray, this.getCharset()));
    }

    public DcmElement putLT(int n) {
        return this.put(StringElement.createLT(n));
    }

    public DcmElement putLT(int n, String string) {
        return this.put(string != null ? StringElement.createLT(n, string, this.getCharset()) : StringElement.createLT(n));
    }

    public DcmElement putLT(int n, String[] stringArray) {
        return this.put(StringElement.createLT(n, stringArray, this.getCharset()));
    }

    public DcmElement putOB(int n) {
        return this.put(ValueElement.createOB(n));
    }

    public DcmElement putOB(int n, byte[] byArray) {
        return this.put(ValueElement.createOB(n, byArray));
    }

    public DcmElement putOB(int n, ByteBuffer byteBuffer) {
        return this.put(ValueElement.createOB(n, byteBuffer));
    }

    public DcmElement putOBsq(int n) {
        return this.put(FragmentElement.createOB(n));
    }

    public DcmElement putOF(int n) {
        return this.put(ValueElement.createOF(n));
    }

    public DcmElement putOF(int n, float[] fArray) {
        return this.put(ValueElement.createOF(n, fArray));
    }

    public DcmElement putOF(int n, ByteBuffer byteBuffer) {
        return this.put(ValueElement.createOF(n, byteBuffer));
    }

    public DcmElement putOFsq(int n) {
        return this.put(FragmentElement.createOF(n));
    }

    public DcmElement putOW(int n) {
        return this.put(ValueElement.createOW(n));
    }

    public DcmElement putOW(int n, short[] sArray) {
        return this.put(ValueElement.createOW(n, sArray));
    }

    public DcmElement putOW(int n, ByteBuffer byteBuffer) {
        return this.put(ValueElement.createOW(n, byteBuffer));
    }

    public DcmElement putOWsq(int n) {
        return this.put(FragmentElement.createOW(n));
    }

    public DcmElement putPN(int n) {
        return this.put(StringElement.createSH(n));
    }

    public DcmElement putPN(int n, PersonName personName) {
        return this.put(personName != null ? StringElement.createPN(n, personName, this.getCharset()) : StringElement.createPN(n));
    }

    public DcmElement putPN(int n, PersonName[] personNameArray) {
        return this.put(StringElement.createPN(n, personNameArray, this.getCharset()));
    }

    public DcmElement putPN(int n, String string) {
        return this.put(string != null ? StringElement.createPN(n, new PersonNameImpl(string), this.getCharset()) : StringElement.createPN(n));
    }

    public DcmElement putPN(int n, String[] stringArray) {
        PersonName[] personNameArray = new PersonName[stringArray.length];
        int n2 = 0;
        while (n2 < personNameArray.length) {
            personNameArray[n2] = new PersonNameImpl(stringArray[n2]);
            ++n2;
        }
        return this.put(StringElement.createPN(n, personNameArray, this.getCharset()));
    }

    public DcmElement putSH(int n) {
        return this.put(StringElement.createSH(n));
    }

    public DcmElement putSH(int n, String string) {
        return this.put(string != null ? StringElement.createSH(n, string, this.getCharset()) : StringElement.createSH(n));
    }

    public DcmElement putSH(int n, String[] stringArray) {
        return this.put(StringElement.createSH(n, stringArray, this.getCharset()));
    }

    public DcmElement putSL(int n) {
        return this.put(ValueElement.createSL(n));
    }

    public DcmElement putSL(int n, int n2) {
        return this.put(ValueElement.createSL(n, n2));
    }

    public DcmElement putSL(int n, int[] nArray) {
        return this.put(ValueElement.createSL(n, nArray));
    }

    public DcmElement putSL(int n, String string) {
        return this.put(string != null ? ValueElement.createSL(n, StringUtils.parseInt(string, Integer.MIN_VALUE, Integer.MAX_VALUE)) : ValueElement.createSL(n));
    }

    public DcmElement putSL(int n, String[] stringArray) {
        return this.put(ValueElement.createSL(n, StringUtils.parseInts(stringArray, Integer.MIN_VALUE, Integer.MAX_VALUE)));
    }

    public DcmElement putSQ(int n) {
        throw new UnsupportedOperationException();
    }

    public DcmElement putSS(int n) {
        return this.put(ValueElement.createSS(n));
    }

    public DcmElement putSS(int n, int n2) {
        return this.put(ValueElement.createSS(n, n2));
    }

    public DcmElement putSS(int n, int[] nArray) {
        return this.put(ValueElement.createSS(n, nArray));
    }

    public DcmElement putSS(int n, String string) {
        return this.put(string != null ? ValueElement.createSS(n, StringUtils.parseInt(string, -32768L, 32767L)) : ValueElement.createSS(n));
    }

    public DcmElement putSS(int n, String[] stringArray) {
        return this.put(ValueElement.createSS(n, StringUtils.parseInts(stringArray, -32768L, 32767L)));
    }

    public DcmElement putST(int n) {
        return this.put(StringElement.createST(n));
    }

    public DcmElement putST(int n, String string) {
        return this.put(string != null ? StringElement.createST(n, string, this.getCharset()) : StringElement.createST(n));
    }

    public DcmElement putST(int n, String[] stringArray) {
        return this.put(StringElement.createST(n, stringArray, this.getCharset()));
    }

    public DcmElement putTM(int n) {
        return this.put(StringElement.createTM(n));
    }

    public DcmElement putTM(int n, Date date) {
        return this.put(date != null ? StringElement.createTM(n, date) : StringElement.createTM(n));
    }

    public DcmElement putTM(int n, Date[] dateArray) {
        return this.put(StringElement.createTM(n, dateArray));
    }

    public DcmElement putTM(int n, Date date, Date date2) {
        return this.put(StringElement.createTM(n, date, date2));
    }

    public DcmElement putTM(int n, String string) {
        return this.put(string != null ? StringElement.createTM(n, string) : StringElement.createTM(n));
    }

    public DcmElement putTM(int n, String[] stringArray) {
        return this.put(StringElement.createTM(n, stringArray));
    }

    public DcmElement putUI(int n) {
        return this.put(StringElement.createUI(n));
    }

    public DcmElement putUI(int n, String string) {
        return this.put(string != null ? StringElement.createUI(n, string) : StringElement.createUI(n));
    }

    public DcmElement putUI(int n, String[] stringArray) {
        return this.put(StringElement.createUI(n, stringArray));
    }

    public DcmElement putUL(int n) {
        return this.put(ValueElement.createUL(n));
    }

    public DcmElement putUL(int n, int n2) {
        return this.put(ValueElement.createUL(n, n2));
    }

    public DcmElement putUL(int n, int[] nArray) {
        return this.put(ValueElement.createUL(n, nArray));
    }

    public DcmElement putUL(int n, String string) {
        return this.put(string != null ? ValueElement.createUL(n, StringUtils.parseInt(string, 0L, 0xFFFFFFFFL)) : ValueElement.createUL(n));
    }

    public DcmElement putUL(int n, String[] stringArray) {
        return this.put(ValueElement.createUL(n, StringUtils.parseInts(stringArray, 0L, 0xFFFFFFFFL)));
    }

    public DcmElement putUN(int n) {
        return this.put(ValueElement.createUN(n));
    }

    public DcmElement putUN(int n, byte[] byArray) {
        return this.put(ValueElement.createUN(n, byArray));
    }

    public DcmElement putUN(int n, ByteBuffer byteBuffer) {
        return this.put(ValueElement.createUN(n, byteBuffer));
    }

    public DcmElement putUNsq(int n) {
        return this.put(FragmentElement.createUN(n));
    }

    public DcmElement putUS(int n) {
        return this.put(ValueElement.createUS(n));
    }

    public DcmElement putUS(int n, int n2) {
        return this.put(ValueElement.createUS(n, n2));
    }

    public DcmElement putUS(int n, int[] nArray) {
        return this.put(ValueElement.createUS(n, nArray));
    }

    public DcmElement putUS(int n, String string) {
        return this.put(string != null ? ValueElement.createUS(n, StringUtils.parseInt(string, 0L, 65535L)) : ValueElement.createUS(n));
    }

    public DcmElement putUS(int n, String[] stringArray) {
        return this.put(ValueElement.createUS(n, StringUtils.parseInts(stringArray, 0L, 65535L)));
    }

    public DcmElement putUT(int n) {
        return this.put(StringElement.createUT(n));
    }

    public DcmElement putUT(int n, String string) {
        return this.put(string != null ? StringElement.createUT(n, string, this.getCharset()) : StringElement.createUT(n));
    }

    public DcmElement putUT(int n, String[] stringArray) {
        return this.put(StringElement.createUT(n, stringArray, this.getCharset()));
    }

    public DcmElement putXX(int n) {
        return this.putXX(n, VRMap.DEFAULT.lookup(n));
    }

    public DcmElement putXX(int n, ByteBuffer byteBuffer) {
        return this.putXX(n, VRMap.DEFAULT.lookup(n), byteBuffer);
    }

    public DcmElement putXX(int n, String string) {
        return this.putXX(n, VRMap.DEFAULT.lookup(n), string);
    }

    public DcmElement putXX(int n, String[] stringArray) {
        return this.putXX(n, VRMap.DEFAULT.lookup(n), stringArray);
    }

    public DcmElement putXXsq(int n) {
        return this.putXXsq(n, VRMap.DEFAULT.lookup(n));
    }

    public DcmElement putXXsq(int n, int n2) {
        switch (n2) {
            case 20290: {
                return this.putOBsq(n);
            }
            case 20294: {
                return this.putOFsq(n);
            }
            case 20311: {
                return this.putOWsq(n);
            }
            case 21838: {
                return this.putUNsq(n);
            }
        }
        throw new IllegalArgumentException(Tags.toString(n) + " " + VRs.toString(n2));
    }

    public DcmElement putXX(int n, int n2) {
        switch (n2) {
            case 16709: {
                return this.putAE(n);
            }
            case 16723: {
                return this.putAS(n);
            }
            case 16724: {
                return this.putAT(n);
            }
            case 17235: {
                return this.putCS(n);
            }
            case 17473: {
                return this.putDA(n);
            }
            case 17491: {
                return this.putDS(n);
            }
            case 17492: {
                return this.putDT(n);
            }
            case 17996: {
                return this.putFL(n);
            }
            case 17988: {
                return this.putFD(n);
            }
            case 18771: {
                return this.putIS(n);
            }
            case 19535: {
                return this.putLO(n);
            }
            case 19540: {
                return this.putLT(n);
            }
            case 20290: {
                return this.putOB(n);
            }
            case 20294: {
                return this.putOF(n);
            }
            case 20311: {
                return this.putOW(n);
            }
            case 20558: {
                return this.putPN(n);
            }
            case 21320: {
                return this.putSH(n);
            }
            case 21324: {
                return this.putSL(n);
            }
            case 21329: {
                return ((Dataset)((Object)this)).putSQ(n);
            }
            case 21331: {
                return this.putSS(n);
            }
            case 21332: {
                return this.putST(n);
            }
            case 21581: {
                return this.putTM(n);
            }
            case 21833: {
                return this.putUI(n);
            }
            case 21838: {
                return this.putUN(n);
            }
            case 21836: {
                return this.putUL(n);
            }
            case 21843: {
                return this.putUS(n);
            }
            case 21844: {
                return this.putUT(n);
            }
        }
        throw new IllegalArgumentException(Tags.toString(n) + " " + VRs.toString(n2));
    }

    public DcmElement putXX(int n, int n2, ByteBuffer byteBuffer) {
        switch (n2) {
            case 16709: {
                return this.put(StringElement.createAE(n, byteBuffer));
            }
            case 16723: {
                return this.put(StringElement.createAS(n, byteBuffer));
            }
            case 16724: {
                return this.put(ValueElement.createAT(n, byteBuffer));
            }
            case 17235: {
                return this.put(StringElement.createCS(n, byteBuffer));
            }
            case 17473: {
                return this.put(StringElement.createDA(n, byteBuffer));
            }
            case 17491: {
                return this.put(StringElement.createDS(n, byteBuffer));
            }
            case 17492: {
                return this.put(StringElement.createDT(n, byteBuffer));
            }
            case 17996: {
                return this.put(ValueElement.createFL(n, byteBuffer));
            }
            case 17988: {
                return this.put(ValueElement.createFD(n, byteBuffer));
            }
            case 18771: {
                return this.put(StringElement.createIS(n, byteBuffer));
            }
            case 19535: {
                return this.put(StringElement.createLO(n, byteBuffer));
            }
            case 19540: {
                return this.put(StringElement.createLT(n, byteBuffer));
            }
            case 20290: {
                return this.put(ValueElement.createOB(n, byteBuffer));
            }
            case 20294: {
                return this.put(ValueElement.createOF(n, byteBuffer));
            }
            case 20311: {
                return this.put(ValueElement.createOW(n, byteBuffer));
            }
            case 20558: {
                return this.put(StringElement.createPN(n, byteBuffer));
            }
            case 21320: {
                return this.put(StringElement.createSH(n, byteBuffer));
            }
            case 21324: {
                return this.put(ValueElement.createSL(n, byteBuffer));
            }
            case 21331: {
                return this.put(ValueElement.createSS(n, byteBuffer));
            }
            case 21332: {
                return this.put(StringElement.createST(n, byteBuffer));
            }
            case 21581: {
                return this.put(StringElement.createTM(n, byteBuffer));
            }
            case 21833: {
                return this.put(StringElement.createUI(n, byteBuffer));
            }
            case 21838: {
                return this.put(ValueElement.createUN(n, byteBuffer));
            }
            case 21836: {
                return this.put(ValueElement.createUL(n, byteBuffer));
            }
            case 21843: {
                return this.put(ValueElement.createUS(n, byteBuffer));
            }
            case 21844: {
                return this.put(StringElement.createUT(n, byteBuffer));
            }
        }
        throw new IllegalArgumentException(Tags.toString(n) + " " + VRs.toString(n2));
    }

    public DcmElement putXX(int n, int n2, String string) {
        switch (n2) {
            case 16709: {
                return this.putAE(n, string);
            }
            case 16723: {
                return this.putAS(n, string);
            }
            case 16724: {
                return this.putAT(n, string);
            }
            case 17235: {
                return this.putCS(n, string);
            }
            case 17473: {
                return this.putDA(n, string);
            }
            case 17491: {
                return this.putDS(n, string);
            }
            case 17492: {
                return this.putDT(n, string);
            }
            case 17996: {
                return this.putFL(n, string);
            }
            case 17988: {
                return this.putFD(n, string);
            }
            case 18771: {
                return this.putIS(n, string);
            }
            case 19535: {
                return this.putLO(n, string);
            }
            case 19540: {
                return this.putLT(n, string);
            }
            case 20558: {
                return this.putPN(n, string);
            }
            case 21320: {
                return this.putSH(n, string);
            }
            case 21324: {
                return this.putSL(n, string);
            }
            case 21331: {
                return this.putSS(n, string);
            }
            case 21332: {
                return this.putST(n, string);
            }
            case 21581: {
                return this.putTM(n, string);
            }
            case 21833: {
                return this.putUI(n, string);
            }
            case 21836: {
                return this.putUL(n, string);
            }
            case 21843: {
                return this.putUS(n, string);
            }
            case 21844: {
                return this.putUT(n, string);
            }
        }
        throw new IllegalArgumentException(Tags.toString(n) + " " + VRs.toString(n2));
    }

    public DcmElement putXX(int n, int n2, String[] stringArray) {
        switch (n2) {
            case 16709: {
                return this.putAE(n, stringArray);
            }
            case 16723: {
                return this.putAS(n, stringArray);
            }
            case 16724: {
                return this.putAT(n, stringArray);
            }
            case 17235: {
                return this.putCS(n, stringArray);
            }
            case 17473: {
                return this.putDA(n, stringArray);
            }
            case 17491: {
                return this.putDS(n, stringArray);
            }
            case 17492: {
                return this.putDT(n, stringArray);
            }
            case 17996: {
                return this.putFL(n, stringArray);
            }
            case 17988: {
                return this.putFD(n, stringArray);
            }
            case 18771: {
                return this.putIS(n, stringArray);
            }
            case 19535: {
                return this.putLO(n, stringArray);
            }
            case 19540: {
                return this.putLT(n, stringArray);
            }
            case 20558: {
                return this.putPN(n, stringArray);
            }
            case 21320: {
                return this.putSH(n, stringArray);
            }
            case 21324: {
                return this.putSL(n, stringArray);
            }
            case 21331: {
                return this.putSS(n, stringArray);
            }
            case 21332: {
                return this.putST(n, stringArray);
            }
            case 21581: {
                return this.putTM(n, stringArray);
            }
            case 21833: {
                return this.putUI(n, stringArray);
            }
            case 21836: {
                return this.putUL(n, stringArray);
            }
            case 21843: {
                return this.putUS(n, stringArray);
            }
            case 21844: {
                return this.putUT(n, stringArray);
            }
        }
        throw new IllegalArgumentException(Tags.toString(n) + " " + VRs.toString(n2));
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public void putAll(DcmObject dcmObject) {
        Iterator iterator = dcmObject.iterator();
        block4: while (iterator.hasNext()) {
            DcmElement dcmElement = (DcmElement)iterator.next();
            if (dcmElement.isEmpty()) {
                this.putXX(dcmElement.tag(), dcmElement.vr());
                continue;
            }
            switch (dcmElement.vr()) {
                case 21329: {
                    DcmElement dcmElement2 = this.putSQ(dcmElement.tag());
                    int n = 0;
                    int n2 = dcmElement.vm();
                    while (n < n2) {
                        dcmElement2.addItem(dcmElement.getItem(n));
                        ++n;
                    }
                    continue block4;
                }
                case 20290: 
                case 20294: 
                case 20311: 
                case 21838: {
                    DcmElement dcmElement2;
                    if (dcmElement.hasDataFragments()) {
                        dcmElement2 = this.putXXsq(dcmElement.tag(), dcmElement.vr());
                        int n = 0;
                        int n3 = dcmElement.vm();
                        while (n < n3) {
                            dcmElement2.addDataFragment(dcmElement.getDataFragment(n));
                            ++n;
                        }
                        continue block4;
                    }
                }
                default: {
                    this.putXX(dcmElement.tag(), dcmElement.vr(), dcmElement.getByteBuffer());
                }
            }
        }
    }

    protected void write(int n, int n2, DcmHandler dcmHandler) throws IOException {
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24)};
        long l = ((DcmElement)this.list.get(0)).getStreamPosition();
        dcmHandler.startElement(n, 21836, l == -1L ? -1L : l - 12L);
        dcmHandler.value(byArray, 0, 4);
        dcmHandler.endElement();
        int n3 = 0;
        int n4 = this.list.size();
        while (n3 < n4) {
            DcmElement dcmElement = (DcmElement)this.list.get(n3);
            int n5 = dcmElement.length();
            dcmHandler.startElement(dcmElement.tag(), dcmElement.vr(), dcmElement.getStreamPosition());
            ByteBuffer byteBuffer = dcmElement.getByteBuffer(ByteOrder.LITTLE_ENDIAN);
            dcmHandler.value(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
            dcmHandler.endElement();
            ++n3;
        }
    }

    public void writeHeader(ImageOutputStream imageOutputStream, DcmEncodeParam dcmEncodeParam, int n, int n2, int n3) throws IOException {
        if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            imageOutputStream.write(n >> 16);
            imageOutputStream.write(n >> 24);
            imageOutputStream.write(n >> 0);
            imageOutputStream.write(n >> 8);
        } else {
            imageOutputStream.write(n >> 24);
            imageOutputStream.write(n >> 16);
            imageOutputStream.write(n >> 8);
            imageOutputStream.write(n >> 0);
        }
        if (n2 != 0 && dcmEncodeParam.explicitVR) {
            imageOutputStream.write(n2 >> 8);
            imageOutputStream.write(n2 >> 0);
            if (VRs.isLengthField16Bit(n2)) {
                if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    imageOutputStream.write(n3 >> 0);
                    imageOutputStream.write(n3 >> 8);
                } else {
                    imageOutputStream.write(n3 >> 8);
                    imageOutputStream.write(n3 >> 0);
                }
                return;
            }
            imageOutputStream.write(0);
            imageOutputStream.write(0);
        }
        if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            imageOutputStream.write(n3 >> 0);
            imageOutputStream.write(n3 >> 8);
            imageOutputStream.write(n3 >> 16);
            imageOutputStream.write(n3 >> 24);
        } else {
            imageOutputStream.write(n3 >> 24);
            imageOutputStream.write(n3 >> 16);
            imageOutputStream.write(n3 >> 8);
            imageOutputStream.write(n3 >> 0);
        }
    }

    public void writeHeader(OutputStream outputStream, DcmEncodeParam dcmEncodeParam, int n, int n2, int n3) throws IOException {
        if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            outputStream.write(n >> 16);
            outputStream.write(n >> 24);
            outputStream.write(n >> 0);
            outputStream.write(n >> 8);
        } else {
            outputStream.write(n >> 24);
            outputStream.write(n >> 16);
            outputStream.write(n >> 8);
            outputStream.write(n >> 0);
        }
        if (dcmEncodeParam.explicitVR) {
            outputStream.write(n2 >> 8);
            outputStream.write(n2 >> 0);
            if (VRs.isLengthField16Bit(n2)) {
                if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    outputStream.write(n3 >> 0);
                    outputStream.write(n3 >> 8);
                } else {
                    outputStream.write(n3 >> 8);
                    outputStream.write(n3 >> 0);
                }
                return;
            }
            outputStream.write(0);
            outputStream.write(0);
        }
        if (dcmEncodeParam.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            outputStream.write(n3 >> 0);
            outputStream.write(n3 >> 8);
            outputStream.write(n3 >> 16);
            outputStream.write(n3 >> 24);
        } else {
            outputStream.write(n3 >> 24);
            outputStream.write(n3 >> 16);
            outputStream.write(n3 >> 8);
            outputStream.write(n3 >> 0);
        }
    }
}

