/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4cheri.dict.TagDictionaryImpl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class TagDictionaryLoader
extends DefaultHandler {
    private final TagDictionaryImpl dict;
    private final SAXParser parser;

    public TagDictionaryLoader(TagDictionaryImpl tagDictionaryImpl) {
        this.dict = tagDictionaryImpl;
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new ConfigurationError("Could not create SAX Parser", exception);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("element".equals(string3)) {
            String string4 = attributes.getValue("tag");
            if (string4 == null) {
                throw new SAXException("Missing tag attribute");
            }
            char[] cArray = string4.toCharArray();
            if (cArray.length != 11 || cArray[0] != '(' || cArray[5] != ',' || cArray[10] != ')') {
                throw new SAXException("Illegal tag value: " + string4);
            }
            try {
                this.dict.add(new TagDictionary.Entry(this.toTag(cArray), string4.indexOf(120) == -1 ? -1 : this.toMask(cArray), attributes.getValue("vr"), attributes.getValue("vm"), attributes.getValue("name")));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Illegal tag value: " + string4, numberFormatException);
            }
        }
    }

    private int toTag(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.toTag(cArray[1])).append(this.toTag(cArray[2])).append(this.toTag(cArray[3])).append(this.toTag(cArray[4])).append(this.toTag(cArray[6])).append(this.toTag(cArray[7])).append(this.toTag(cArray[8])).append(this.toTag(cArray[9]));
        return (int)Long.parseLong(stringBuffer.toString(), 16);
    }

    private char toTag(char c) {
        return c == 'x' ? (char)'0' : (char)c;
    }

    private int toMask(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append(this.toMask(cArray[1])).append(this.toMask(cArray[2])).append(this.toMask(cArray[3])).append(this.toMask(cArray[4])).append(this.toMask(cArray[6])).append(this.toMask(cArray[7])).append(this.toMask(cArray[8])).append(this.toMask(cArray[9]));
        return (int)Long.parseLong(stringBuffer.toString(), 16);
    }

    private char toMask(char c) {
        return c == 'x' ? (char)'0' : 'f';
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.parser.parse(inputSource, (DefaultHandler)this);
    }

    public void parse(File file) throws SAXException, IOException {
        this.parser.parse(file, (DefaultHandler)this);
    }

    static class ConfigurationError
    extends Error {
        ConfigurationError(String string, Exception exception) {
            super(string, exception);
        }
    }
}

