/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.BasicColorModelParam;

final class MonochromeParam
extends BasicColorModelParam {
    private final int inverse;
    private final float slope;
    private final float intercept;
    private final float[] center;
    private final float[] width;
    private final int hashcode;
    private static final float[] EMPTY = new float[0];

    private static final float[] nullToEmpty(float[] fArray) {
        return fArray == null ? EMPTY : fArray;
    }

    private static final float correctZeroSlope(float f) {
        return f == 0.0f ? 1.0f : f;
    }

    public MonochromeParam(Dataset dataset, String string) throws DcmValueException {
        super(dataset);
        this.inverse = "INVERSE".equals(dataset.getString(0x20500020, string)) ? -1 : 0;
        this.slope = MonochromeParam.correctZeroSlope(dataset.getFloat(2625619, 1.0f));
        this.intercept = dataset.getFloat(2625618, 0.0f);
        this.center = MonochromeParam.nullToEmpty(dataset.getFloats(2625616));
        this.width = MonochromeParam.nullToEmpty(dataset.getFloats(2625617));
        int n = 0;
        while (n < this.width.length) {
            if (this.width[n] <= 0.0f) {
                this.width[n] = (float)(this.max - this.min) / this.slope;
            }
            ++n;
        }
        this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width);
    }

    private static int hashcode(int n, int n2, int n3, int n4, float f, float f2, float[] fArray, float[] fArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append(n2).append(n3).append(n4).append(f).append(f2);
        if (Math.min(fArray.length, fArray2.length) != 0) {
            stringBuffer.append(fArray[0]).append(fArray2[0]);
        }
        return stringBuffer.toString().hashCode();
    }

    private MonochromeParam(MonochromeParam monochromeParam, float f, float f2, boolean bl) {
        super(monochromeParam);
        this.inverse = bl ? -1 : 0;
        this.slope = monochromeParam.slope;
        this.intercept = monochromeParam.intercept;
        this.center = new float[]{f};
        this.width = new float[]{f2};
        this.hashcode = MonochromeParam.hashcode(this.dataType, this.inverse, this.min, this.max, this.slope, this.intercept, this.center, this.width);
    }

    public ColorModelParam update(float f, float f2, boolean bl) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("width: " + f2);
        }
        return new MonochromeParam(this, f, f2, bl);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MonochromeParam)) {
            return false;
        }
        MonochromeParam monochromeParam = (MonochromeParam)object;
        if (this.getNumberOfWindows() == 0 ? monochromeParam.getNumberOfWindows() != 0 : monochromeParam.getNumberOfWindows() == 0 || this.center[0] != monochromeParam.center[0] || this.width[0] != monochromeParam.width[0]) {
            return false;
        }
        return this.inverse == monochromeParam.inverse && this.intercept == monochromeParam.intercept && this.slope == monochromeParam.slope && this.max == monochromeParam.max && this.min == monochromeParam.min;
    }

    public final float getRescaleSlope() {
        return this.slope;
    }

    public final float getRescaleIntercept() {
        return this.intercept;
    }

    public final float getWindowCenter(int n) {
        return this.center[n];
    }

    public final float getWindowWidth(int n) {
        return this.width[n];
    }

    public final int getNumberOfWindows() {
        return Math.min(this.center.length, this.width.length);
    }

    public final boolean isCacheable() {
        return true;
    }

    public final boolean isInverse() {
        return this.inverse != 0;
    }

    public final float toMeasureValue(int n) {
        return (float)this.mask(n) * this.slope + this.intercept;
    }

    public final int toPixelValue(float f) {
        return (int)((f - this.intercept) / this.slope);
    }

    private static int toARGB(int n) {
        return 0xFF000000 | n << 16 | n << 8 | n;
    }

    public ColorModel newColorModel() {
        int[] nArray = new int[this.size];
        if (this.getNumberOfWindows() == 0) {
            if (this.min == 0) {
                int n = 0;
                while (n < this.size) {
                    nArray[n] = MonochromeParam.toARGB((n >> this.bits_8 ^ this.inverse) & 0xFF);
                    ++n;
                }
            } else {
                int n = 0;
                int n2 = this.size >> 1;
                while (n2 < this.size) {
                    nArray[n] = MonochromeParam.toARGB((n2 >> this.bits_8 ^ this.inverse) & 0xFF);
                    nArray[n2] = MonochromeParam.toARGB((n >> this.bits_8 ^ this.inverse) & 0xFF);
                    ++n2;
                    ++n;
                }
            }
        } else {
            this.createCMAP(nArray, (int)((this.center[0] - this.intercept) / this.slope), (int)(this.width[0] / this.slope));
        }
        return new IndexColorModel(this.bits, this.size, nArray, 0, false, -1, this.dataType);
    }

    private void createCMAP(int[] nArray, int n, int n2) {
        int n3 = n - (n2 >> 1);
        int n4 = n3 + n2;
        if (n3 > 0 && this.inverse != 0) {
            Arrays.fill(nArray, 0, Math.min(n3, this.max), -1);
        }
        if (n4 < this.max && this.inverse == 0) {
            Arrays.fill(nArray, Math.max(0, n4), this.max, -1);
        }
        int n5 = Math.max(0, n3);
        int n6 = Math.min(n4, this.max);
        while (n5 < n6) {
            nArray[n5] = MonochromeParam.toARGB(((n5 - n3 << 8) / n2 ^ this.inverse) & 0xFF);
            ++n5;
        }
        if (this.min == 0) {
            return;
        }
        if (n3 > this.min && this.inverse != 0) {
            Arrays.fill(nArray, this.size >> 1, Math.min(n3 + this.size, this.size), -1);
        }
        if (n4 < 0 && this.inverse == 0) {
            Arrays.fill(nArray, Math.max(n4 + this.size, this.size >> 1), this.size, -1);
        }
        int n7 = Math.max(this.min, n3);
        int n8 = Math.min(n4, 0);
        while (n7 < n8) {
            nArray[n7 + this.size] = MonochromeParam.toARGB(((n7 - n3 << 8) / n2 ^ this.inverse) & 0xFF);
            ++n7;
        }
    }
}

