/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che.net.AAbort;
import org.dcm4che.net.PDUException;
import org.dcm4cheri.net.UnparsedPDUImpl;

final class AAbortImpl
implements AAbort {
    private final byte[] buf;

    static AAbortImpl parse(UnparsedPDUImpl unparsedPDUImpl) throws PDUException {
        if (unparsedPDUImpl.length() != 4) {
            throw new PDUException("Illegal A-ABORT " + unparsedPDUImpl, new AAbortImpl(2, 6));
        }
        return new AAbortImpl(unparsedPDUImpl.buffer());
    }

    private AAbortImpl(byte[] byArray) {
        this.buf = byArray;
    }

    AAbortImpl(int n, int n2) {
        this.buf = new byte[]{7, 0, 0, 0, 0, 4, 0, 0, (byte)n, (byte)n2};
    }

    public final int source() {
        return this.buf[8] & 0xFF;
    }

    public final int reason() {
        return this.buf[9] & 0xFF;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf);
        outputStream.flush();
    }

    public String toString(boolean bl) {
        return this.toString();
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer()).toString();
    }

    final StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        return stringBuffer.append("A-ABORT\n\tsource=").append(this.sourceAsString()).append("\n\treason=").append(this.reasonAsString());
    }

    private String sourceAsString() {
        switch (this.source()) {
            case 0: {
                return "0 - service-user";
            }
            case 2: {
                return "2 - service-provider";
            }
        }
        return String.valueOf(this.source());
    }

    private String reasonAsString() {
        switch (this.reason()) {
            case 0: {
                return "0 - reason-not-specified";
            }
            case 1: {
                return "1 - unrecognized-PDU";
            }
            case 2: {
                return "2 - unexpected-PDU";
            }
            case 4: {
                return "4 - unrecognized-PDU parameter";
            }
            case 5: {
                return "5 - unexpected-PDU parameter";
            }
            case 6: {
                return "6 - invalid-PDU-parameter value";
            }
        }
        return String.valueOf(this.reason());
    }
}

