/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmStreamHandlerImpl;
import org.xml.sax.ContentHandler;

final class FileMetaInfoImpl
extends DcmObjectImpl
implements FileMetaInfo {
    static final byte[] DICM_PREFIX = new byte[]{68, 73, 67, 77};
    static final byte[] VERSION = new byte[]{0, 1};
    private final byte[] preamble = new byte[128];
    private String sopClassUID = null;
    private String sopInstanceUID = null;
    private String tsUID = null;
    private String implClassUID = null;
    private String implVersionName = null;

    FileMetaInfoImpl() {
    }

    public String toString() {
        return "FileMetaInfo[uid=" + this.sopInstanceUID + "\n\tclass=" + DcmObjectImpl.DICT.lookup(this.sopClassUID) + "\n\tts=" + DcmObjectImpl.DICT.lookup(this.tsUID) + "\n\timpl=" + this.implClassUID + "-" + this.implVersionName + "]";
    }

    public final byte[] getPreamble() {
        return this.preamble;
    }

    FileMetaInfoImpl init(String string, String string2, String string3, String string4, String string5) {
        this.putOB(131073, (byte[])VERSION.clone());
        this.putUI(131074, string);
        this.putUI(131075, string2);
        this.putUI(131088, string3);
        this.putUI(131090, string4);
        if (string5 != null) {
            this.putSH(131091, string5);
        }
        return this;
    }

    public String getMediaStorageSOPClassUID() {
        try {
            return this.getString(131074);
        }
        catch (DcmValueException dcmValueException) {
            return null;
        }
    }

    public String getMediaStorageSOPInstanceUID() {
        try {
            return this.getString(131075);
        }
        catch (DcmValueException dcmValueException) {
            return null;
        }
    }

    public String getTransferSyntaxUID() {
        try {
            return this.getString(131088);
        }
        catch (DcmValueException dcmValueException) {
            return null;
        }
    }

    protected DcmElement put(DcmElement dcmElement) {
        if ((dcmElement.tag() & 0xFFFF0000) != 131072) {
            throw new IllegalArgumentException(dcmElement.toString());
        }
        return super.put(dcmElement);
    }

    public int length() {
        return this.grLen() + 12;
    }

    private int grLen() {
        int n = 0;
        int n2 = 0;
        int n3 = this.list.size();
        while (n2 < n3) {
            DcmElement dcmElement = (DcmElement)this.list.get(n2);
            n += dcmElement.length() + (VRs.isLengthField16Bit(dcmElement.vr()) ? 8 : 12);
            ++n2;
        }
        return n;
    }

    public void write(DcmHandler dcmHandler) throws IOException {
        dcmHandler.startFileMetaInfo(this.preamble);
        dcmHandler.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
        this.write(131072, this.grLen(), dcmHandler);
        dcmHandler.endFileMetaInfo();
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(new DcmStreamHandlerImpl(outputStream));
    }

    public void write(ImageOutputStream imageOutputStream) throws IOException {
        this.write(new DcmStreamHandlerImpl(imageOutputStream));
    }

    public void write(ContentHandler contentHandler, TagDictionary tagDictionary) throws IOException {
        this.write(new DcmHandlerAdapter(contentHandler, tagDictionary));
    }
}

