/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.BasicColorModelParam;

final class PaletteColorParam
extends BasicColorModelParam {
    private final byte[] r;
    private final byte[] g;
    private final byte[] b;

    public PaletteColorParam(Dataset dataset) throws DcmValueException {
        super(dataset);
        if (this.min < 0) {
            throw new UnsupportedOperationException("Signed PALETTE COLOR not supported!");
        }
        this.r = PaletteColorParam.generate(this.size, dataset, 2625793, 2626049, 0x281221);
        this.g = PaletteColorParam.generate(this.size, dataset, 2625794, 2626050, 0x281222);
        this.b = PaletteColorParam.generate(this.size, dataset, 2625795, 2626051, 2626083);
    }

    public ColorModel newColorModel() {
        return new IndexColorModel(this.bits, this.size, this.r, this.g, this.b);
    }

    private static void throwLengthMismatch(int n, int n2) throws DcmValueException {
        throw new DcmValueException("LUT Data length: " + n + " mismatch entry value: " + n2 + " in LUT Descriptor");
    }

    private static byte[] generate(int n, Dataset dataset, int n2, int n3, int n4) throws DcmValueException {
        DcmElement dcmElement = dataset.get(n2);
        if (dcmElement == null) {
            throw new DcmValueException("Missing LUT Descriptor!");
        }
        if (dcmElement.vm() != 3) {
            throw new DcmValueException("Illegal LUT Descriptor: " + dcmElement);
        }
        int n5 = dcmElement.getInt(0);
        if (n5 == 0) {
            n5 = 65536;
        }
        if (n5 < 0) {
            throw new DcmValueException("Illegal LUT Descriptor: len=" + n5);
        }
        int n6 = dcmElement.getInt(1);
        if (n6 < 0) {
            throw new DcmValueException("off: " + n6);
        }
        ByteBuffer byteBuffer = dataset.getByteBuffer(n3);
        ByteBuffer byteBuffer2 = dataset.getByteBuffer(n4);
        if (byteBuffer == null && byteBuffer2 == null) {
            throw new DcmValueException("Missing LUT Data!");
        }
        byte[] byArray = new byte[n];
        switch (dcmElement.getInt(2)) {
            case 16: {
                if (byteBuffer != null) {
                    if (byteBuffer.limit() != n5 * 2) {
                        PaletteColorParam.throwLengthMismatch(byteBuffer.limit(), n5);
                    }
                    byteBuffer.rewind();
                    int n7 = n6;
                    while (byteBuffer.hasRemaining()) {
                        byArray[n7] = (byte)(byteBuffer.getShort() >> 8);
                        ++n7;
                    }
                    break;
                }
                PaletteColorParam.inflate(byteBuffer2, byArray, n6, n5);
                break;
            }
            case 8: {
                if (byteBuffer != null) {
                    if (byteBuffer.limit() != n5) {
                        PaletteColorParam.throwLengthMismatch(byteBuffer.limit(), n5);
                    }
                    byteBuffer.rewind();
                    byteBuffer.get(byArray, n6, n5);
                    break;
                }
            }
            default: {
                throw new DcmValueException("Illegal LUT Descriptor: bits=" + dcmElement.getInt(2));
            }
        }
        Arrays.fill(byArray, n6 + n5, n, byArray[n6 + n5 - 1]);
        return byArray;
    }

    private static void inflate(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) throws DcmValueException {
        int n3 = n;
        int n4 = 0;
        byteBuffer.rewind();
        block9: while (byteBuffer.hasRemaining()) {
            short s = byteBuffer.getShort();
            int n5 = byteBuffer.getShort() & 0xFFFF;
            switch (s) {
                case 0: {
                    int n6 = 0;
                    while (n6 < n5) {
                        int n7 = n3++;
                        n4 = byteBuffer.getShort() & 0xFFFF;
                        byArray[n7] = (byte)(n4 >> 8);
                        ++n6;
                    }
                    continue block9;
                }
                case 1: {
                    int n8 = byteBuffer.getShort() & 0xFFFF;
                    int n9 = n8 - n4;
                    int n10 = 0;
                    while (n10 < n5) {
                        byArray[n3++] = (byte)(n4 + n9 * ++n10 / n5 >> 8);
                    }
                    n4 = n8;
                    break;
                }
                case 2: {
                    int n9;
                    int n8;
                    int n11 = byteBuffer.getShort() & 0xFFFF | byteBuffer.getShort() << 16;
                    byteBuffer.mark();
                    byteBuffer.position(n11);
                    int n12 = 0;
                    while (n12 < n5) {
                        short s2 = byteBuffer.getShort();
                        int n13 = byteBuffer.getShort() & 0xFFFF;
                        switch (s2) {
                            case 0: {
                                int n14 = 0;
                                while (n14 < n13) {
                                    int n15 = n3++;
                                    n4 = byteBuffer.getShort() & 0xFFFF;
                                    byArray[n15] = (byte)(n4 >> 8);
                                    ++n14;
                                }
                                break;
                            }
                            case 1: {
                                n8 = byteBuffer.getShort() & 0xFFFF;
                                n9 = n8 - n4;
                                int n16 = 0;
                                while (n16 < n13) {
                                    byArray[n3++] = (byte)(n4 + n9 * ++n16 / n13 >> 8);
                                }
                                n4 = n8;
                                break;
                            }
                            default: {
                                throw new DcmValueException("illegal op code:" + s2 + ", index:" + (byteBuffer.position() - 4));
                            }
                        }
                        ++n12;
                    }
                    byteBuffer.reset();
                    break;
                }
                default: {
                    throw new DcmValueException("illegal op code:" + s + ", index:" + (byteBuffer.position() - 4));
                }
            }
        }
        if (n3 - n != n2) {
            PaletteColorParam.throwLengthMismatch(n3 - n, n2);
        }
    }

    public ColorModelParam update(float f, float f2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public float getRescaleSlope() {
        throw new UnsupportedOperationException();
    }

    public float getRescaleIntercept() {
        throw new UnsupportedOperationException();
    }

    public float getWindowCenter(int n) {
        throw new UnsupportedOperationException();
    }

    public float getWindowWidth(int n) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfWindows() {
        throw new UnsupportedOperationException();
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isInverse() {
        return false;
    }

    public float toMeasureValue(int n) {
        throw new UnsupportedOperationException();
    }

    public int toPixelValue(float f) {
        throw new UnsupportedOperationException();
    }
}

