/*
 * Decompiled with CFR 0.152.
 */
package de.iftm.pgm;

import de.iftm.pgm.PGM;
import de.iftm.pgm.PgmCommentsUtil;
import gnu.getopt.Getopt;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4che.imageio.plugins.DcmMetadata;

public class Dcm2Pgm {
    private static final String VERSION = "1.0";
    private static TagDictionary dict;
    private static boolean runAsApplication;
    private Dataset dcmMetadata = null;
    private BufferedImage bufferedImage = null;
    private Dataset userMetadata = null;
    private boolean includeNoMetadata = false;
    private boolean includeAllMetadata = false;

    public static void main(String[] args) {
        String arg = "";
        Dcm2Pgm myself = new Dcm2Pgm();
        runAsApplication = true;
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = arg + " " + args[i];
                ++i;
            }
            arg = arg.substring(1);
        }
        myself.run(arg);
    }

    public void help() {
        System.out.println("dcm2pgm version " + VERSION);
        System.out.println();
        System.out.println();
        System.out.println("Usage:");
        System.out.println("dcm2pgm [commands] <source>");
        System.out.println();
        System.out.println("Converts a DICOM file to a PGM or PPM file, depending on the contents of");
        System.out.println("the source. By default only default metadata requiered for a Secondary");
        System.out.println("Capture image are written besides the image data.");
        System.out.println();
        System.out.println("<source>        the file or directory containing the DICOM file(s).");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("-a <study_id>   Set the StudyID tag (00200010) to <study_id>.");
        System.out.println("-A <study_uid>  Set the StudyInstanceUID tag (0020000d) to <study_uid>.");
        System.out.println("-b <series_num> Set the SeriesNumber tag (00200011) to <series_num>.");
        System.out.println("-B <series_uid> Set the SeriesInstanceUID tag (0020000e) to <series_uid>.");
        System.out.println("-c <image_num>  Set the InstanceNumber tag (00200013) to <image_num>.");
        System.out.println("-C <sop_uid>    Set the SOPInstanceUID tag (00080018) to <sop_uid>.");
        System.out.println("-d <file-uri>   The name of the destination file or a directory.");
        System.out.println("-F              Include all DICOM tags as image comments.");
        System.out.println("-h              Print this help message.");
        System.out.println("-n <name>       Set the PatientName tag (00100010) to <name>.");
        System.out.println("-N <pat_id>     Set the PatientID tag (00100020) to <pat_id>.");
        System.out.println("-x              Include only DICOM tags requiered for a Secondary Capture image.");
        System.out.println("                If not enough information is given in the base image, default ");
        System.out.println("                valuesare added.");
        System.out.println("-X              Include no DICOM tags in the image.");
        System.out.println();
        System.out.println("<file-uri>      Describes a file in a operating-system independend way. See the");
        System.out.println("                API-Doc of the URI class. For Windows-OS the absolute URI");
        System.out.println("                    file:/c:/user/tom/foo.txt");
        System.out.println("                describes the file");
        System.out.println("                    C:\\user\\tom\\foo.txt");
        System.out.println("                Relative URI's, e.g. without the 'file:' schema-prefix, are");
        System.out.println("                relativ to the user-directory, given by the system property");
        System.out.println("                user.dir. For example: If the user.dir is");
        System.out.println("                    C:\\user\\tom\\");
        System.out.println("                and the relative URI is");
        System.out.println("                    /abc/foo.txt");
        System.out.println("                the referenced file is");
        System.out.println("                    C:\\user\\tom\\abc\\foo.txt");
        System.out.println("                The abbreviations '.' for the current and '..' for the upper");
        System.out.println("                directory are valid to form a relative URI.");
        System.out.println();
        System.out.println();
        System.out.println("(C) 2002 Thomas Hacklaender, mailto:hacklaender@iftm.de");
        System.out.println("IFTM Institut fuer Telematik in der Medizin GmbH, www.iftm.de");
        System.out.println();
        System.out.println("This library is free software; you can redistribute it and/or modify it under");
        System.out.println("the terms of the GNU  General Public License as published by the Free Software");
        System.out.println("Foundation; either version 2 of the License, or (at your option) any later");
        System.out.println("version.");
    }

    /*
     * WARNING - void declaration
     */
    public void run(String arg) {
        int c;
        File source = null;
        File[] sourceFileArray = null;
        File destination = null;
        File destinationDir = null;
        this.userMetadata = DcmObjectFactory.getInstance().newDataset();
        StringTokenizer tok = new StringTokenizer(arg);
        Vector<String> argv = new Vector<String>();
        while (tok.hasMoreTokens()) {
            argv.addElement(tok.nextToken());
        }
        String[] args = argv.toArray(new String[0]);
        Getopt g = new Getopt("Dcm2Pgm", args, "a:A:b:B:c:C:d:Fhn:N:X");
        while ((c = g.getopt()) != -1) {
            void var3_10;
            switch (var3_10) {
                case 97: {
                    this.addUserTag(0x200010, g.getOptarg());
                    break;
                }
                case 65: {
                    this.addUserTag(0x20000D, g.getOptarg());
                    break;
                }
                case 98: {
                    this.addUserTag(0x200011, g.getOptarg());
                    break;
                }
                case 66: {
                    this.addUserTag(0x20000E, g.getOptarg());
                    break;
                }
                case 99: {
                    this.addUserTag(2097171, g.getOptarg());
                    break;
                }
                case 67: {
                    this.addUserTag(524312, g.getOptarg());
                    break;
                }
                case 100: {
                    destination = Dcm2Pgm.uriToFile(g.getOptarg());
                    break;
                }
                case 70: {
                    this.includeAllMetadata = true;
                    break;
                }
                case 104: {
                    this.help();
                    return;
                }
                case 110: {
                    this.addUserTag(0x100010, g.getOptarg());
                    break;
                }
                case 78: {
                    this.addUserTag(0x100020, g.getOptarg());
                    break;
                }
                case 88: {
                    this.includeNoMetadata = true;
                    break;
                }
                default: {
                    this.help();
                }
            }
        }
        int optind = g.getOptind();
        switch (args.length - optind) {
            case 0: {
                System.err.println("***Error: Missing source file reference.");
                return;
            }
            case 1: {
                source = Dcm2Pgm.uriToFile(args[optind]);
                break;
            }
            default: {
                System.err.println("***Error: To many arguments.");
                return;
            }
        }
        if (source == null) {
            System.err.println("*** Error: Can't extract valid File from " + arg);
            return;
        }
        sourceFileArray = source.isDirectory() ? source.listFiles() : new File[]{source};
        destinationDir = destination == null ? (source.isDirectory() ? source : source.getParentFile()) : (destination.isDirectory() ? destination : destination.getParentFile());
        if (sourceFileArray.length == 1 && destination != null && !destination.isDirectory()) {
            String destinationName = destination.getName();
            if (!this.read(sourceFileArray[0])) {
                return;
            }
            this.writeFile(new File(destinationDir, destinationName));
            return;
        }
        int idx = 0;
        while (idx < sourceFileArray.length) {
            if (this.read(sourceFileArray[idx])) {
                String pmi;
                String destinationName = sourceFileArray[idx].getName();
                if (destinationName.lastIndexOf(46) != -1) {
                    destinationName = destinationName.substring(0, destinationName.lastIndexOf(46));
                }
                try {
                    pmi = this.dcmMetadata.getString(2621444, null);
                }
                catch (DcmValueException e) {
                    pmi = "MONOCHROME2";
                }
                destinationName = pmi.equals("RGB") ? destinationName + ".ppm" : destinationName + ".pgm";
                this.writeFile(new File(destinationDir, destinationName));
            }
            ++idx;
        }
    }

    private void addUserTag(int tag, String value) {
        int vr = VRs.valueOf(Dcm2Pgm.dict.lookup((int)tag).vr);
        PgmCommentsUtil.addElement(this.userMetadata, tag, vr, value);
    }

    public boolean read(File f) {
        ImageReader dicomReader = null;
        try {
            Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName("DICOM");
            dicomReader = iter.next();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return false;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(f);
            dicomReader.setInput(iis, false);
            this.dcmMetadata = ((DcmMetadata)dicomReader.getStreamMetadata()).getDataset();
            this.bufferedImage = dicomReader.read(0);
            iis.close();
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    private void writeFile(File destination) {
        PGM pgm = new PGM();
        pgm.setImage(this.bufferedImage);
        if (this.includeNoMetadata) {
            pgm.write(destination);
            return;
        }
        Dataset pgmMetadata = this.includeAllMetadata ? this.dcmMetadata : PgmCommentsUtil.getDefaultInfoMetadata(PgmCommentsUtil.createPatientID(), 1, 1, 1);
        pgmMetadata.putAll(this.userMetadata);
        pgm.setMetadata(pgmMetadata);
        pgm.write(destination);
    }

    public static File uriToFile(String uriString) {
        if (uriString == null) {
            return null;
        }
        if (uriString.equals("")) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if (!uri.isAbsolute()) {
                URI baseURI = new File(System.getProperty("user.dir")).toURI();
                uri = baseURI.resolve(uri);
            }
            return new File(uri);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    static {
        VERSION = VERSION;
        dict = DictionaryFactory.getInstance().getDefaultTagDictionary();
        runAsApplication = false;
    }
}

