/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;

public class SyslogWriter
extends OutputStreamWriter {
    public final int SYSLOG_PORT = 514;
    private static final String[] MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] DAY = new String[]{null, " 1", " 2", " 3", " 4", " 5", " 6", " 7", " 8", " 9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final String[] MINUTE = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59"};
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 72;
    public static final int LOG_AUTHPRIV = 80;
    public static final int LOG_FTP = 88;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    private String localHostName;
    private String tag;
    private int facility = 8;
    private InetAddress address;
    private DatagramSocket ds;
    private boolean printHostName = true;
    private String contentPrefix = ": ";
    private final MyByteArrayOutputStream bout;
    static /* synthetic */ Class class$org$dcm4che$util$SyslogWriter;

    public static final int forName(String string) {
        try {
            return (class$org$dcm4che$util$SyslogWriter == null ? (class$org$dcm4che$util$SyslogWriter = SyslogWriter.class$("org.dcm4che.util.SyslogWriter")) : class$org$dcm4che$util$SyslogWriter).getField("LOG_" + string.toUpperCase()).getInt(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
    }

    public SyslogWriter() {
        this(new MyByteArrayOutputStream());
    }

    private SyslogWriter(MyByteArrayOutputStream myByteArrayOutputStream) {
        super(myByteArrayOutputStream);
        this.bout = myByteArrayOutputStream;
    }

    public void setSyslogHost(String string) throws UnknownHostException {
        this.address = InetAddress.getByName(string);
    }

    public void setPrintHostName(boolean bl) {
        this.printHostName = bl;
    }

    public void setContentPrefix(String string) {
        this.contentPrefix = string;
    }

    public void setFacility(int n) {
        switch (n) {
            case 0: 
            case 8: 
            case 16: 
            case 24: 
            case 32: 
            case 40: 
            case 48: 
            case 56: 
            case 64: 
            case 72: 
            case 80: 
            case 88: 
            case 128: 
            case 136: 
            case 144: 
            case 152: 
            case 160: 
            case 168: 
            case 176: 
            case 184: {
                break;
            }
            default: {
                throw new IllegalArgumentException("facility: " + n);
            }
        }
        this.facility = n;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public void writeHeader(int n) throws IOException {
        if ((n & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException("level: " + n);
        }
        this.reset();
        this.write(60);
        this.write(String.valueOf(this.facility | n));
        this.write(62);
        Calendar calendar = Calendar.getInstance();
        this.write(MONTH[calendar.get(2)]);
        this.write(32);
        this.write(DAY[calendar.get(5)]);
        this.write(32);
        this.write(MINUTE[calendar.get(11)]);
        this.write(58);
        this.write(MINUTE[calendar.get(12)]);
        this.write(58);
        this.write(MINUTE[calendar.get(13)]);
        this.write(32);
        if (this.printHostName) {
            if (this.localHostName == null) {
                this.localHostName = this.getLocalHostName();
            }
            this.write(this.localHostName);
            this.write(32);
        }
        if (this.tag != null) {
            this.write(this.tag);
        }
        this.write(this.contentPrefix);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        super.flush();
        this.bout.writeTo(outputStream);
    }

    public void write(int n, String string) throws IOException {
        this.writeHeader(n);
        this.write(string);
        this.flush();
    }

    public void writeTo(int n, String string, OutputStream outputStream) throws IOException {
        this.writeHeader(n);
        this.write(string);
        this.writeTo(outputStream);
    }

    public void reset() throws IOException {
        super.flush();
        this.bout.reset();
    }

    public void flush() throws IOException {
        if (this.address == null) {
            this.address = InetAddress.getLocalHost();
        }
        if (this.ds == null) {
            this.ds = new DatagramSocket();
        }
        super.flush();
        if (this.bout.size() > 0) {
            this.ds.send(new DatagramPacket(this.bout.getBuffer(), this.bout.size(), this.address, 514));
            this.bout.reset();
        }
    }

    private String getLocalHostName() throws UnknownHostException {
        String string = InetAddress.getLocalHost().getHostName();
        if (Character.isDigit(string.charAt(0))) {
            return string;
        }
        int n = string.indexOf(46);
        return n == -1 ? string : string.substring(0, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }
    }
}

