/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.HashMap;

class Charsets {
    static final Charset ASCII = Charset.forName("US-ASCII");
    private static HashMap CHARSETS = new HashMap(17);

    static Charset lookup(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return ASCII;
        }
        if (stringArray.length > 1) {
            throw new UnsupportedCharsetException(Arrays.asList(stringArray).toString());
        }
        Charset charset = (Charset)CHARSETS.get(stringArray[0]);
        if (charset == null) {
            throw new UnsupportedCharsetException(stringArray[0]);
        }
        return charset;
    }

    private static void put(String string, String string2) {
        try {
            CHARSETS.put(string, Charset.forName(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Charsets() {
    }

    static {
        CHARSETS.put("", ASCII);
        Charsets.put("ISO_IR 100", "ISO-8859-1");
        Charsets.put("ISO_IR 101", "ISO-8859-2");
        Charsets.put("ISO_IR 109", "ISO-8859-3");
        Charsets.put("ISO_IR 110", "ISO-8859-4");
        Charsets.put("ISO_IR 144", "ISO-8859-5");
        Charsets.put("ISO_IR 127", "ISO-8859-6");
        Charsets.put("ISO_IR 126", "ISO-8859-7");
        Charsets.put("ISO_IR 138", "ISO-8859-8");
        Charsets.put("ISO_IR 148", "ISO-8859-9");
        Charsets.put("ISO_IR 13", "EUC-JP");
        Charsets.put("ISO_IR 166", "TIS-620");
    }
}

