/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;
import org.dcm4che.server.Server;
import org.dcm4cheri.util.LF_ThreadPool;
import org.dcm4cheri.util.SSLContextAdapterImpl;

class ServerImpl
implements LF_ThreadPool.Handler,
Server {
    static final Logger log = Logger.getLogger("dcm4che.server.Server");
    private final Server.Handler handler;
    private final LF_ThreadPool threadPool = new LF_ThreadPool(this);
    private ServerSocket ss;
    private int port = 104;
    private boolean startHandshake = true;
    private boolean closeSocket = false;

    public ServerImpl(Server.Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public void setMaxClients(int n) {
        this.threadPool.setMaxRunning(n);
    }

    public void start(int n) throws IOException {
        this.start(n, ServerSocketFactory.getDefault());
    }

    public void start(int n, ServerSocketFactory serverSocketFactory) throws IOException {
        this.checkNotRunning();
        if (log.isInfoEnabled()) {
            log.info("Start Server listening at port " + n);
        }
        this.ss = serverSocketFactory.createServerSocket(n);
        new Thread(new Runnable(){

            public void run() {
                ServerImpl.this.threadPool.join();
            }
        }).start();
    }

    public void stop() {
        if (this.ss == null) {
            return;
        }
        InetAddress inetAddress = this.ss.getInetAddress();
        int n = this.ss.getLocalPort();
        if (log.isInfoEnabled()) {
            log.info("Stop Server listening at port " + n);
        }
        try {
            this.ss.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            new Socket(inetAddress, n).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ss = null;
        this.threadPool.shutdown();
    }

    public void run(LF_ThreadPool lF_ThreadPool) {
        Socket socket;
        block11: {
            if (this.ss == null) {
                return;
            }
            socket = null;
            try {
                socket = this.ss.accept();
                if (log.isInfoEnabled()) {
                    log.info("handle - " + socket);
                }
                if (socket instanceof SSLSocket) {
                    this.prepare((SSLSocket)socket);
                }
                lF_ThreadPool.promoteNewLeader();
                this.handler.handle(socket);
                if (!this.handler.isSockedClosedByHandler() && socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                log.error(iOException);
                if (socket == null) break block11;
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info("finished - " + socket);
        }
    }

    private void checkNotRunning() {
        if (this.ss != null) {
            throw new IllegalStateException("Already Running - " + this.threadPool);
        }
    }

    private void prepare(SSLSocket sSLSocket) throws IOException {
        if (this.startHandshake) {
            sSLSocket.startHandshake();
        }
        if (log.isInfoEnabled()) {
            log.info(SSLContextAdapterImpl.toInfoMsg(sSLSocket, false));
            log.info(SSLContextAdapterImpl.toInfoMsg(sSLSocket, true));
        }
    }
}

