/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4cheri.data.BaseDatasetImpl;
import org.dcm4cheri.data.Charsets;
import org.dcm4cheri.data.DcmObjectImpl;
import org.dcm4cheri.data.DcmParserImpl;
import org.dcm4cheri.data.SQElement;

final class DatasetImpl
extends BaseDatasetImpl
implements Dataset {
    private final Dataset parent;
    private Charset charset = null;
    private String privateCreatorID = null;
    private long itemOffset = -1L;

    DatasetImpl() {
        this(null);
    }

    DatasetImpl(Dataset dataset) {
        this.parent = dataset;
    }

    public Charset getCharset() {
        return this.charset != null ? this.charset : (this.parent != null ? this.parent.getCharset() : null);
    }

    public final Dataset getParent() {
        return this.parent;
    }

    public final Dataset setItemOffset(long l) {
        this.itemOffset = l;
        return this;
    }

    public final long getItemOffset() {
        if (this.itemOffset != -1L || this.list.isEmpty()) {
            return this.itemOffset;
        }
        long l = ((DcmElement)this.list.get(0)).getStreamPosition();
        return l == -1L ? -1L : l - 8L;
    }

    public DcmElement putSQ(int n) {
        return this.put(new SQElement(n, this));
    }

    protected DcmElement put(DcmElement dcmElement) {
        if (dcmElement.tag() >>> 16 < 4) {
            throw new IllegalArgumentException(dcmElement.toString());
        }
        if (dcmElement.tag() == 524293) {
            try {
                this.charset = Charsets.lookup(dcmElement.getStrings(null));
            }
            catch (Exception exception) {
                DcmObjectImpl.log.warn("Failed to consider specified Charset!", exception);
                this.charset = null;
            }
        }
        return super.put(dcmElement);
    }

    public DcmElement remove(int n) {
        if (n == 524293) {
            this.charset = null;
        }
        return super.remove(n);
    }

    public void clear() {
        super.clear();
        this.charset = null;
        this.totLen = 0;
    }

    public void readFile(InputStream inputStream, FileFormat fileFormat, int n) throws IOException, DcmValueException {
        DcmParserImpl dcmParserImpl = new DcmParserImpl(inputStream);
        dcmParserImpl.setDcmHandler(this.getDcmHandler());
        dcmParserImpl.parseDcmFile(fileFormat, n);
    }

    public void readDataset(InputStream inputStream, DcmDecodeParam dcmDecodeParam, int n) throws IOException, DcmValueException {
        DcmParserImpl dcmParserImpl = new DcmParserImpl(inputStream);
        dcmParserImpl.setDcmHandler(this.getDcmHandler());
        dcmParserImpl.parseDataset(dcmDecodeParam, n);
    }

    public void readFile(ImageInputStream imageInputStream, FileFormat fileFormat, int n) throws IOException, DcmValueException {
        DcmParserImpl dcmParserImpl = new DcmParserImpl(imageInputStream);
        dcmParserImpl.setDcmHandler(this.getDcmHandler());
        dcmParserImpl.parseDcmFile(fileFormat, n);
    }
}

