/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.CodeContent;
import org.dcm4che.srom.CompositeContent;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.DateContent;
import org.dcm4che.srom.DateTimeContent;
import org.dcm4che.srom.Equipment;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.NumContent;
import org.dcm4che.srom.PNameContent;
import org.dcm4che.srom.Patient;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.RelationConstraints;
import org.dcm4che.srom.Request;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.Series;
import org.dcm4che.srom.Study;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TextContent;
import org.dcm4che.srom.TimeContent;
import org.dcm4che.srom.UIDRefContent;
import org.dcm4che.srom.WaveformContent;
import org.dcm4cheri.srom.CodeContentImpl;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.CompositeContentImpl;
import org.dcm4cheri.srom.ContainerContentImpl;
import org.dcm4cheri.srom.ContentImpl;
import org.dcm4cheri.srom.DateContentImpl;
import org.dcm4cheri.srom.DateTimeContentImpl;
import org.dcm4cheri.srom.EquipmentImpl;
import org.dcm4cheri.srom.ImageContentImpl;
import org.dcm4cheri.srom.NumContentImpl;
import org.dcm4cheri.srom.PNameContentImpl;
import org.dcm4cheri.srom.PatientImpl;
import org.dcm4cheri.srom.ReferencedContentImpl;
import org.dcm4cheri.srom.RelationConstraintsImpl;
import org.dcm4cheri.srom.RequestImpl;
import org.dcm4cheri.srom.SCoordContentImpl;
import org.dcm4cheri.srom.SOPInstanceRefImpl;
import org.dcm4cheri.srom.SeriesImpl;
import org.dcm4cheri.srom.StudyImpl;
import org.dcm4cheri.srom.TCoordContentImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.TextContentImpl;
import org.dcm4cheri.srom.TimeContentImpl;
import org.dcm4cheri.srom.UIDRefContentImpl;
import org.dcm4cheri.srom.WaveformContentImpl;

class KeyObjectImpl
extends ContainerContentImpl
implements KeyObject {
    protected Patient patient;
    protected Study study;
    protected Series series;
    protected Equipment equipment;
    protected final String modality;
    protected final String sopClassUID;
    protected String sopInstanceUID;
    protected String specificCharacterSet;
    protected Long instanceCreationDateTime;
    protected String instanceCreatorUID;
    protected int instanceNumber = 1;
    protected long contentDateTime = Calendar.getInstance().getTime().getTime();
    protected final List requests = new LinkedList();
    protected final List currentEvidence = new LinkedList();
    protected final List identicalDocuments = new LinkedList();
    protected final RelationConstraints relConstraints;

    KeyObjectImpl(Patient patient, Study study, Series series, Equipment equipment, String string, int n, Date date, Code code, boolean bl) {
        this(patient, study, series, equipment, "1.2.840.10008.5.1.4.1.1.88.59", string, n, date, TemplateImpl.TID_2010, code, bl, "KO");
    }

    protected KeyObjectImpl(Patient patient, Study study, Series series, Equipment equipment, String string, String string2, int n, Date date, Template template, Code code, boolean bl, String string3) {
        super(null, date, template, code, bl);
        this.owner = this;
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (code == null) {
            throw new NullPointerException();
        }
        this.sopClassUID = string;
        this.sopInstanceUID = string2;
        this.instanceNumber = n;
        this.modality = string3;
        this.relConstraints = RelationConstraintsImpl.valueOf(string);
        this.setPatient(patient);
        this.setStudy(study);
        this.setSeries(series);
        this.setEquipment(equipment);
    }

    static KeyObject newKeyObject(Dataset dataset) throws DcmValueException {
        String string = dataset.getString(524310);
        if (!"1.2.840.10008.5.1.4.1.1.88.59".equals(string)) {
            throw new IllegalArgumentException(string);
        }
        TemplateImpl templateImpl = new TemplateImpl(dataset.getItem(4236548));
        if (!TemplateImpl.TID_2010.equals(templateImpl)) {
            throw new IllegalArgumentException(((Object)templateImpl).toString());
        }
        if (!"CONTAINER".equals(dataset.getString(0x40A040))) {
            throw new IllegalArgumentException(dataset.getString(0x40A040));
        }
        KeyObjectImpl keyObjectImpl = new KeyObjectImpl(new PatientImpl(dataset), new StudyImpl(dataset), new SeriesImpl(dataset), new EquipmentImpl(dataset), dataset.getString(524312), dataset.getInt(2097171, -1), dataset.getDate(4235314), new CodeImpl(dataset.getItem(4235331)), "SEPARATE".equals(dataset.getString(4235344)));
        keyObjectImpl.init(dataset);
        return keyObjectImpl;
    }

    protected void init(Dataset dataset) throws DcmValueException {
        this.setSpecificCharacterSet(dataset.getString(524293));
        this.setInstanceCreationDateTime(dataset.getDateTime(524306, 524307));
        this.setContentDateTime(dataset.getDateTime(524323, 524339));
        this.initRequests(dataset.get(4236144));
        this.initSOPInstanceRefList(this.currentEvidence, dataset.get(4236149));
        this.initSOPInstanceRefList(this.identicalDocuments, dataset.get(4236581));
        super.initChilds(this, dataset);
    }

    protected void initRequests(DcmElement dcmElement) throws DcmValueException {
        if (dcmElement == null) {
            return;
        }
        int n = 0;
        int n2 = dcmElement.vm();
        while (n < n2) {
            this.requests.add(new RequestImpl(dcmElement.getItem(n)));
            ++n;
        }
    }

    protected void initSOPInstanceRefList(List list, DcmElement dcmElement) throws DcmValueException {
        if (dcmElement == null) {
            return;
        }
        int n = 0;
        int n2 = dcmElement.vm();
        while (n < n2) {
            Dataset dataset = dcmElement.getItem(n);
            String string = dataset.getString(0x20000D);
            DcmElement dcmElement2 = dataset.get(528661);
            int n3 = 0;
            int n4 = dcmElement2.vm();
            while (n3 < n4) {
                Dataset dataset2 = dcmElement2.getItem(n3);
                String string2 = dataset2.getString(0x20000E);
                DcmElement dcmElement3 = dataset2.get(528793);
                int n5 = 0;
                int n6 = dcmElement3.vm();
                while (n5 < n6) {
                    Dataset dataset3 = dcmElement3.getItem(n5);
                    list.add(new SOPInstanceRefImpl(dataset3.getString(528720), dataset3.getString(528725), string2, string));
                    ++n5;
                }
                ++n3;
            }
            ++n;
        }
    }

    public String toString() {
        return "Key Object Selection Document[" + this.getName().getCodeMeaning() + "," + this.getSOPInstanceUID() + ",#" + this.getInstanceNumber() + "," + this.getContentDateTime() + "]";
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        if (patient == null) {
            throw new NullPointerException();
        }
        this.patient = patient;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        if (study == null) {
            throw new NullPointerException();
        }
        this.study = study;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        if (!this.modality.equals(series.getModality())) {
            throw new IllegalArgumentException(series.getModality());
        }
        this.series = series;
    }

    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = new EquipmentImpl(equipment);
    }

    public RelationConstraints getRelationConstraints() {
        return this.relConstraints;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public void setSOPInstanceUID(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.sopInstanceUID = string;
    }

    public String getSpecificCharacterSet() {
        return this.specificCharacterSet;
    }

    public void setSpecificCharacterSet(String string) {
        this.specificCharacterSet = string;
    }

    public Date getInstanceCreationDateTime() {
        return this.instanceCreationDateTime != null ? new Date(this.instanceCreationDateTime) : null;
    }

    public void setInstanceCreationDateTime(Date date) {
        this.instanceCreationDateTime = date != null ? new Long(date.getTime()) : null;
    }

    public String getInstanceCreatorUID() {
        return this.instanceCreatorUID;
    }

    public void setInstanceCreatorUID(String string) {
        this.instanceCreatorUID = string;
    }

    public void setInstanceNumber(int n) {
        this.instanceNumber = n;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setContentDateTime(Date date) {
        this.contentDateTime = date.getTime();
    }

    public Date getContentDateTime() {
        return new Date(this.contentDateTime);
    }

    protected static List checkList(Object[] objectArray) {
        if (objectArray == null) {
            return Collections.EMPTY_LIST;
        }
        List<Object> list = Arrays.asList(objectArray);
        int n = list.indexOf(null);
        if (n != -1) {
            throw new NullPointerException("[" + n + "]");
        }
        return list;
    }

    protected static SOPInstanceRef findSOPInstanceRef(List list, RefSOP refSOP) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!refSOP.equals(e)) continue;
            return (SOPInstanceRef)e;
        }
        return null;
    }

    public Request[] getRequests() {
        return this.requests.toArray(RequestImpl.EMPTY_ARRAY);
    }

    public void setRequests(Request[] requestArray) {
        List list = KeyObjectImpl.checkList(requestArray);
        this.requests.clear();
        this.requests.addAll(list);
    }

    public boolean addRequest(Request request) {
        if (request == null) {
            throw new NullPointerException();
        }
        if (this.requests.indexOf(request) != -1) {
            return false;
        }
        return this.requests.add(request);
    }

    public boolean removeRequest(Request request) {
        return this.requests.remove(request);
    }

    public SOPInstanceRef[] getCurrentEvidence() {
        return this.currentEvidence.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public SOPInstanceRef findCurrentEvidence(RefSOP refSOP) {
        return KeyObjectImpl.findSOPInstanceRef(this.currentEvidence, refSOP);
    }

    public void setCurrentEvidence(SOPInstanceRef[] sOPInstanceRefArray) {
        List list = KeyObjectImpl.checkList(sOPInstanceRefArray);
        this.currentEvidence.clear();
        this.currentEvidence.addAll(list);
    }

    public boolean addCurrentEvidence(SOPInstanceRef sOPInstanceRef) {
        if (sOPInstanceRef == null) {
            throw new NullPointerException();
        }
        if (this.currentEvidence.indexOf(sOPInstanceRef) != -1) {
            return false;
        }
        return this.currentEvidence.add(sOPInstanceRef);
    }

    public boolean removeCurrentEvidence(RefSOP refSOP) {
        return this.currentEvidence.remove(refSOP);
    }

    public SOPInstanceRef[] getIdenticalDocuments() {
        return this.identicalDocuments.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public void setIdenticalDocuments(SOPInstanceRef[] sOPInstanceRefArray) {
        List list = KeyObjectImpl.checkList(sOPInstanceRefArray);
        this.identicalDocuments.clear();
        this.identicalDocuments.addAll(list);
    }

    public boolean addIdenticalDocument(SOPInstanceRef sOPInstanceRef) {
        if (sOPInstanceRef == null) {
            throw new NullPointerException();
        }
        if (this.identicalDocuments.indexOf(sOPInstanceRef) != -1) {
            return false;
        }
        return this.identicalDocuments.add(sOPInstanceRef);
    }

    public boolean removeIdenticalDocument(RefSOP refSOP) {
        return this.identicalDocuments.remove(refSOP);
    }

    private static Content getChild(Content content, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = n;
        Content content2 = content.getFirstChild();
        while (content2 != null) {
            if (--n2 == 0) {
                return content2;
            }
            content2 = content2.getNextSibling();
        }
        return null;
    }

    public Content getContent(int[] nArray) {
        if (nArray.length == 0 || nArray[0] != 1) {
            throw new IllegalArgumentException();
        }
        Content content = this;
        int n = 1;
        while (n < nArray.length) {
            content = KeyObjectImpl.getChild(content, nArray[n]);
            ++n;
        }
        return content;
    }

    public ContainerContent createContainerContent(Date date, Template template, Code code, boolean bl) {
        return new ContainerContentImpl(this, date, template, code, bl);
    }

    public TextContent createTextContent(Date date, Template template, Code code, String string) {
        return new TextContentImpl(this, date, template, code, string);
    }

    public PNameContent createPNameContent(Date date, Template template, Code code, String string) {
        return new PNameContentImpl(this, date, template, code, string);
    }

    public UIDRefContent createUIDRefContent(Date date, Template template, Code code, String string) {
        return new UIDRefContentImpl(this, date, template, code, string);
    }

    public CodeContent createCodeContent(Date date, Template template, Code code, Code code2) {
        return new CodeContentImpl(this, date, template, code, code2);
    }

    public NumContent createNumContent(Date date, Template template, Code code, float f, Code code2) {
        return new NumContentImpl(this, date, template, code, f, code2);
    }

    public DateContent createDateContent(Date date, Template template, Code code, Date date2) {
        return new DateContentImpl((KeyObject)this, date, template, code, date2);
    }

    public TimeContent createTimeContent(Date date, Template template, Code code, Date date2) {
        return new TimeContentImpl((KeyObject)this, date, template, code, date2);
    }

    public DateTimeContent createDateTimeContent(Date date, Template template, Code code, Date date2) {
        return new DateTimeContentImpl((KeyObject)this, date, template, code, date2);
    }

    public CompositeContent createCompositeContent(Date date, Template template, Code code, RefSOP refSOP) {
        return new CompositeContentImpl(this, date, template, code, refSOP);
    }

    public ImageContent createImageContent(Date date, Template template, Code code, RefSOP refSOP, int[] nArray, RefSOP refSOP2) {
        return new ImageContentImpl(this, date, template, code, refSOP, nArray, refSOP2);
    }

    public WaveformContent createWaveformContent(Date date, Template template, Code code, RefSOP refSOP, int[] nArray) {
        return new WaveformContentImpl(this, date, template, code, refSOP, nArray);
    }

    public SCoordContent.Point createPointSCoordContent(Date date, Template template, Code code, float[] fArray) {
        return new SCoordContentImpl.Point(this, date, template, code, fArray);
    }

    public SCoordContent.MultiPoint createMultiPointSCoordContent(Date date, Template template, Code code, float[] fArray) {
        return new SCoordContentImpl.MultiPoint(this, date, template, code, fArray);
    }

    public SCoordContent.Polyline createPolylineSCoordContent(Date date, Template template, Code code, float[] fArray) {
        return new SCoordContentImpl.Polyline(this, date, template, code, fArray);
    }

    public SCoordContent.Circle createCircleSCoordContent(Date date, Template template, Code code, float[] fArray) {
        return new SCoordContentImpl.Circle(this, date, template, code, fArray);
    }

    public SCoordContent.Ellipse createEllipseSCoordContent(Date date, Template template, Code code, float[] fArray) {
        return new SCoordContentImpl.Ellipse(this, date, template, code, fArray);
    }

    public TCoordContent.Point createPointTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Point(this, date, template, code, positions);
    }

    public TCoordContent.MultiPoint createMultiPointTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.MultiPoint(this, date, template, code, positions);
    }

    public TCoordContent.Segment createSegmentTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Segment(this, date, template, code, positions);
    }

    public TCoordContent.MultiSegment createMultiSegmentTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.MultiSegment(this, date, template, code, positions);
    }

    public TCoordContent.Begin createBeginTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.Begin(this, date, template, code, positions);
    }

    public TCoordContent.End createEndTCoordContent(Date date, Template template, Code code, TCoordContent.Positions positions) {
        return new TCoordContentImpl.End(this, date, template, code, positions);
    }

    public ReferencedContent createReferencedContent(Content content) {
        return new ReferencedContentImpl((KeyObject)this, content);
    }

    public ReferencedContent createReferencedContent(int[] nArray) {
        return new ReferencedContentImpl((KeyObject)this, nArray);
    }

    public Content importContent(Content content, boolean bl) {
        return ((ContentImpl)content).clone(this, bl, true);
    }

    protected static void sopInstanceRefListToSQ(List list, DcmElement dcmElement) {
        LinkedList<Object> linkedList;
        HashMap hashMap;
        Object object;
        HashMap hashMap2 = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (SOPInstanceRef)iterator.next();
            hashMap = (HashMap)hashMap2.get(object.getStudyInstanceUID());
            if (hashMap == null) {
                hashMap = new HashMap();
                hashMap2.put(object.getStudyInstanceUID(), hashMap);
            }
            if ((linkedList = (List)hashMap.get(object.getSeriesInstanceUID())) == null) {
                linkedList = new LinkedList<Object>();
                hashMap.put(object.getSeriesInstanceUID(), linkedList);
            }
            linkedList.add(object);
        }
        object = hashMap2.entrySet().iterator();
        while (object.hasNext()) {
            hashMap = (Map.Entry)object.next();
            linkedList = dcmElement.addNewItem();
            linkedList.putUI(0x20000D, (String)hashMap.getKey());
            DcmElement dcmElement2 = linkedList.putSQ(528661);
            Iterator iterator2 = ((Map)hashMap.getValue()).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                Dataset dataset = dcmElement2.addNewItem();
                dataset.putUI(0x20000E, (String)entry.getKey());
                DcmElement dcmElement3 = dataset.putSQ(528793);
                Iterator iterator3 = ((List)hashMap.getValue()).iterator();
                while (iterator3.hasNext()) {
                    ((SOPInstanceRef)iterator3.next()).toDataset(dcmElement3.addNewItem());
                }
            }
        }
    }

    public void toDataset(Dataset dataset) {
        Date date;
        if (this.specificCharacterSet != null) {
            dataset.putCS(524293, this.specificCharacterSet);
        }
        dataset.putUI(524310, this.sopClassUID);
        dataset.putUI(524312, this.sopInstanceUID);
        dataset.putIS(2097171, this.instanceNumber);
        if (this.instanceCreationDateTime != null) {
            date = new Date(this.instanceCreationDateTime);
            dataset.putDA(524306, date);
            dataset.putTM(524307, date);
        }
        date = this.getContentDateTime();
        dataset.putDA(524323, date);
        dataset.putTM(524339, date);
        this.patient.toDataset(dataset);
        this.study.toDataset(dataset);
        this.series.toDataset(dataset);
        this.equipment.toDataset(dataset);
        if (!this.requests.isEmpty()) {
            DcmElement dcmElement = dataset.putSQ(4236144);
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                ((Request)iterator.next()).toDataset(dcmElement.addNewItem());
            }
        }
        if (!this.currentEvidence.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.currentEvidence, dataset.putSQ(4236149));
        }
        if (!this.identicalDocuments.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.currentEvidence, dataset.putSQ(4236581));
        }
        super.toDataset(dataset);
    }

    public Dataset toDataset() {
        Dataset dataset = ContentImpl.dsfact.newDataset();
        this.toDataset(dataset);
        return dataset;
    }
}

