/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Template;

class TemplateImpl
implements Template {
    public static final Template TID_2010 = new TemplateImpl("2010", "DCMR", null, null);
    private static final int MEANING_PROMPT_LEN = 20;
    private final String templateIdentifier;
    private final String mappingResource;
    private final Long templateVersion;
    private final Long templateLocalVersion;

    public TemplateImpl(String string, String string2, Date date, Date date2) {
        this.templateIdentifier = string;
        if (this.templateIdentifier.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.mappingResource = string2;
        if (this.mappingResource.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.templateVersion = date != null ? new Long(date.getTime()) : null;
        this.templateLocalVersion = date2 != null ? new Long(date2.getTime()) : null;
    }

    public TemplateImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(4250368), dataset.getString(524549), dataset.getDate(4250374), dataset.getDate(4250375));
    }

    public static Template newTemplate(Dataset dataset) throws DcmValueException {
        return dataset != null ? new TemplateImpl(dataset) : null;
    }

    public String getTemplateIdentifier() {
        return this.templateIdentifier;
    }

    public String getMappingResource() {
        return this.mappingResource;
    }

    public Date getTemplateVersion() {
        return this.templateVersion != null ? new Date(this.templateVersion) : null;
    }

    public Date getTemplateLocalVersion() {
        return this.templateLocalVersion != null ? new Date(this.templateLocalVersion) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl templateImpl = (TemplateImpl)object;
        if (!this.templateIdentifier.equals(templateImpl.templateIdentifier)) {
            return false;
        }
        if (!this.mappingResource.equals(templateImpl.mappingResource)) {
            return false;
        }
        if (this.templateVersion == null ? templateImpl.templateVersion != null : !this.templateVersion.equals(templateImpl.templateVersion)) {
            return false;
        }
        return !(this.templateLocalVersion == null ? templateImpl.templateLocalVersion != null : !this.templateLocalVersion.equals(templateImpl.templateVersion));
    }

    public int hashCode() {
        return this.templateIdentifier.hashCode();
    }

    public String toString() {
        return "TID" + this.templateIdentifier + "@" + this.mappingResource;
    }

    public void toDataset(Dataset dataset) {
        dataset.putCS(4250368, this.templateIdentifier);
        dataset.putCS(524549, this.mappingResource);
        if (this.templateVersion != null) {
            dataset.putDT(4250374, new Date(this.templateVersion));
        }
        if (this.templateLocalVersion != null) {
            dataset.putDT(4250375, new Date(this.templateLocalVersion));
            dataset.putCS(4250379, "Y");
        }
    }
}

