/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.io.ByteArrayOutputStream;
import org.dcm4che.hl7.MSHSegment;
import org.dcm4cheri.hl7.HL7SegmentImpl;

public class MSHSegmentImpl
extends HL7SegmentImpl
implements MSHSegment {
    private static final byte[] START_WITH = new byte[]{77, 83, 72, 124, 94, 126, 92, 38, 124};
    private static final byte[] ACK = new byte[]{124, 124, 124, 65, 67, 75, 124, 65};
    private static final byte[] MSA = new byte[]{13, 77, 83, 65, 124};
    private static final byte[] ERR = new byte[]{13, 69, 82, 82, 124};
    public final String sendingApplication;
    public final String sendingFacility;
    public final String receivingApplication;
    public final String receivingFacility;
    public final String messageType;
    public final String triggerEvent;
    public final String messageControlID;

    MSHSegmentImpl(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        int n3 = 0;
        while (n3 < START_WITH.length) {
            if (byArray[n + n3] != START_WITH[n3]) {
                throw new IllegalArgumentException(this.toString());
            }
            ++n3;
        }
        this.sendingApplication = this.get(3);
        this.sendingFacility = this.get(4);
        this.receivingApplication = this.get(5);
        this.receivingFacility = this.get(6);
        this.messageType = this.get(9, 1, 1);
        this.triggerEvent = this.get(9, 1, 2);
        this.messageControlID = this.get(10);
    }

    public final String getSendingApplication() {
        return this.sendingApplication;
    }

    public final String getSendingFacility() {
        return this.sendingFacility;
    }

    public final String getReceivingApplication() {
        return this.receivingApplication;
    }

    public final String getReceivingFacility() {
        return this.receivingFacility;
    }

    public final String getMessageType() {
        return this.messageType;
    }

    public final String getTriggerEvent() {
        return this.triggerEvent;
    }

    public final String getMessageControlID() {
        return this.messageControlID;
    }

    public int size() {
        return super.size() + 1;
    }

    public String get(int n) {
        switch (n) {
            case 0: {
                return "MSH";
            }
            case 1: {
                return "|";
            }
        }
        return super.get(n - 1);
    }

    public String get(int n, int n2) {
        if (n < 2) {
            throw new IllegalArgumentException("seq: " + n);
        }
        return super.get(n - 1, n2);
    }

    public String get(int n, int n2, int n3) {
        if (n < 2) {
            throw new IllegalArgumentException("seq: " + n);
        }
        return super.get(n - 1, n2, n3);
    }

    public String get(int n, int n2, int n3, int n4) {
        if (n < 2) {
            throw new IllegalArgumentException("seq: " + n);
        }
        return super.get(n - 1, n2, n3, n4);
    }

    public void writeTo(int n, ByteArrayOutputStream byteArrayOutputStream) {
        if (n < 2) {
            throw new IllegalArgumentException("seq: " + n);
        }
        super.writeTo(n - 1, byteArrayOutputStream);
    }

    private void writeTo(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    byte[] ack(byte[] byArray, String string, String string2, String string3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
        this.writeTo(START_WITH, byteArrayOutputStream);
        this.writeTo(5, byteArrayOutputStream);
        byteArrayOutputStream.write(124);
        this.writeTo(6, byteArrayOutputStream);
        byteArrayOutputStream.write(124);
        this.writeTo(3, byteArrayOutputStream);
        byteArrayOutputStream.write(124);
        this.writeTo(4, byteArrayOutputStream);
        this.writeTo(ACK, byteArrayOutputStream);
        if (this.messageControlID.length() < 20) {
            this.writeTo(10, byteArrayOutputStream);
        } else {
            this.writeTo(this.messageControlID.substring(1).getBytes(), byteArrayOutputStream);
        }
        byteArrayOutputStream.write(124);
        this.writeTo(11, byteArrayOutputStream);
        byteArrayOutputStream.write(124);
        this.writeTo(12, byteArrayOutputStream);
        this.writeTo(MSA, byteArrayOutputStream);
        this.writeTo(byArray, byteArrayOutputStream);
        byteArrayOutputStream.write(124);
        this.writeTo(10, byteArrayOutputStream);
        if (string != null || string2 != null) {
            byteArrayOutputStream.write(124);
            if (string != null) {
                this.writeTo(string.getBytes(), byteArrayOutputStream);
            }
            if (string2 != null) {
                byteArrayOutputStream.write(124);
                byteArrayOutputStream.write(124);
                byteArrayOutputStream.write(124);
                this.writeTo(string2.getBytes(), byteArrayOutputStream);
            }
        }
        if (string3 != null) {
            this.writeTo(ERR, byteArrayOutputStream);
            this.writeTo(string3.getBytes(), byteArrayOutputStream);
        }
        byteArrayOutputStream.write(13);
        return byteArrayOutputStream.toByteArray();
    }
}

