/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.data.FileFormat;
import org.dcm4che.image.ColorModelFactory;
import org.dcm4cheri.imageio.plugins.DcmMetadataImpl;

public class DcmImageReader
extends ImageReader {
    static final DcmParserFactory pfact = DcmParserFactory.getInstance();
    private static final ColorModelFactory cmFactory = ColorModelFactory.getInstance();
    private static final int TAG_PIXELDATA = 2145386512;
    private ImageInputStream stream = null;
    private BufferedImage theImage = null;
    private WritableRaster theTile = null;
    private DcmParser theParser = null;
    private DcmMetadataImpl theMetadata = null;
    private Dataset theDataset = null;
    private long[] frameStartPos = null;
    private int width = -1;
    private int height = -1;
    private int planes = 0;
    private String pmi = null;
    private int dataType = 0;
    private int sourceXOffset;
    private int sourceYOffset;
    private int sourceWidth;
    private int sourceHeight;
    private int sourceXSubsampling;
    private int sourceYSubsampling;
    private int subsamplingXOffset;
    private int subsamplingYOffset;
    private int destXOffset;
    private int destYOffset;
    private int destWidth;
    private int totDestWidth;
    private int totDestHeight;
    private static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final ImageTypeSpecifier RGB_PLANE = ImageTypeSpecifier.createBanded(sRGB, new int[]{0, 1, 2}, new int[]{0, 0, 0}, 0, false, false);
    private static final ImageTypeSpecifier RGB_PIXEL = ImageTypeSpecifier.createInterleaved(sRGB, new int[]{0, 1, 2}, 0, false, false);

    public DcmImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        if (object != null) {
            if (!(object instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)object;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    public int getNumImages(boolean bl) throws IOException {
        this.readMetadata();
        return this.frameStartPos.length;
    }

    private void checkIndex(int n) {
        if (n >= this.frameStartPos.length) {
            throw new IndexOutOfBoundsException("index: " + n + ", frames: " + this.frameStartPos.length);
        }
    }

    public int getWidth(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        return this.width;
    }

    public int getHeight(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        return this.height;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        this.readMetadata();
        return this.theMetadata;
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        return null;
    }

    private void readMetadata() throws IOException {
        if (this.theMetadata != null) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.theParser = pfact.newDcmParser(this.stream);
        FileFormat fileFormat = this.theParser.detectFileFormat();
        if (fileFormat == null) {
            throw new IOException("Unrecognized file format!");
        }
        this.theDataset = DcmObjectFactory.getInstance().newDataset();
        this.theParser.setDcmHandler(this.theDataset.getDcmHandler());
        this.theParser.parseDcmFile(fileFormat, 2145386512);
        this.theMetadata = new DcmMetadataImpl(this.theDataset);
        if (this.theParser.getReadTag() != 2145386512) {
            this.frameStartPos = new long[0];
        } else {
            this.initParams();
        }
    }

    private void initParams() throws IOException {
        int n = this.theDataset.getInt(2621696, 8);
        switch (n) {
            case 8: {
                this.dataType = 0;
                break;
            }
            case 16: {
                this.dataType = 1;
                break;
            }
            default: {
                throw new IOException("" + n + " Bits Allocated not supported!");
            }
        }
        this.frameStartPos = new long[this.theDataset.getInt(0x280008, 1)];
        int n2 = this.theParser.getReadLength();
        if (n2 == -1) {
            throw new IOException("Encapsulate Pixel Data not supported by this version!");
        }
        if (n2 % this.frameStartPos.length != 0) {
            throw new DcmValueException("Invalid Length of Pixel Data: " + n2);
        }
        int n3 = n2 / this.frameStartPos.length;
        this.frameStartPos[0] = this.theParser.getStreamPosition();
        int n4 = 1;
        while (n4 < this.frameStartPos.length) {
            this.frameStartPos[n4] = this.frameStartPos[n4 - 1] + (long)n3;
            ++n4;
        }
        this.width = this.theDataset.getInt(2621457, 0);
        this.height = this.theDataset.getInt(2621456, 0);
        this.pmi = this.theDataset.getString(2621444, null);
        this.planes = this.theDataset.getInt(2621446, 0);
        if ("RGB".equals(this.pmi)) {
            if (n == 16) {
                throw new IOException("RGB 16 Bits allocated not supported!");
            }
            if (n3 != 3 * this.width * this.height) {
                throw new DcmValueException("Invalid Length of Pixel Data: " + n2);
            }
            return;
        }
        int n5 = n3 - this.width * this.height * (n >> 3);
        if (n5 != 0) {
            if (n5 < 0) {
                throw new DcmValueException("Invalid Length of Pixel Data: " + n2);
            }
            System.err.println("Warning: Pixel Data too long. Try to read anyway");
        }
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        if ("RGB".equals(this.pmi)) {
            arrayList.add(this.planes != 0 ? RGB_PLANE : RGB_PIXEL);
        } else {
            arrayList.add(new ImageTypeSpecifier(cmFactory.getColorModel(cmFactory.makeParam(this.theDataset)), new PixelInterleavedSampleModel(this.dataType, 1, 1, 1, 1, new int[]{0})));
        }
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.readMetadata();
        this.checkIndex(n);
        this.stream.seek(this.frameStartPos[n]);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        Iterator iterator = this.getImageTypes(n);
        this.theImage = ImageReader.getDestination(imageReadParam, iterator, this.width, this.height);
        this.theTile = this.theImage.getWritableTile(0, 0);
        Rectangle rectangle = ImageReader.getSourceRegion(imageReadParam, this.width, this.height);
        this.sourceXOffset = rectangle.x;
        this.sourceYOffset = rectangle.y;
        this.sourceWidth = rectangle.width;
        this.sourceHeight = rectangle.height;
        this.sourceXSubsampling = imageReadParam.getSourceXSubsampling();
        this.sourceYSubsampling = imageReadParam.getSourceYSubsampling();
        this.subsamplingXOffset = imageReadParam.getSubsamplingXOffset();
        this.subsamplingYOffset = imageReadParam.getSubsamplingYOffset();
        Point point = imageReadParam.getDestinationOffset();
        this.destXOffset = point.x;
        this.destYOffset = point.y;
        this.destWidth = this.sourceWidth / this.sourceXSubsampling;
        this.totDestWidth = this.theTile.getWidth();
        this.totDestHeight = this.theTile.getHeight();
        if (this.destXOffset < 0) {
            this.sourceXOffset -= this.destXOffset * this.sourceXSubsampling;
            if ((this.sourceWidth += this.destXOffset * this.sourceXSubsampling) < 0) {
                this.sourceWidth = 0;
            }
            this.destXOffset = 0;
        }
        if (this.destYOffset < 0) {
            this.sourceYOffset -= this.destYOffset * this.sourceYSubsampling;
            if ((this.sourceHeight += this.destYOffset * this.sourceYSubsampling) < 0) {
                this.sourceHeight = 0;
            }
            this.destYOffset = 0;
        }
        DataBuffer dataBuffer = this.theTile.getDataBuffer();
        if (this.dataType == 0) {
            if ("RGB".equals(this.pmi)) {
                if (this.planes != 0) {
                    this.readByteSamples(1, ((DataBufferByte)dataBuffer).getData(0));
                    this.readByteSamples(1, ((DataBufferByte)dataBuffer).getData(1));
                    this.readByteSamples(1, ((DataBufferByte)dataBuffer).getData(2));
                } else {
                    this.readByteSamples(3, ((DataBufferByte)dataBuffer).getData());
                }
            } else {
                this.readByteSamples(1, ((DataBufferByte)dataBuffer).getData());
            }
        } else {
            this.readWordSamples(1, ((DataBufferUShort)dataBuffer).getData());
        }
        return this.theImage;
    }

    private void readByteSamples(int n, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        int n2 = this.width * n;
        int n3 = this.sourceWidth * n;
        int n4 = this.sourceXOffset * n;
        int n5 = this.destXOffset * n;
        if (this.sourceXSubsampling != 1) {
            byArray2 = new byte[n3];
        }
        int n6 = this.totDestHeight * this.totDestWidth;
        int n7 = this.totDestWidth * n;
        this.stream.skipBytes(n2 * this.sourceYOffset);
        int n8 = this.destYOffset;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        try {
            n12 = 0;
            while (n12 < this.sourceHeight) {
                if ((n12 - this.subsamplingYOffset) % this.sourceYSubsampling != 0) {
                    this.stream.skipBytes(n2);
                } else {
                    this.stream.skipBytes(n4);
                    if (this.sourceXSubsampling == 1) {
                        this.stream.readFully(byArray, n8 * n7 + n5, n3);
                    } else {
                        this.stream.readFully(byArray2);
                        n9 = n8 * this.totDestWidth + this.destXOffset;
                        n10 = Math.min(n9 + this.destWidth, n6);
                        switch (n) {
                            case 1: {
                                n11 = 0;
                                while (n9 < n10) {
                                    if ((n11 - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                        byArray[n9++] = byArray2[n11];
                                    }
                                    ++n11;
                                }
                                break;
                            }
                            case 3: {
                                n11 = 0;
                                int n13 = 0;
                                int n14 = n9 * 3;
                                while (n9 < n10) {
                                    if ((n11 - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                        byArray[n14++] = byArray2[n13++];
                                        byArray[n14++] = byArray2[n13++];
                                        byArray[n14++] = byArray2[n13++];
                                        ++n9;
                                    } else {
                                        n13 += 3;
                                    }
                                    ++n11;
                                }
                                break;
                            }
                            default: {
                                throw new Error("Internal dcm4che Error");
                            }
                        }
                    }
                    this.stream.skipBytes(n2 - n4 - n3);
                    if (++n8 >= this.totDestHeight) {
                        ++n12;
                        break;
                    }
                }
                ++n12;
            }
            this.stream.skipBytes(n2 * (this.height - this.sourceYOffset - n12));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IIOException("Exception in readByteSamples", exception);
        }
    }

    private void readWordSamples(int n, short[] sArray) throws IOException {
        int n2 = this.width * n;
        int n3 = this.sourceWidth * n;
        int n4 = this.sourceXOffset * n;
        int n5 = this.destXOffset * n;
        byte[] byArray = new byte[n3 << 1];
        ShortBuffer shortBuffer = ByteBuffer.wrap(byArray).order(this.theParser.getDcmDecodeParam().byteOrder).asShortBuffer();
        int n6 = this.totDestHeight * this.totDestWidth;
        int n7 = this.totDestWidth * n;
        this.stream.skipBytes(n2 * this.sourceYOffset << 1);
        int n8 = this.destYOffset;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        try {
            n12 = 0;
            while (n12 < this.sourceHeight) {
                if ((n12 - this.subsamplingYOffset) % this.sourceYSubsampling != 0) {
                    this.stream.skipBytes(n2 << 1);
                } else {
                    this.stream.skipBytes(n4 << 1);
                    this.stream.readFully(byArray);
                    if (this.sourceXSubsampling == 1) {
                        shortBuffer.rewind();
                        shortBuffer.get(sArray, n8 * n7 + n5, n3);
                    } else {
                        n9 = n8 * this.totDestWidth + this.destXOffset;
                        n10 = Math.min(n9 + this.destWidth, n6);
                        switch (n) {
                            case 1: {
                                n11 = 0;
                                while (n9 < n10) {
                                    if ((n11 - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                        sArray[n9++] = shortBuffer.get(n11);
                                    }
                                    ++n11;
                                }
                                break;
                            }
                            case 3: {
                                n11 = 0;
                                int n13 = 0;
                                int n14 = n9 * 3;
                                while (n9 < n10) {
                                    if ((n11 - this.subsamplingXOffset) % this.sourceXSubsampling == 0) {
                                        sArray[n14++] = shortBuffer.get(n13++);
                                        sArray[n14++] = shortBuffer.get(n13++);
                                        sArray[n14++] = shortBuffer.get(n13++);
                                        ++n9;
                                    } else {
                                        n13 += 3;
                                    }
                                    ++n11;
                                }
                                break;
                            }
                            default: {
                                throw new Error("Internal dcm4che Error");
                            }
                        }
                    }
                    this.stream.skipBytes(n2 - n4 - n3 << 1);
                    if (++n8 >= this.totDestHeight) {
                        ++n12;
                        break;
                    }
                }
                ++n12;
            }
            this.stream.skipBytes(n2 * (this.height - this.sourceYOffset - n12) << 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IIOException("Exception in readWordSamples", exception);
        }
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.theParser = null;
        this.theMetadata = null;
        this.theDataset = null;
        this.frameStartPos = null;
        this.pmi = null;
        this.theImage = null;
        this.theTile = null;
    }
}

