/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4cheri.net.AAssociateRQACImpl;

final class ExtNegotiationImpl
implements ExtNegotiation {
    private final String asuid;
    private final byte[] info;

    ExtNegotiationImpl(String string, byte[] byArray) {
        this.asuid = string;
        this.info = (byte[])byArray.clone();
    }

    ExtNegotiationImpl(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.readUnsignedShort();
        this.asuid = AAssociateRQACImpl.readASCII(dataInputStream, n2);
        this.info = new byte[n - n2 - 2];
        dataInputStream.readFully(this.info);
    }

    public final String getSOPClassUID() {
        return this.asuid;
    }

    public final byte[] info() {
        return (byte[])this.info.clone();
    }

    final int length() {
        return 2 + this.asuid.length() + this.info.length;
    }

    void writeTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(86);
        dataOutputStream.write(0);
        dataOutputStream.writeShort(this.length());
        dataOutputStream.writeShort(this.asuid.length());
        dataOutputStream.writeBytes(this.asuid);
        dataOutputStream.write(this.info);
    }
}

