/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.util;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.dcm4che.util.SSLContextAdapter;

public class SSLContextAdapterImpl
extends SSLContextAdapter {
    static final Logger log = Logger.getLogger("dcm4che.net");
    private String[] cipherSuites = new String[]{"SSL_RSA_WITH_NULL_SHA"};
    private String[] protocols = new String[]{"TLSv1"};
    private SecureRandom random = null;
    private KeyManager[] kms = null;
    private TrustManager[] tms = null;
    private boolean needClientAuth = true;
    private boolean startHandshake = true;

    public static void main(String[] stringArray) throws Exception {
        SSLContextAdapterImpl sSLContextAdapterImpl = new SSLContextAdapterImpl();
        System.out.println(Arrays.asList(((SSLContextAdapter)sSLContextAdapterImpl).getSupportedCipherSuites()));
    }

    public SSLContextAdapterImpl() {
        Security.addProvider((java.security.Provider)new Provider());
    }

    public String toString() {
        return "CipherSuites" + Arrays.asList(this.cipherSuites);
    }

    public void setKey(KeyStore keyStore, char[] cArray) throws GeneralSecurityException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, cArray);
        this.kms = keyManagerFactory.getKeyManagers();
    }

    public void setTrust(KeyStore keyStore) throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        this.tms = trustManagerFactory.getTrustManagers();
    }

    public void seedRandom(long l) throws GeneralSecurityException {
        this.random = SecureRandom.getInstance("SHA1PRNG");
        this.random.setSeed(l);
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public void setStartHandshake(boolean bl) {
        this.startHandshake = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.cipherSuites = (String[])stringArray.clone();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.cipherSuites.clone();
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.protocols = (String[])stringArray.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.protocols.clone();
    }

    public String[] getSupportedCipherSuites() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        return sSLSocketFactory.getSupportedCipherSuites();
    }

    public ServerSocketFactory getServerSocketFactory() throws GeneralSecurityException {
        return new SSLServerSocketFactoryAdapter();
    }

    public SocketFactory getSocketFactory() throws GeneralSecurityException {
        return new SSLSocketFactoryAdapter();
    }

    private SSLContext getContext() throws GeneralSecurityException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(this.kms, this.tms, this.random);
        return sSLContext;
    }

    private ServerSocket prepare(SSLServerSocket sSLServerSocket) {
        sSLServerSocket.setNeedClientAuth(this.needClientAuth);
        sSLServerSocket.setEnabledCipherSuites(this.cipherSuites);
        sSLServerSocket.setEnabledProtocols(this.protocols);
        return sSLServerSocket;
    }

    private Socket prepare(SSLSocket sSLSocket) throws IOException {
        sSLSocket.setEnabledCipherSuites(this.cipherSuites);
        sSLSocket.setEnabledProtocols(this.protocols);
        if (this.startHandshake) {
            sSLSocket.startHandshake();
        }
        if (log.isInfoEnabled()) {
            log.info(SSLContextAdapterImpl.toInfoMsg(sSLSocket, true));
            log.info(SSLContextAdapterImpl.toInfoMsg(sSLSocket, false));
        }
        return sSLSocket;
    }

    public static String toInfoMsg(SSLSocket sSLSocket, boolean bl) throws IOException {
        return SSLContextAdapterImpl.toInfoMsg(sSLSocket, bl, new StringBuffer()).toString();
    }

    private static StringBuffer toInfoMsg(SSLSocket sSLSocket, boolean bl, StringBuffer stringBuffer) throws IOException {
        Certificate[] certificateArray;
        stringBuffer.append(sSLSocket.getInetAddress());
        stringBuffer.append(bl ? " << " : " >> ");
        SSLSession sSLSession = sSLSocket.getSession();
        stringBuffer.append(sSLSession.getCipherSuite());
        stringBuffer.append("[");
        Certificate[] certificateArray2 = certificateArray = bl ? sSLSession.getLocalCertificates() : sSLSession.getPeerCertificates();
        if (certificateArray.length == 0) {
            stringBuffer.append("null");
        } else if (certificateArray[0] instanceof X509Certificate) {
            stringBuffer.append(((X509Certificate)certificateArray[0]).getSubjectX500Principal());
        } else {
            stringBuffer.append(certificateArray[0].getType());
        }
        stringBuffer.append("]");
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(URL uRL, char[] cArray) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        InputStream inputStream = uRL.openStream();
        try {
            keyStore = this.loadKeyStore(inputStream, cArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore loadKeyStore(File file, char[] cArray) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            keyStore = this.loadKeyStore(bufferedInputStream, cArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keyStore;
    }

    public KeyStore loadKeyStore(InputStream inputStream, char[] cArray) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(inputStream, cArray);
        return keyStore;
    }

    private class SSLSocketFactoryAdapter
    extends SocketFactory {
        final SSLSocketFactory sf;

        SSLSocketFactoryAdapter() throws GeneralSecurityException {
            this.sf = SSLContextAdapterImpl.this.getContext().getSocketFactory();
        }

        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLSocket)this.sf.createSocket(inetAddress, n));
        }

        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLSocket)this.sf.createSocket(inetAddress, n, inetAddress2, n2));
        }

        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLSocket)this.sf.createSocket(string, n, inetAddress, n2));
        }

        public Socket createSocket(String string, int n) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLSocket)this.sf.createSocket(string, n));
        }
    }

    private class SSLServerSocketFactoryAdapter
    extends ServerSocketFactory {
        final SSLServerSocketFactory ssf;

        SSLServerSocketFactoryAdapter() throws GeneralSecurityException {
            this.ssf = SSLContextAdapterImpl.this.getContext().getServerSocketFactory();
        }

        public ServerSocket createServerSocket(int n, int n2) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLServerSocket)this.ssf.createServerSocket(n, n2));
        }

        public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLServerSocket)this.ssf.createServerSocket(n, n2, inetAddress));
        }

        public ServerSocket createServerSocket(int n) throws IOException {
            return SSLContextAdapterImpl.this.prepare((SSLServerSocket)this.ssf.createServerSocket(n));
        }
    }
}

