/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.data;

import org.dcm4che.data.DcmDecodeParam;

public class FileFormat {
    public final boolean hasPreamble;
    public final boolean hasFileMetaInfo;
    public final DcmDecodeParam decodeParam;
    public static final FileFormat DICOM_FILE = new FileFormat(true, true, DcmDecodeParam.EVR_LE);
    public static final FileFormat DICOM_FILE_WO_PREAMBLE = new FileFormat(false, true, DcmDecodeParam.EVR_LE);
    public static final FileFormat EVR_LE_STREAM = new FileFormat(false, false, DcmDecodeParam.EVR_LE);
    public static final FileFormat EVR_BE_FILE = new FileFormat(true, true, DcmDecodeParam.EVR_BE);
    public static final FileFormat EVR_BE_FILE_WO_PREAMBLE = new FileFormat(false, true, DcmDecodeParam.EVR_BE);
    public static final FileFormat EVR_BE_STREAM = new FileFormat(false, false, DcmDecodeParam.EVR_BE);
    public static final FileFormat IVR_BE_FILE = new FileFormat(true, true, DcmDecodeParam.IVR_BE);
    public static final FileFormat IVR_BE_FILE_WO_PREAMBLE = new FileFormat(false, true, DcmDecodeParam.IVR_BE);
    public static final FileFormat IVR_BE_STREAM = new FileFormat(false, false, DcmDecodeParam.IVR_BE);
    public static final FileFormat IVR_LE_FILE = new FileFormat(true, true, DcmDecodeParam.IVR_LE);
    public static final FileFormat IVR_LE_FILE_WO_PREAMBLE = new FileFormat(false, true, DcmDecodeParam.IVR_LE);
    public static final FileFormat ACRNEMA_STREAM = new FileFormat(false, false, DcmDecodeParam.IVR_LE);

    private FileFormat(boolean bl, boolean bl2, DcmDecodeParam dcmDecodeParam) {
        if (bl && !bl2) {
            throw new IllegalArgumentException("Preamble without FMI");
        }
        this.hasPreamble = bl;
        this.hasFileMetaInfo = bl2;
        this.decodeParam = dcmDecodeParam;
    }

    public String toString() {
        return "FileFormat[" + (this.hasFileMetaInfo ? (this.hasPreamble ? "Part 10," : "FMI without preamble,") : "Stream, ") + this.decodeParam.toString() + "]";
    }
}

