/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.net;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.DcmService;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.Factory;
import org.dcm4che.util.UIDGenerator;

public class DcmServiceBase
implements DcmService {
    public static final int SUCCESS = 0;
    public static final int NO_SUCH_SOP_CLASS = 280;
    public static final int UNRECOGNIZE_OPERATION = 529;
    public static final DcmService VERIFICATION_SCP = new DcmServiceBase(){

        protected void doCEcho(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
            command.putUS(2304, 0);
        }
    };
    public static final DcmService NO_SUCH_SOP_CLASS_SCP = new DcmServiceBase(280);
    protected static final DcmObjectFactory objFact = DcmObjectFactory.getInstance();
    protected static final Factory fact = Factory.getInstance();
    protected static final UIDGenerator uidGen = UIDGenerator.getInstance();
    protected final int defStatus;

    public DcmServiceBase(int n) {
        this.defStatus = n;
    }

    public DcmServiceBase() {
        this.defStatus = 529;
    }

    public void c_store(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initCStoreRSP(command.getMessageID(), command.getAffectedSOPClassUID(), command.getAffectedSOPInstanceUID(), this.defStatus);
        this.doCStore(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void c_get(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initCGetRSP(command.getMessageID(), command.getAffectedSOPClassUID(), this.defStatus);
        this.doMultiRsp(activeAssociation, dimse, command2, this.doCGet(activeAssociation, dimse, command2));
    }

    public void c_find(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initCFindRSP(command.getMessageID(), command.getAffectedSOPClassUID(), this.defStatus);
        this.doMultiRsp(activeAssociation, dimse, command2, this.doCFind(activeAssociation, dimse, command2));
    }

    public void c_move(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initCMoveRSP(command.getMessageID(), command.getAffectedSOPClassUID(), this.defStatus);
        this.doMultiRsp(activeAssociation, dimse, command2, this.doCMove(activeAssociation, dimse, command2));
    }

    public void c_echo(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initCEchoRSP(command.getMessageID(), command.getAffectedSOPClassUID(), this.defStatus);
        this.doCEcho(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_event_report(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNEventReportRSP(command.getMessageID(), command.getAffectedSOPClassUID(), command.getAffectedSOPInstanceUID(), this.defStatus);
        Dataset dataset = this.doNEventReport(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_get(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNGetRSP(command.getMessageID(), command.getRequestedSOPClassUID(), command.getRequestedSOPInstanceUID(), this.defStatus);
        Dataset dataset = this.doNGet(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_set(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNSetRSP(command.getMessageID(), command.getRequestedSOPClassUID(), command.getRequestedSOPInstanceUID(), 0);
        Dataset dataset = this.doNSet(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_action(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNActionRSP(command.getMessageID(), command.getRequestedSOPClassUID(), command.getRequestedSOPInstanceUID(), this.defStatus);
        Dataset dataset = this.doNAction(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_create(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNCreateRSP(command.getMessageID(), command.getAffectedSOPClassUID(), DcmServiceBase.createUID(command.getAffectedSOPInstanceUID()), this.defStatus);
        Dataset dataset = this.doNCreate(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    public void n_delete(ActiveAssociation activeAssociation, Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Command command2 = objFact.newCommand();
        command2.initNDeleteRSP(command.getMessageID(), command.getRequestedSOPClassUID(), command.getRequestedSOPInstanceUID(), this.defStatus);
        Dataset dataset = this.doNDelete(activeAssociation, dimse, command2);
        Dimse dimse2 = fact.newDimse(dimse.pcid(), command2, dataset);
        activeAssociation.getAssociation().write(dimse2);
    }

    protected void doCStore(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
    }

    protected MultiDimseRsp doCGet(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected MultiDimseRsp doCFind(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected MultiDimseRsp doCMove(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected void doCEcho(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
    }

    protected Dataset doNEventReport(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected Dataset doNGet(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected Dataset doNSet(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected Dataset doNAction(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected Dataset doNCreate(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    protected Dataset doNDelete(ActiveAssociation activeAssociation, Dimse dimse, Command command) throws IOException {
        dimse.getDataset();
        return null;
    }

    private void doMultiRsp(ActiveAssociation activeAssociation, Dimse dimse, Command command, MultiDimseRsp multiDimseRsp) throws IOException {
        if (multiDimseRsp == null) {
            activeAssociation.getAssociation().write(fact.newDimse(dimse.pcid(), command));
            return;
        }
        activeAssociation.addCancelListener(command.getMessageIDToBeingRespondedTo(), multiDimseRsp.getCancelListener());
        do {
            Dataset dataset = multiDimseRsp.next(activeAssociation, dimse, command);
            Dimse dimse2 = fact.newDimse(dimse.pcid(), command, dataset);
            activeAssociation.getAssociation().write(dimse2);
        } while (command.isPending());
    }

    private static String createUID(String string) {
        return string != null ? string : uidGen.createUID();
    }

    public static interface MultiDimseRsp {
        public DimseListener getCancelListener();

        public Dataset next(ActiveAssociation var1, Dimse var2, Command var3);
    }
}

