/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.srom;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;

public interface Content {
    public int[] getID();

    public Code getName();

    public void setName(Code var1);

    public KeyObject getOwnerDocument();

    public Date getObservationDateTime(boolean var1);

    public Template getTemplate();

    public RelationType getRelationType();

    public ValueType getValueType();

    public Content getParent();

    public Content getFirstChild();

    public Content getFirstChildBy(RelationType var1, Code var2);

    public Content getLastChild();

    public Content getPreviousSibling();

    public Content getNextSibling();

    public Content getNextSiblingBy(RelationType var1, Code var2);

    public Content insertBefore(RelationType var1, Content var2, Content var3);

    public Content replaceChild(RelationType var1, Content var2, Content var3);

    public Content removeChild(Content var1);

    public Content appendChild(RelationType var1, Content var2);

    public boolean hasChildren();

    public Content clone(boolean var1);

    public void toDataset(Dataset var1);

    public static final class ValueType {
        private String type;
        public static final ValueType TEXT = new ValueType("TEXT");
        public static final ValueType NUM = new ValueType("NUM");
        public static final ValueType CODE = new ValueType("CODE");
        public static final ValueType DATETIME = new ValueType("DATETIME");
        public static final ValueType DATE = new ValueType("DATE");
        public static final ValueType TIME = new ValueType("TIME");
        public static final ValueType UIDREF = new ValueType("UIDREF");
        public static final ValueType PNAME = new ValueType("PNAME");
        public static final ValueType COMPOSITE = new ValueType("COMPOSITE");
        public static final ValueType IMAGE = new ValueType("IMAGE");
        public static final ValueType WAVEFORM = new ValueType("WAVEFORM");
        public static final ValueType SCOORD = new ValueType("SCOORD");
        public static final ValueType TCOORD = new ValueType("TCOORD");
        public static final ValueType CONTAINER = new ValueType("CONTAINER");
        private static final Map TYPES = new HashMap(19);

        public static ValueType valueOf(String string) {
            ValueType valueType = (ValueType)TYPES.get(string);
            if (valueType == null) {
                throw new IllegalArgumentException(string);
            }
            return valueType;
        }

        private ValueType(String string) {
            this.type = string;
        }

        public String toString() {
            return this.type;
        }

        static {
            TYPES.put("TEXT", TEXT);
            TYPES.put("NUM", NUM);
            TYPES.put("CODE", CODE);
            TYPES.put("DATETIME", DATETIME);
            TYPES.put("DATE", DATE);
            TYPES.put("TIME", TIME);
            TYPES.put("UIDREF", UIDREF);
            TYPES.put("PNAME", PNAME);
            TYPES.put("COMPOSITE", COMPOSITE);
            TYPES.put("IMAGE", IMAGE);
            TYPES.put("WAVEFORM", WAVEFORM);
            TYPES.put("SCOORD", SCOORD);
            TYPES.put("TCOORD", TCOORD);
            TYPES.put("CONTAINER", CONTAINER);
        }
    }

    public static final class RelationType {
        private String type;
        public static final RelationType CONTAINS = new RelationType("CONTAINS");
        public static final RelationType HAS_PROPERTIES = new RelationType("HAS PROPERTIES");
        public static final RelationType HAS_OBS_CONTEXT = new RelationType("HAS OBS CONTEXT");
        public static final RelationType HAS_ACQ_CONTEXT = new RelationType("HAS ACQ CONTEXT");
        public static final RelationType INFERRED_FROM = new RelationType("INFERRED FROM");
        public static final RelationType SELECTED_FROM = new RelationType("SELECTED FROM");
        public static final RelationType HAS_CONCEPT_MOD = new RelationType("HAS CONCEPT MOD");
        private static final Map TYPES = new HashMap(11);

        public static RelationType valueOf(String string) {
            RelationType relationType = (RelationType)TYPES.get(string);
            if (relationType == null) {
                throw new IllegalArgumentException(string);
            }
            return relationType;
        }

        private RelationType(String string) {
            this.type = string;
        }

        public String toString() {
            return this.type;
        }

        static {
            TYPES.put("CONTAINS", CONTAINS);
            TYPES.put("HAS PROPERTIES", HAS_PROPERTIES);
            TYPES.put("HAS OBS CONTEXT", HAS_OBS_CONTEXT);
            TYPES.put("HAS ACQ CONTEXT", HAS_ACQ_CONTEXT);
            TYPES.put("INFERRED FROM", INFERRED_FROM);
            TYPES.put("SELECTED FROM", SELECTED_FROM);
            TYPES.put("HAS CONCEPT MOD", HAS_CONCEPT_MOD);
        }
    }
}

