/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.hl7;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dcm4cheri.hl7.HL7FieldsImpl;

public class HL7SegmentImpl
extends HL7FieldsImpl {
    private static final int MIN_LEN = 4;
    private static final byte[] DELIM = new byte[]{124, 126, 94, 38};
    private final String id;
    static final ResourceBundle DICT = ResourceBundle.getBundle("org/dcm4cheri/hl7/HL7Dictionary");

    static String getName(String string, String string2) {
        try {
            return DICT.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    HL7SegmentImpl(byte[] byArray, int n, int n2) {
        super(byArray, n, n2, DELIM);
        if (n2 < 4 || byArray[n + 3] != 124) {
            throw new IllegalArgumentException(this.toString());
        }
        this.id = super.get(0);
    }

    public String id() {
        return this.id();
    }

    public String get(int n, int n2) {
        return super.get(new int[]{n, n2 - 1});
    }

    public String get(int n, int n2, int n3) {
        return super.get(new int[]{n, n2 - 1, n3 - 1});
    }

    public String get(int n, int n2, int n3, int n4) {
        return super.get(new int[]{n, n2 - 1, n3 - 1, n4 - 1});
    }

    public int size(int n, int n2) {
        return super.size(new int[]{n, n2 - 1});
    }

    public int size(int n, int n2, int n3) {
        return super.size(new int[]{n, n2 - 1, n3 - 1});
    }

    StringBuffer toVerboseStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.id).append(" - ").append(HL7SegmentImpl.getName(this.id, ""));
        int n = 1;
        int n2 = this.size();
        while (n < n2) {
            String string = this.id + '.' + n;
            stringBuffer.append("\n\t").append(string).append(": ").append(this.get(n)).append("\t\t//").append(HL7SegmentImpl.getName(string, "????"));
            ++n;
        }
        return stringBuffer;
    }

    public String toVerboseString() {
        return this.toVerboseStringBuffer(new StringBuffer()).toString();
    }
}

