/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.ContentImpl;

abstract class NamedContentImpl
extends ContentImpl {
    protected Code name;
    protected final Long obsDateTime;
    protected final Template template;

    protected static Code checkNotNull(Code code) {
        if (code == null) {
            throw new NullPointerException();
        }
        return code;
    }

    NamedContentImpl(KeyObject keyObject, Date date, Template template, Code code) {
        super(keyObject);
        this.name = code;
        this.template = template;
        this.obsDateTime = date != null ? new Long(date.getTime()) : null;
    }

    StringBuffer prompt() {
        return super.prompt().append(this.getValueType()).append(this.name).append('=');
    }

    public Code getName() {
        return this.name;
    }

    public void setName(Code code) {
        this.name = code;
    }

    public Date getObservationDateTime(boolean bl) {
        if (this.obsDateTime != null) {
            return new Date(this.obsDateTime);
        }
        if (!bl) {
            return null;
        }
        if (this.parent != null) {
            return this.parent.getObservationDateTime(true);
        }
        return this.owner.getContentDateTime();
    }

    public Template getTemplate() {
        return this.template;
    }
}

