/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.media;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.media.DirRecord;
import org.dcm4che.media.DirWriter;
import org.dcm4cheri.media.DirReaderImpl;
import org.dcm4cheri.media.DirRecordImpl;
import org.dcm4cheri.util.IntHashtable2;

final class DirWriterImpl
extends DirReaderImpl
implements DirWriter {
    private static final Short INACTIVE = new Short(0);
    private static final Integer INTEGER0 = new Integer(0);
    private static final String[] TYPE_CODE = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE", "OVERLAY", "MODALITY LUT", "VOI LUT", "CURVE", "TOPIC", "VISIT", "RESULTS", "INTERPRETATION", "STUDY COMPONENT", "STORED PRINT", "RT DOSE", "RT STRUCTURE SET", "RT PLAN", "RT TREAT RECORD", "PRESENTATION", "WAVEFORM", "SR DOCUMENT", "KEY OBJECT DOC", "PRIVATE", "MRDR"};
    private static final List TYPE_CODE_LIST = Arrays.asList(TYPE_CODE);
    private static final byte[] ITEM = new byte[]{-2, -1, 0, -32, -1, -1, -1, -1};
    private static final byte[] ITEM_DELIMITER = new byte[]{-2, -1, 13, -32, 0, 0, 0, 0};
    private static final byte[] SEQ_DELIMITER = new byte[]{-2, -1, -35, -32, 0, 0, 0, 0};
    private static final byte[] PADDING_TAG_OB = new byte[]{-4, -1, -4, -1, 79, 66, 0, 0};
    private String dirPath;
    private final ImageOutputStream out;
    private final DcmEncodeParam encParam;
    private boolean autoCommit = false;
    private long newRecPos;
    private long rollbackPos;
    private int rollbackOffLastRootRec;
    private TreeMap dirtyOffsets = new TreeMap();
    private Long lastRootRecNextValPos = null;
    private IntHashtable2 lastRecNextValPosCache = new IntHashtable2();

    DirWriterImpl(File file, ImageOutputStream imageOutputStream, DcmEncodeParam dcmEncodeParam) {
        super(file, imageOutputStream);
        this.out = imageOutputStream;
        imageOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.encParam = dcmEncodeParam != null ? dcmEncodeParam : DcmDecodeParam.EVR_LE;
    }

    public String[] toFileIDs(File file) throws IOException {
        String string;
        if (this.dirPath == null) {
            this.dirPath = this.file.getParentFile().getAbsolutePath();
        }
        if (!(string = file.getAbsolutePath()).startsWith(this.dirPath)) {
            throw new IllegalArgumentException(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(this.dirPath.length()), File.separator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    DirWriterImpl initWriter(FileMetaInfo fileMetaInfo, String string, File file, String string2) throws IOException {
        this.parser.setDcmDecodeParam(DcmDecodeParam.EVR_LE);
        this.fsi = DirReaderImpl.factory.newDataset();
        this.fsi.setFileMetaInfo(fileMetaInfo);
        this.fsi.putCS(266544, string);
        if (file != null) {
            this.fsi.putCS(266561, this.toFileIDs(file.getAbsoluteFile()));
            if (string2 != null) {
                this.fsi.putCS(266562, string2);
            }
        }
        this.offFirstRootRec = 0;
        this.fsi.putUL(266752, 0);
        this.offLastRootRec = 0;
        this.fsi.putUL(266754, 0);
        this.fsi.putUS(266770, 0);
        this.fsi.putSQ(266784);
        this.fsi.writeFile(this.out, this.encParam);
        this.fsi.remove(266784);
        if (this.encParam.undefSeqLen) {
            this.seqLength = -1;
            this.seqValuePos = this.out.getStreamPosition() - 8L;
        } else {
            this.seqLength = 0;
            this.seqValuePos = this.out.getStreamPosition();
        }
        this.offFirstRootRecValPos = this.seqValuePos - 38L;
        this.offLastRootRecValPos = this.seqValuePos - 26L;
        this.newRecPos = this.rollbackPos = this.seqValuePos;
        this.rollbackOffLastRootRec = this.offLastRootRec;
        return this;
    }

    DirWriterImpl initWriter() throws IOException {
        this.initReader();
        this.rollbackPos = this.seqLength != -1 ? this.seqValuePos + ((long)this.seqLength & 0xFFFFFFFFL) : (this.offLastRootRec == 0 ? this.seqValuePos : this.parseItems());
        this.newRecPos = this.rollbackPos;
        this.rollbackOffLastRootRec = this.offLastRootRec;
        return this;
    }

    private long parseItems() throws IOException {
        this.parser.seek((long)this.offLastRootRec & 0xFFFFFFFFL);
        while (this.parser.parseItemDataset() != -1L) {
        }
        return this.parser.getStreamPosition() - 8L;
    }

    public void close() throws IOException {
        this.commit();
        super.close();
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public synchronized void setAutoCommit(boolean bl) throws IOException {
        if (this.autoCommit == bl) {
            return;
        }
        this.autoCommit = bl;
        if (this.autoCommit) {
            this.commit();
        }
    }

    public synchronized void commit() throws IOException {
        if (this.dirtyOffsets.isEmpty()) {
            if (this.newRecPos != this.rollbackPos) {
                throw new RuntimeException("newRecPos:" + this.newRecPos + ", rollbackPos:" + this.rollbackPos);
            }
            return;
        }
        if (this.newRecPos != this.rollbackPos) {
            this.writeTrailer();
            if (this.seqLength != -1) {
                this.dirtyOffsets.put(new Long(this.seqValuePos - 4L), new Integer(this.seqLength += (int)(this.newRecPos - this.rollbackPos)));
            }
        }
        Iterator iterator = this.dirtyOffsets.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.out.seek((Long)entry.getKey());
            Number number = (Number)entry.getValue();
            if (number instanceof Integer) {
                this.out.writeInt(number.intValue());
                continue;
            }
            this.out.writeShort(number.intValue());
        }
        this.dirtyOffsets.clear();
        this.rollbackOffLastRootRec = this.offLastRootRec;
        this.rollbackPos = this.newRecPos;
    }

    public synchronized void rollback() throws IOException {
        if (this.newRecPos == this.rollbackPos) {
            return;
        }
        this.dirtyOffsets.clear();
        this.lastRecNextValPosCache.clear();
        this.lastRootRecNextValPos = null;
        this.offLastRootRec = this.rollbackOffLastRootRec;
        if (this.offLastRootRec == 0) {
            this.offFirstRootRec = 0;
        }
        this.newRecPos = this.rollbackPos;
        this.writeTrailer();
    }

    private void writeTrailer() throws IOException {
        int n;
        this.out.seek(this.newRecPos);
        if (this.seqLength == -1) {
            this.out.write(SEQ_DELIMITER);
        }
        if ((n = (int)(this.out.length() - this.out.getStreamPosition())) > 0) {
            this.out.write(PADDING_TAG_OB);
            n = Math.max(0, n - 12);
            this.out.writeInt(n + 1 & 0xFFFFFFFE);
            if ((n & 1) != 0) {
                this.out.seek(this.out.length());
                this.out.write(0);
            }
        }
    }

    public synchronized DirRecord add(DirRecord dirRecord, String string, Dataset dataset) throws IOException {
        return this.add(dirRecord, string, dataset, null, null, null, null);
    }

    public synchronized DirRecord add(DirRecord dirRecord, String string, Dataset dataset, String[] stringArray, String string2, String string3, String string4) throws IOException {
        return this.add(dirRecord, string, dataset, stringArray, string2, string3, string4, false);
    }

    private DirRecord add(DirRecord dirRecord, String string, Dataset dataset, String[] stringArray, String string2, String string3, String string4, boolean bl) throws IOException {
        if (TYPE_CODE_LIST.indexOf(string) == -1) {
            throw new IllegalArgumentException("type:" + string);
        }
        Dataset dataset2 = DirReaderImpl.factory.newDataset();
        dataset2.putUL(267264, 0);
        dataset2.putUS(267280, 65535);
        dataset2.putUL(267296, bl ? ((DirRecordImpl)dirRecord).lower : 0);
        dataset2.putCS(267312, string);
        if (stringArray != null) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            if (string3 == null) {
                throw new NullPointerException();
            }
            if (string4 == null) {
                throw new NullPointerException();
            }
            dataset2.putCS(267520, stringArray);
            dataset2.putUI(267536, string2);
            dataset2.putUI(267537, string3);
            dataset2.putUI(267538, string4);
        }
        this.out.seek(this.newRecPos);
        this.out.write(ITEM, 0, 8);
        dataset2.writeDataset(this.out, this.encParam);
        dataset.subSet(524288, -1).writeDataset(this.out, this.encParam);
        long l = this.out.getStreamPosition();
        if (this.encParam.undefItemLen) {
            this.out.write(ITEM_DELIMITER, 0, 8);
            l += 8L;
        } else {
            this.out.seek(this.newRecPos + 4L);
            this.out.writeInt((int)(l - this.newRecPos - 8L));
        }
        DirRecordImpl dirRecordImpl = new DirRecordImpl(this.parser, (int)this.newRecPos);
        Integer n = new Integer((int)this.newRecPos);
        if (dirRecord == null) {
            this.dirtyOffsets.put(this.setLastRootRecNextValPos(dirRecordImpl.nextValPos), n);
            this.dirtyOffsets.put(new Long(this.offLastRootRecValPos), n);
            this.offLastRootRec = (int)this.newRecPos;
            if (this.offFirstRootRec == 0) {
                this.offFirstRootRec = (int)this.newRecPos;
            }
        } else if (bl) {
            DirRecordImpl dirRecordImpl2 = (DirRecordImpl)dirRecord;
            this.dirtyOffsets.put(new Long(dirRecordImpl2.inUsePos), INACTIVE);
            this.dirtyOffsets.put(new Long(dirRecordImpl2.lowerValPos), INTEGER0);
            while (dirRecordImpl2.next != 0) {
                dirRecordImpl2 = new DirRecordImpl(this.parser, dirRecordImpl2.next);
            }
            this.dirtyOffsets.put(new Long(dirRecordImpl2.nextValPos), n);
        } else {
            this.dirtyOffsets.put(this.setLastRecNextValPos(dirRecord, dirRecordImpl.nextValPos), n);
        }
        this.newRecPos = l;
        if (this.autoCommit) {
            this.commit();
        }
        return dirRecordImpl;
    }

    private Long setLastRootRecNextValPos(long l) throws IOException {
        Long l2 = this.lastRootRecNextValPos;
        this.lastRootRecNextValPos = new Long(l);
        if (this.offLastRootRec == 0) {
            return new Long(this.offFirstRootRecValPos);
        }
        if (l2 != null) {
            return l2;
        }
        return new Long(new DirRecordImpl((DcmParser)this.parser, (int)this.offLastRootRec).nextValPos);
    }

    /*
     * Unable to fully structure code
     */
    private Long setLastRecNextValPos(DirRecord var1_1, long var2_2) throws IOException {
        var4_3 = var1_1.hashCode();
        var5_4 = (Long)this.lastRecNextValPosCache.get(var4_3);
        this.lastRecNextValPosCache.put(var4_3, new Long(var2_2));
        if (var5_4 != null) {
            return var5_4;
        }
        var6_5 = (DirRecordImpl)var1_1.getFirstChild(true);
        if (var6_5 != null) ** GOTO lbl11
        return new Long(((DirRecordImpl)var1_1).lowerValPos);
lbl-1000:
        // 1 sources

        {
            var6_5 = new DirRecordImpl(this.parser, var6_5.next);
lbl11:
            // 2 sources

            ** while (var6_5.next != 0)
        }
lbl12:
        // 1 sources

        return new Long(var6_5.nextValPos);
    }

    public int remove(DirRecord dirRecord) throws IOException {
        if (dirRecord.getInUseFlag() == 0) {
            return 0;
        }
        int n = this.doRemove(dirRecord);
        if (this.autoCommit) {
            this.commit();
        }
        return n;
    }

    private int doRemove(DirRecord dirRecord) throws IOException {
        this.dirtyOffsets.put(new Long(((DirRecordImpl)dirRecord).inUsePos), INACTIVE);
        int n = 1;
        DirRecord dirRecord2 = dirRecord.getFirstChild(true);
        while (dirRecord2 != null) {
            n += this.doRemove(dirRecord2);
            dirRecord2 = dirRecord2.getNextSibling(true);
        }
        return n;
    }

    public DirRecord replace(DirRecord dirRecord, String string, Dataset dataset) throws IOException {
        return this.replace(dirRecord, string, dataset, null, null, null, null);
    }

    public DirRecord replace(DirRecord dirRecord, String string, Dataset dataset, String[] stringArray, String string2, String string3, String string4) throws IOException {
        if (dirRecord.getInUseFlag() == 0) {
            throw new IllegalArgumentException("" + dirRecord);
        }
        return this.add(dirRecord, string, dataset, stringArray, string2, string3, string4, true);
    }

    private File backup() throws IOException {
        this.close();
        File file = this.file.getParentFile();
        String string = this.file.getName();
        File file2 = null;
        while ((file2 = new File(file, string = string + '~')).exists()) {
        }
        this.file.renameTo(file2);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirWriter compact() throws IOException {
        File file = this.backup();
        DirWriterImpl dirWriterImpl = null;
        try {
            DirReaderImpl dirReaderImpl = new DirReaderImpl(file, new FileImageInputStream(file)).initReader();
            try {
                Dataset dataset = dirReaderImpl.getFileSetInfo();
                dirWriterImpl = new DirWriterImpl(this.file, new FileImageOutputStream(this.file), this.encParam);
                dirWriterImpl.initWriter(dataset.getFileMetaInfo(), dataset.getString(266544), dirReaderImpl.getDescriptorFile(), dataset.getString(266562));
                this.copy(dirReaderImpl, dirWriterImpl);
                dirWriterImpl.commit();
                dirWriterImpl.setAutoCommit(this.autoCommit);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    dirReaderImpl.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                dirReaderImpl.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            if (dirWriterImpl != null) {
                try {
                    dirWriterImpl.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.file.delete();
            file.renameTo(this.file);
            throw iOException;
        }
        file.delete();
        return dirWriterImpl;
    }

    private void copy(DirReaderImpl dirReaderImpl, DirWriterImpl dirWriterImpl) throws IOException {
        DirRecord dirRecord = dirReaderImpl.getFirstRecord(true);
        while (dirRecord != null) {
            this.copyInto(dirRecord, dirWriterImpl, null);
            dirRecord = dirRecord.getNextSibling(true);
        }
    }

    private void copyInto(DirRecord dirRecord, DirWriterImpl dirWriterImpl, DirRecord dirRecord2) throws IOException {
        DirRecord dirRecord3 = dirWriterImpl.add(dirRecord2, dirRecord.getType(), dirRecord.getDataset(), dirRecord.getRefFileIDs(), dirRecord.getRefSOPClassUID(), dirRecord.getRefSOPInstanceUID(), dirRecord.getRefSOPTransferSyntaxUID());
        DirRecord dirRecord4 = dirRecord.getFirstChild(true);
        while (dirRecord4 != null) {
            this.copyInto(dirRecord4, dirWriterImpl, dirRecord3);
            dirRecord4 = dirRecord4.getNextSibling(true);
        }
    }
}

