/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.io.IOException;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.net.ActiveAssociation;
import org.dcm4che.net.Association;
import org.dcm4che.net.DcmServiceRegistry;
import org.dcm4che.net.Dimse;
import org.dcm4che.net.DimseListener;
import org.dcm4che.net.FutureRSP;
import org.dcm4cheri.net.AssociationImpl;
import org.dcm4cheri.net.FutureRSPImpl;
import org.dcm4cheri.util.IntHashtable2;
import org.dcm4cheri.util.LF_ThreadPool;

final class ActiveAssociationImpl
implements ActiveAssociation,
LF_ThreadPool.Handler {
    private final Association assoc;
    private final DcmServiceRegistry services;
    private final IntHashtable2 rspDispatcher = new IntHashtable2();
    private final IntHashtable2 cancelDispatcher = new IntHashtable2();
    private final LF_ThreadPool threadPool = new LF_ThreadPool(this);
    private boolean running = false;
    private int timeout = 0;

    ActiveAssociationImpl(Association association, DcmServiceRegistry dcmServiceRegistry) {
        if (association.getState() != 6) {
            throw new IllegalStateException("Association not esrablished - " + association.getState());
        }
        this.assoc = association;
        this.services = dcmServiceRegistry;
        ((AssociationImpl)association).setThreadPool(this.threadPool);
    }

    public final void addCancelListener(int n, DimseListener dimseListener) {
        this.cancelDispatcher.put(n, dimseListener);
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public void run() {
        if (this.running) {
            throw new IllegalStateException("Already running: " + this.threadPool);
        }
        this.running = true;
        this.threadPool.join();
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Already running: " + this.threadPool);
        }
        new Thread(this).start();
    }

    public Association getAssociation() {
        return this.assoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Dimse dimse, DimseListener dimseListener) throws InterruptedException, IOException {
        int n = dimse.getCommand().getMessageID();
        int n2 = this.assoc.getMaxOpsInvoked();
        if (n2 == 0) {
            this.rspDispatcher.put(n, dimseListener);
        } else {
            IntHashtable2 intHashtable2 = this.rspDispatcher;
            synchronized (intHashtable2) {
                while (this.rspDispatcher.size() >= n2) {
                    this.rspDispatcher.wait();
                }
                this.rspDispatcher.put(n, dimseListener);
            }
        }
        this.assoc.write(dimse);
    }

    public FutureRSP invoke(Dimse dimse) throws InterruptedException, IOException {
        FutureRSPImpl futureRSPImpl = new FutureRSPImpl();
        this.assoc.addAssociationListener(futureRSPImpl);
        this.invoke(dimse, futureRSPImpl);
        return futureRSPImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean bl) throws InterruptedException, IOException {
        if (bl) {
            IntHashtable2 intHashtable2 = this.rspDispatcher;
            synchronized (intHashtable2) {
                while (!this.rspDispatcher.isEmpty()) {
                    this.rspDispatcher.wait();
                }
            }
        }
        ((AssociationImpl)this.assoc).writeReleaseRQ();
    }

    public void run(LF_ThreadPool lF_ThreadPool) {
        try {
            Dimse dimse = this.assoc.read(this.timeout);
            if (dimse == null) {
                lF_ThreadPool.shutdown();
                return;
            }
            Command command = dimse.getCommand();
            switch (command.getCommandField()) {
                case 1: {
                    this.services.lookup(command.getAffectedSOPClassUID()).c_store(this, dimse);
                    break;
                }
                case 16: {
                    this.services.lookup(command.getAffectedSOPClassUID()).c_get(this, dimse);
                    break;
                }
                case 32: {
                    this.services.lookup(command.getAffectedSOPClassUID()).c_find(this, dimse);
                    break;
                }
                case 33: {
                    this.services.lookup(command.getAffectedSOPClassUID()).c_move(this, dimse);
                    break;
                }
                case 48: {
                    this.services.lookup(command.getAffectedSOPClassUID()).c_echo(this, dimse);
                    break;
                }
                case 256: {
                    this.services.lookup(command.getAffectedSOPClassUID()).n_event_report(this, dimse);
                    break;
                }
                case 272: {
                    this.services.lookup(command.getRequestedSOPClassUID()).n_get(this, dimse);
                    break;
                }
                case 288: {
                    this.services.lookup(command.getRequestedSOPClassUID()).n_set(this, dimse);
                    break;
                }
                case 304: {
                    this.services.lookup(command.getRequestedSOPClassUID()).n_action(this, dimse);
                    break;
                }
                case 320: {
                    this.services.lookup(command.getAffectedSOPClassUID()).n_action(this, dimse);
                    break;
                }
                case 336: {
                    this.services.lookup(command.getRequestedSOPClassUID()).n_delete(this, dimse);
                    break;
                }
                case 32769: 
                case 32784: 
                case 32800: 
                case 32801: 
                case 32816: 
                case 33024: 
                case 33040: 
                case 33056: 
                case 33072: 
                case 33088: 
                case 33104: {
                    this.handleResponse(dimse);
                    break;
                }
                case 65535: {
                    this.handleCancel(dimse);
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal Command: " + command);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            lF_ThreadPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponse(Dimse dimse) throws IOException {
        Command command = dimse.getCommand();
        Dataset dataset = dimse.getDataset();
        int n = command.getMessageIDToBeingRespondedTo();
        DimseListener dimseListener = null;
        if (command.isPending()) {
            dimseListener = (DimseListener)this.rspDispatcher.get(n);
        } else {
            IntHashtable2 intHashtable2 = this.rspDispatcher;
            synchronized (intHashtable2) {
                dimseListener = (DimseListener)this.rspDispatcher.remove(n);
                this.rspDispatcher.notify();
            }
        }
        if (dimseListener != null) {
            dimseListener.dimseReceived(this.assoc, dimse);
        }
    }

    private void handleCancel(Dimse dimse) {
        Command command = dimse.getCommand();
        int n = command.getMessageIDToBeingRespondedTo();
        DimseListener dimseListener = (DimseListener)this.cancelDispatcher.remove(n);
        if (dimseListener != null) {
            dimseListener.dimseReceived(this.assoc, dimse);
        }
    }

    private void checkRunning() {
        if (!this.running) {
            throw new IllegalStateException("Not running: " + this.threadPool);
        }
    }
}

