/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;

class CodeImpl
implements Code {
    static final Code[] EMPTY_ARRAY = new Code[0];
    private static final int MEANING_PROMPT_LEN = 32;
    private final String codeValue;
    private final String codingSchemeDesignator;
    private final String codingSchemeVersion;
    private final String codeMeaning;

    public CodeImpl(String string, String string2, String string3, String string4) {
        this.codeValue = string;
        if (this.codeValue.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.codingSchemeDesignator = string2;
        if (this.codingSchemeDesignator.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.codeMeaning = string4;
        if (this.codeMeaning.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.codingSchemeVersion = string3;
    }

    public CodeImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(524544), dataset.getString(524546), dataset.getString(524547), dataset.getString(524548));
    }

    public static Code newCode(Dataset dataset) throws DcmValueException {
        return dataset != null ? new CodeImpl(dataset) : null;
    }

    public static Code[] newCodes(DcmElement dcmElement) throws DcmValueException {
        if (dcmElement == null || !dcmElement.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Code[] codeArray = new Code[dcmElement.vm()];
        int n = 0;
        while (n < codeArray.length) {
            codeArray[n] = new CodeImpl(dcmElement.getItem(n));
            ++n;
        }
        return codeArray;
    }

    public final String getCodeValue() {
        return this.codeValue;
    }

    public final String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public final String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public final String getCodeMeaning() {
        return this.codeMeaning;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CodeImpl)) {
            return false;
        }
        CodeImpl codeImpl = (CodeImpl)object;
        if (!this.codeValue.equals(codeImpl.codeValue)) {
            return false;
        }
        if (!this.codingSchemeDesignator.equals(codeImpl.codingSchemeDesignator)) {
            return false;
        }
        return this.codingSchemeVersion == null ? codeImpl.codingSchemeVersion == null : this.codingSchemeVersion.equals(codeImpl.codingSchemeVersion);
    }

    public int hashCode() {
        return this.codeValue.hashCode();
    }

    public String toString() {
        return "(" + this.codeValue + "," + this.codingSchemeDesignator + ",\"" + (this.codeMeaning.length() <= 32 ? this.codeMeaning : this.codeMeaning.substring(0, 32) + "..") + "\")";
    }

    public void toDataset(Dataset dataset) {
        dataset.putSH(524544, this.codeValue);
        dataset.putSH(524546, this.codingSchemeDesignator);
        if (this.codingSchemeVersion != null) {
            dataset.putSH(524547, this.codingSchemeVersion);
        }
        dataset.putLO(524548, this.codeMeaning);
    }
}

