/*
 * Decompiled with CFR 0.152.
 */
package de.iftm.pgm;

import de.iftm.pgm.PGM;
import de.iftm.pgm.PgmCommentsUtil;
import gnu.getopt.Getopt;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFrame;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4che.imageio.plugins.DcmMetadata;

public class Pgm2Dcm
extends JFrame {
    private static final String VERSION = "1.2";
    private static TagDictionary dict;
    private static boolean runAsApplication;
    private PGM pgm = null;
    private Dataset userMetadata = null;
    private boolean includeAllMetadata = false;
    private boolean preservePatientMetadata = false;

    public static void main(String[] args) {
        String arg = "";
        Pgm2Dcm myself = new Pgm2Dcm();
        runAsApplication = true;
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                arg = arg + " " + args[i];
                ++i;
            }
            arg = arg.substring(1);
        }
        myself.run(arg);
    }

    public void help() {
        System.out.println("pgm2dcm version " + VERSION);
        System.out.println();
        System.out.println();
        System.out.println("Usage:");
        System.out.println("pgm2dcm [commands] <source>");
        System.out.println();
        System.out.println("Converts a PGM or PPM file to DICOM. By default only default metadata");
        System.out.println("requiered for a Secondary Capture image are written besides the image");
        System.out.println("data.");
        System.out.println();
        System.out.println("<source>        the file or directory containing the DICOM file(s).");
        System.out.println();
        System.out.println("Commands:");
        System.out.println("-a <study_id>   Set the StudyID tag (00200010) to <study_id>.");
        System.out.println("-A <study_uid>  Set the StudyInstanceUID tag (0020000d) to <study_uid>.");
        System.out.println("-b <series_num> Set the SeriesNumber tag (00200011) to <series_num>.");
        System.out.println("-B <series_uid> Set the SeriesInstanceUID tag (0020000e) to <series_uid>.");
        System.out.println("-c <image_num>  Set the InstanceNumber tag (00200013) to <image_num>.");
        System.out.println("-C <sop_uid>    Set the SOPInstanceUID tag (00080018) to <sop_uid>.");
        System.out.println("-d <file-uri>   The name of the destination file or a directory.");
        System.out.println("-f              Write all DICOM tags found in the base image. Add default");
        System.out.println("                metadata requiered for a Secondary Capture image. Preserve the");
        System.out.println("                followingtags:");
        System.out.println("                    PatientName (00100010)");
        System.out.println("                    PatientID (00100020)");
        System.out.println("                    PatientBirthDate (00100030)");
        System.out.println("                    PatientSex (00100040)");
        System.out.println("-F              Write only DICOM tags found in the base image.");
        System.out.println("-h              Print this help message.");
        System.out.println("-n <name>       Set the PatientName tag (00100010) to <name>.");
        System.out.println("-N <pat_id>     Set the PatientID tag (00100020) to <pat_id>.");
        System.out.println();
        System.out.println("<file-uri>      Describes a file in a operating-system independend way. See the");
        System.out.println("                API-Doc of the URI class. For Windows-OS the absolute URI");
        System.out.println("                    file:/c:/user/tom/foo.txt");
        System.out.println("                describes the file");
        System.out.println("                    C:\\user\\tom\\foo.txt");
        System.out.println("                Relative URI's, e.g. without the 'file:' schema-prefix, are");
        System.out.println("                relativ to the user-directory, given by the system property");
        System.out.println("                user.dir. For example: If the user.dir is");
        System.out.println("                    C:\\user\\tom\\");
        System.out.println("                and the relative URI is");
        System.out.println("                    /abc/foo.txt");
        System.out.println("                the referenced file is");
        System.out.println("                    C:\\user\\tom\\abc\\foo.txt");
        System.out.println("                The abbreviations '.' for the current and '..' for the upper");
        System.out.println("                directory are valid to form a relative URI.");
        System.out.println();
        System.out.println();
        System.out.println("(C) 2002 Thomas Hacklaender, mailto:hacklaender@iftm.de");
        System.out.println("IFTM Institut fuer Telematik in der Medizin GmbH, www.iftm.de");
        System.out.println();
        System.out.println("This library is free software; you can redistribute it and/or modify it under");
        System.out.println("the terms of the GNU  General Public License as published by the Free Software");
        System.out.println("Foundation; either version 2 of the License, or (at your option) any later");
        System.out.println("version.");
    }

    /*
     * WARNING - void declaration
     */
    public void run(String arg) {
        int c;
        File source = null;
        File[] sourceFileArray = null;
        File destination = null;
        File destinationDir = null;
        this.userMetadata = DcmObjectFactory.getInstance().newDataset();
        StringTokenizer tok = new StringTokenizer(arg);
        Vector<String> argv = new Vector<String>();
        while (tok.hasMoreTokens()) {
            argv.addElement(tok.nextToken());
        }
        String[] args = argv.toArray(new String[0]);
        Getopt g = new Getopt("Pgm2Dcm", args, "a:A:b:B:c:C:d:fFhn:N:");
        while ((c = g.getopt()) != -1) {
            void var3_10;
            switch (var3_10) {
                case 97: {
                    this.addUserTag(0x200010, g.getOptarg());
                    break;
                }
                case 65: {
                    this.addUserTag(0x20000D, g.getOptarg());
                    break;
                }
                case 98: {
                    this.addUserTag(0x200011, g.getOptarg());
                    break;
                }
                case 66: {
                    this.addUserTag(0x20000E, g.getOptarg());
                    break;
                }
                case 99: {
                    this.addUserTag(2097171, g.getOptarg());
                    break;
                }
                case 67: {
                    this.addUserTag(524312, g.getOptarg());
                    break;
                }
                case 100: {
                    destination = Pgm2Dcm.uriToFile(g.getOptarg());
                    break;
                }
                case 102: {
                    this.includeAllMetadata = true;
                    this.preservePatientMetadata = true;
                    break;
                }
                case 70: {
                    this.includeAllMetadata = true;
                    break;
                }
                case 104: {
                    this.help();
                    return;
                }
                case 110: {
                    this.addUserTag(0x100010, g.getOptarg());
                    break;
                }
                case 78: {
                    this.addUserTag(0x100020, g.getOptarg());
                    break;
                }
                default: {
                    this.help();
                }
            }
        }
        int optind = g.getOptind();
        switch (args.length - optind) {
            case 0: {
                System.err.println("***Error: Missing source file reference.");
                return;
            }
            case 1: {
                source = Pgm2Dcm.uriToFile(args[optind]);
                break;
            }
            default: {
                System.err.println("***Error: To many arguments.");
                return;
            }
        }
        if (source == null) {
            System.err.println("*** Error: Can't extract valid File from " + arg);
            return;
        }
        sourceFileArray = source.isDirectory() ? source.listFiles() : new File[]{source};
        destinationDir = destination == null ? (source.isDirectory() ? source : source.getParentFile()) : (destination.isDirectory() ? destination : destination.getParentFile());
        if (sourceFileArray.length == 1 && destination != null && !destination.isDirectory()) {
            String destinationName = destination.getName();
            this.pgm = new PGM();
            if (!this.pgm.read(sourceFileArray[0])) {
                return;
            }
            this.writeFile(new File(destinationDir, destinationName));
            return;
        }
        int idx = 0;
        while (idx < sourceFileArray.length) {
            this.pgm = new PGM();
            if (this.pgm.read(sourceFileArray[idx])) {
                String destinationName = sourceFileArray[idx].getName();
                if (destinationName.lastIndexOf(46) != -1) {
                    destinationName = destinationName.substring(0, destinationName.lastIndexOf(46));
                }
                destinationName = destinationName + ".dcm";
                this.writeFile(new File(destinationDir, destinationName));
            }
            ++idx;
        }
    }

    private void addUserTag(int tag, String value) {
        int vr = VRs.valueOf(Pgm2Dcm.dict.lookup((int)tag).vr);
        PgmCommentsUtil.addElement(this.userMetadata, tag, vr, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeFile(File f) {
        block12: {
            IIOMetadata dummyIIOMetadata = null;
            ImageWriter dcmImageWriter = null;
            ImageOutputStream ios = null;
            Dataset pgmMetadata = this.pgm.getMetadata();
            Dataset defaultMetadata = PgmCommentsUtil.getDefaultInfoMetadata(PgmCommentsUtil.createPatientID(), 1, 1, 1);
            Dataset dcmMetadata = this.includeAllMetadata ? pgmMetadata : defaultMetadata;
            if (this.preservePatientMetadata) {
                Dataset filter = DcmObjectFactory.getInstance().newDataset();
                filter.putXX(0x100010);
                filter.putXX(0x100020);
                filter.putXX(0x100030);
                filter.putXX(0x100040);
                Dataset patientMetadata = dcmMetadata.subSet(filter);
                Dataset dummyMetadata = DcmObjectFactory.getInstance().newDataset();
                dummyMetadata.putAll(defaultMetadata);
                dummyMetadata.putAll(patientMetadata);
                dcmMetadata.putAll(dummyMetadata);
            }
            dcmMetadata.putAll(this.userMetadata);
            Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName("DICOM");
            do {
                if ((dcmImageWriter = imageWriters.next()) != null) continue;
                throw new UnsupportedOperationException("No DcmImageWriter found" + this);
            } while (!(dcmImageWriter.getDefaultStreamMetadata(null) instanceof DcmMetadata));
            if (f.exists()) {
                f.delete();
                f.createNewFile();
            }
            ios = ImageIO.createImageOutputStream(f);
            dcmImageWriter.setOutput(ios);
            dummyIIOMetadata = dcmImageWriter.getDefaultStreamMetadata(null);
            ((DcmMetadata)dummyIIOMetadata).setDataset(dcmMetadata);
            dcmImageWriter.write(dummyIIOMetadata, new IIOImage(this.pgm.getImage(), null, null), null);
            Object var14_12 = null;
            try {
                ios.close();
            }
            catch (Exception ignore) {}
            break block12;
            {
                catch (Exception e) {
                    System.err.println(e.toString());
                    Object var14_13 = null;
                    try {
                        ios.close();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    ios.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static File uriToFile(String uriString) {
        if (uriString == null) {
            return null;
        }
        if (uriString.equals("")) {
            return null;
        }
        try {
            URI uri = new URI(uriString);
            if (!uri.isAbsolute()) {
                URI baseURI = new File(System.getProperty("user.dir")).toURI();
                uri = baseURI.resolve(uri);
            }
            return new File(uri);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    static {
        VERSION = VERSION;
        dict = DictionaryFactory.getInstance().getDefaultTagDictionary();
        runAsApplication = false;
    }
}

