/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmParseException;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.FileFormat;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRMap;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.InputStreamAdapter;
import org.xml.sax.ContentHandler;

final class DcmParserImpl
implements DcmParser {
    private static final Logger log = Logger.getLogger("dcm4che.data.DcmParser");
    private static final int TS_ID_TAG = 131088;
    private static final int ITEM_TAG = -73728;
    private static final int ITEM_DELIMITATION_ITEM_TAG = -73715;
    private static final int SEQ_DELIMITATION_ITEM_TAG = -73507;
    private final byte[] b0 = new byte[0];
    private final byte[] b12 = new byte[12];
    private final ByteBuffer bb12 = ByteBuffer.wrap(this.b12).order(ByteOrder.LITTLE_ENDIAN);
    private DcmDecodeParam decodeParam = DcmDecodeParam.IVR_LE;
    private int maxAlloc = 0x4000000;
    private DataInput in = null;
    private DcmHandler handler = null;
    private VRMap vrMap = VRMap.DEFAULT;
    private int rTag = -1;
    private int rVR = -1;
    private int rLen = -1;
    private long rPos = 0L;
    private boolean eof = false;
    private String tsUID = null;
    private ByteArrayOutputStream unBuf = null;

    public DcmParserImpl(InputStream inputStream) {
        this.in = inputStream instanceof DataInput ? (DataInput)((Object)inputStream) : new DataInputStream(inputStream);
    }

    public DcmParserImpl(ImageInputStream imageInputStream) {
        if (imageInputStream == null) {
            throw new NullPointerException();
        }
        this.in = imageInputStream;
    }

    public InputStream getInputStream() {
        return (InputStream)((Object)this.in);
    }

    public ImageInputStream getImageInputStream() {
        return (ImageInputStream)this.in;
    }

    public final int getReadTag() {
        return this.rTag;
    }

    public final int getReadVR() {
        return this.rVR;
    }

    public final int getReadLength() {
        return this.rLen;
    }

    public final long getStreamPosition() {
        return this.rPos;
    }

    public final void seek(long l) throws IOException {
        if (!(this.in instanceof ImageInputStream)) {
            throw new UnsupportedOperationException();
        }
        ((ImageInputStream)this.in).seek(l);
        this.rPos = l;
    }

    public final boolean hasSeenEOF() {
        return this.eof;
    }

    public final void setDcmHandler(DcmHandler dcmHandler) {
        this.handler = dcmHandler;
    }

    public final void setSAXHandler(ContentHandler contentHandler, TagDictionary tagDictionary) {
        this.handler = new DcmHandlerAdapter(contentHandler, tagDictionary);
    }

    public final void setVRMap(VRMap vRMap) {
        if (vRMap == null) {
            throw new NullPointerException();
        }
        this.vrMap = vRMap;
    }

    public final void setDcmDecodeParam(DcmDecodeParam dcmDecodeParam) {
        if (log.isDebugEnabled()) {
            log.debug(dcmDecodeParam.toString());
        }
        if (dcmDecodeParam.deflated != this.decodeParam.deflated) {
            if (!dcmDecodeParam.deflated) {
                throw new UnsupportedOperationException("Cannot remove Inflater");
            }
            this.in = new DataInputStream(new InflaterInputStream(this.in instanceof InputStream ? (InputStream)((Object)this.in) : new InputStreamAdapter((ImageInputStream)this.in)));
        }
        this.bb12.order(dcmDecodeParam.byteOrder);
        this.decodeParam = dcmDecodeParam;
    }

    public final DcmDecodeParam getDcmDecodeParam() {
        return this.decodeParam;
    }

    private String logMsg() {
        return "rPos:" + this.rPos + " " + Tags.toString(this.rTag) + " " + VRs.toString(this.rVR) + " #" + this.rLen;
    }

    public FileFormat detectFileFormat() throws IOException {
        FileFormat fileFormat = null;
        if (this.in instanceof InputStream) {
            fileFormat = this.detectFileFormat((InputStream)((Object)this.in));
        } else if (this.in instanceof ImageInputStream) {
            fileFormat = this.detectFileFormat((ImageInputStream)this.in);
        } else {
            throw new UnsupportedOperationException("" + this.in);
        }
        if (log.isDebugEnabled()) {
            log.debug("detect " + fileFormat);
        }
        return fileFormat;
    }

    private int testEVRFormat(DcmDecodeParam dcmDecodeParam) throws IOException {
        this.setDcmDecodeParam(dcmDecodeParam);
        this.parseHeader();
        if (this.rVR == this.vrMap.lookup(this.rTag)) {
            if (this.rTag >>> 16 == 2) {
                return 0;
            }
            if (this.rTag >= 524288) {
                return 1;
            }
        }
        return -1;
    }

    private int testIVRFormat(DcmDecodeParam dcmDecodeParam) throws IOException {
        this.setDcmDecodeParam(dcmDecodeParam);
        this.parseHeader();
        if (this.rVR != 21838 && this.rLen <= 64) {
            if (this.rTag >>> 16 == 2) {
                return 0;
            }
            if (this.rTag >= 524288) {
                return 1;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileFormat detectFileFormat(InputStream inputStream) throws IOException {
        inputStream.mark(144);
        try {
            switch (this.testIVRFormat(DcmDecodeParam.IVR_LE)) {
                case 0: {
                    FileFormat fileFormat = FileFormat.IVR_LE_FILE_WO_PREAMBLE;
                    Object var19_3 = null;
                    inputStream.reset();
                    return fileFormat;
                }
                case 1: {
                    FileFormat fileFormat = FileFormat.ACRNEMA_STREAM;
                    Object var19_4 = null;
                    inputStream.reset();
                    return fileFormat;
                }
            }
            inputStream.reset();
            switch (this.testEVRFormat(DcmDecodeParam.EVR_LE)) {
                case 0: {
                    FileFormat fileFormat = FileFormat.DICOM_FILE_WO_PREAMBLE;
                    Object var19_5 = null;
                    inputStream.reset();
                    return fileFormat;
                }
                case 1: {
                    FileFormat fileFormat = FileFormat.EVR_LE_STREAM;
                    Object var19_6 = null;
                    inputStream.reset();
                    return fileFormat;
                }
            }
            inputStream.reset();
            switch (this.testEVRFormat(DcmDecodeParam.EVR_BE)) {
                case 0: {
                    FileFormat fileFormat = FileFormat.EVR_BE_FILE_WO_PREAMBLE;
                    Object var19_7 = null;
                    inputStream.reset();
                    return fileFormat;
                }
                case 1: {
                    FileFormat fileFormat = FileFormat.EVR_BE_STREAM;
                    Object var19_8 = null;
                    inputStream.reset();
                    return fileFormat;
                }
            }
            inputStream.reset();
            switch (this.testIVRFormat(DcmDecodeParam.IVR_BE)) {
                case 0: {
                    FileFormat fileFormat = FileFormat.IVR_BE_FILE_WO_PREAMBLE;
                    Object var19_9 = null;
                    inputStream.reset();
                    return fileFormat;
                }
                case 1: {
                    FileFormat fileFormat = FileFormat.IVR_BE_STREAM;
                    Object var19_10 = null;
                    inputStream.reset();
                    return fileFormat;
                }
            }
            inputStream.reset();
            if (inputStream.skip(128L) != 128L || inputStream.read() != 68 || inputStream.read() != 73 || inputStream.read() != 67 || inputStream.read() != 77) {
                FileFormat fileFormat = null;
                Object var19_11 = null;
                inputStream.reset();
                return fileFormat;
            }
            if (this.testEVRFormat(DcmDecodeParam.EVR_LE) == 0) {
                FileFormat fileFormat = FileFormat.DICOM_FILE;
                Object var19_12 = null;
                inputStream.reset();
                return fileFormat;
            }
            inputStream.reset();
            if (inputStream.skip(132L) != 132L) {
                FileFormat fileFormat = null;
                Object var19_13 = null;
                inputStream.reset();
                return fileFormat;
            }
            if (this.testIVRFormat(DcmDecodeParam.IVR_LE) == 0) {
                FileFormat fileFormat = FileFormat.IVR_LE_FILE;
                Object var19_14 = null;
                inputStream.reset();
                return fileFormat;
            }
            inputStream.reset();
            if (inputStream.skip(132L) != 132L) {
                FileFormat fileFormat = null;
                Object var19_15 = null;
                inputStream.reset();
                return fileFormat;
            }
            if (this.testEVRFormat(DcmDecodeParam.EVR_BE) == 0) {
                FileFormat fileFormat = FileFormat.EVR_BE_FILE;
                Object var19_16 = null;
                inputStream.reset();
                return fileFormat;
            }
            inputStream.reset();
            if (inputStream.skip(132L) != 132L) {
                FileFormat fileFormat = null;
                Object var19_17 = null;
                inputStream.reset();
                return fileFormat;
            }
            if (this.testEVRFormat(DcmDecodeParam.IVR_BE) == 0) {
                FileFormat fileFormat = FileFormat.IVR_BE_FILE;
                Object var19_18 = null;
                inputStream.reset();
                return fileFormat;
            }
            Object var19_19 = null;
            inputStream.reset();
            throw new DcmParseException("Unknown Format");
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            inputStream.reset();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileFormat detectFileFormat(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        try {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            FileFormat fileFormat;
                            switch (this.testIVRFormat(DcmDecodeParam.IVR_LE)) {
                                case 0: {
                                    FileFormat fileFormat2 = FileFormat.IVR_LE_FILE_WO_PREAMBLE;
                                    Object var18_3 = null;
                                    imageInputStream.reset();
                                    return fileFormat2;
                                }
                                case 1: {
                                    FileFormat fileFormat3 = FileFormat.ACRNEMA_STREAM;
                                    Object var18_4 = null;
                                    imageInputStream.reset();
                                    return fileFormat3;
                                }
                            }
                            imageInputStream.reset();
                            imageInputStream.mark();
                            switch (this.testEVRFormat(DcmDecodeParam.EVR_LE)) {
                                case 0: {
                                    FileFormat fileFormat4 = FileFormat.DICOM_FILE_WO_PREAMBLE;
                                    Object var18_5 = null;
                                    imageInputStream.reset();
                                    return fileFormat4;
                                }
                                case 1: {
                                    FileFormat fileFormat5 = FileFormat.EVR_LE_STREAM;
                                    Object var18_6 = null;
                                    imageInputStream.reset();
                                    return fileFormat5;
                                }
                            }
                            imageInputStream.reset();
                            imageInputStream.mark();
                            switch (this.testEVRFormat(DcmDecodeParam.EVR_BE)) {
                                case 0: {
                                    FileFormat fileFormat6 = FileFormat.EVR_BE_FILE_WO_PREAMBLE;
                                    Object var18_7 = null;
                                    imageInputStream.reset();
                                    return fileFormat6;
                                }
                                case 1: {
                                    FileFormat fileFormat7 = FileFormat.EVR_BE_STREAM;
                                    Object var18_8 = null;
                                    imageInputStream.reset();
                                    return fileFormat7;
                                }
                            }
                            imageInputStream.reset();
                            imageInputStream.mark();
                            switch (this.testIVRFormat(DcmDecodeParam.IVR_BE)) {
                                case 0: {
                                    FileFormat fileFormat8 = FileFormat.IVR_BE_FILE_WO_PREAMBLE;
                                    Object var18_9 = null;
                                    imageInputStream.reset();
                                    return fileFormat8;
                                }
                                case 1: {
                                    FileFormat fileFormat9 = FileFormat.IVR_BE_STREAM;
                                    Object var18_10 = null;
                                    imageInputStream.reset();
                                    return fileFormat9;
                                }
                            }
                            imageInputStream.reset();
                            imageInputStream.mark();
                            if (imageInputStream.skipBytes(128) != 128 || imageInputStream.read() != 68 || imageInputStream.read() != 73 || imageInputStream.read() != 67 || imageInputStream.read() != 77) {
                                FileFormat fileFormat10 = null;
                                Object var18_11 = null;
                                imageInputStream.reset();
                                return fileFormat10;
                            }
                            imageInputStream.mark();
                            try {
                                if (this.testEVRFormat(DcmDecodeParam.EVR_LE) != 0) break block25;
                                fileFormat = FileFormat.DICOM_FILE;
                                Object var16_27 = null;
                            }
                            catch (Throwable throwable) {
                                Object var16_32 = null;
                                imageInputStream.reset();
                                throw throwable;
                            }
                            imageInputStream.reset();
                            Object var18_12 = null;
                            imageInputStream.reset();
                            return fileFormat;
                        }
                        imageInputStream.reset();
                        imageInputStream.mark();
                        if (this.testIVRFormat(DcmDecodeParam.IVR_LE) != 0) break block26;
                        FileFormat fileFormat = FileFormat.IVR_LE_FILE;
                        Object var16_28 = null;
                        imageInputStream.reset();
                        Object var18_13 = null;
                        imageInputStream.reset();
                        return fileFormat;
                    }
                    imageInputStream.reset();
                    imageInputStream.mark();
                    if (this.testEVRFormat(DcmDecodeParam.EVR_BE) != 0) break block27;
                    FileFormat fileFormat = FileFormat.EVR_BE_FILE;
                    Object var16_29 = null;
                    imageInputStream.reset();
                    Object var18_14 = null;
                    imageInputStream.reset();
                    return fileFormat;
                }
                imageInputStream.reset();
                imageInputStream.mark();
                if (this.testEVRFormat(DcmDecodeParam.IVR_BE) != 0) break block28;
                FileFormat fileFormat = FileFormat.IVR_BE_FILE;
                Object var16_30 = null;
                imageInputStream.reset();
                Object var18_15 = null;
                imageInputStream.reset();
                return fileFormat;
            }
            Object var16_31 = null;
            imageInputStream.reset();
            Object var18_16 = null;
            imageInputStream.reset();
            throw new DcmParseException("Unknown Format");
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            imageInputStream.reset();
            throw throwable;
        }
    }

    public int parseHeader() throws IOException {
        this.eof = false;
        try {
            this.b12[0] = this.in.readByte();
        }
        catch (EOFException eOFException) {
            this.eof = true;
            log.debug("Detect EOF");
            return -1;
        }
        this.in.readFully(this.b12, 1, 7);
        this.rPos += 8L;
        this.rTag = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
        int n = 8;
        switch (this.rTag) {
            case -73728: 
            case -73715: 
            case -73507: {
                this.rVR = 0;
                this.rLen = this.bb12.getInt(4);
                break;
            }
            default: {
                if (!this.decodeParam.explicitVR) {
                    this.rVR = this.vrMap.lookup(this.rTag);
                    this.rLen = this.bb12.getInt(4);
                    break;
                }
                this.rVR = this.bb12.get(4) << 8 | this.bb12.get(5) & 0xFF;
                if (VRs.isLengthField16Bit(this.rVR)) {
                    this.rLen = this.bb12.getShort(6) & 0xFFFF;
                    break;
                }
                this.in.readFully(this.b12, 8, 4);
                this.rPos += 4L;
                this.rLen = this.bb12.getInt(8);
                n = 12;
            }
        }
        if (this.unBuf != null) {
            this.unBuf.write(this.b12, 0, n);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logMsg());
        }
        return n;
    }

    private byte[] parsePreamble() throws IOException {
        log.debug("rPos:" + this.rPos);
        byte[] byArray = new byte[128];
        this.in.readFully(byArray, 0, 128);
        this.rPos += 128L;
        this.in.readFully(this.b12, 0, 4);
        this.rPos += 4L;
        if (this.b12[0] != 68 || this.b12[1] != 73 || this.b12[2] != 67 || this.b12[3] != 77) {
            throw new DcmParseException("Missing DICM Prefix");
        }
        return byArray;
    }

    public long parseFileMetaInfo(boolean bl, DcmDecodeParam dcmDecodeParam) throws IOException {
        byte[] byArray;
        this.rPos = 0L;
        byte[] byArray2 = byArray = bl ? this.parsePreamble() : null;
        if (this.handler != null) {
            this.handler.startFileMetaInfo(byArray);
        }
        this.setDcmDecodeParam(dcmDecodeParam);
        this.parseGroup(2);
        if (this.handler != null) {
            this.handler.endFileMetaInfo();
        }
        return this.rPos;
    }

    public long parseFileMetaInfo() throws IOException {
        return this.parseFileMetaInfo(true, DcmDecodeParam.EVR_LE);
    }

    public long parseCommand() throws IOException {
        if (this.handler != null) {
            this.handler.startCommand();
        }
        this.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
        long l = this.parseGroup(0);
        if (this.handler != null) {
            this.handler.endCommand();
        }
        return l;
    }

    private long parseGroup(int n) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("parse group " + n);
        }
        if (this.handler != null) {
            this.handler.setDcmDecodeParam(this.decodeParam);
        }
        long l = this.rPos;
        int n2 = this.parseHeader();
        if (n2 != 8 || this.rTag >>> 16 != n || this.rVR != 21836 || this.rLen != 4) {
            throw new DcmParseException("hlen=" + n2 + ", " + this.logMsg());
        }
        this.in.readFully(this.b12, 0, 4);
        this.rPos += 4L;
        if (this.handler != null) {
            this.handler.startElement(this.rTag, this.rVR, l);
            byte[] byArray = new byte[4];
            System.arraycopy(this.b12, 0, byArray, 0, 4);
            this.handler.value(byArray, 0, 4);
            this.handler.endElement();
        }
        return this.doParse(-1, this.bb12.getInt(0)) + 12L;
    }

    public long parseDataset(DcmDecodeParam dcmDecodeParam, int n) throws IOException {
        this.setDcmDecodeParam(dcmDecodeParam);
        if (this.handler != null) {
            this.handler.startDataset();
            this.handler.setDcmDecodeParam(this.decodeParam);
        }
        long l = this.doParse(n, -1);
        if (this.handler != null) {
            this.handler.endDataset();
        }
        return l;
    }

    public long parseDcmFile(FileFormat fileFormat, int n) throws IOException {
        if (fileFormat == null) {
            fileFormat = this.detectFileFormat();
        }
        if (this.handler != null) {
            this.handler.startDcmFile();
        }
        DcmDecodeParam dcmDecodeParam = fileFormat.decodeParam;
        this.rPos = 0L;
        if (fileFormat.hasFileMetaInfo) {
            this.tsUID = null;
            this.parseFileMetaInfo(fileFormat.hasPreamble, fileFormat.decodeParam);
            if (this.tsUID == null) {
                log.warn("Missing Transfer Syntax UID in FMI");
            } else {
                dcmDecodeParam = DcmDecodeParam.valueOf(this.tsUID);
            }
        }
        this.parseDataset(dcmDecodeParam, n);
        if (this.handler != null) {
            this.handler.endDcmFile();
        }
        return this.rPos;
    }

    public long parseItemDataset() throws IOException {
        long l;
        this.in.readFully(this.b12, 0, 8);
        this.rPos += 8L;
        int n = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
        int n2 = this.bb12.getInt(4);
        if (n == -73507) {
            if (n2 != 0) {
                throw new DcmParseException("(fffe,e0dd), Length:" + n2);
            }
            return -1L;
        }
        if (n != -73728) {
            throw new DcmParseException(Tags.toString(n));
        }
        if (log.isDebugEnabled()) {
            log.debug("rpos:" + (this.rPos - 8L) + ",(fffe,e0dd)");
        }
        if (this.handler != null) {
            this.handler.startDataset();
        }
        if (n2 == -1) {
            l = this.doParse(-73715, n2);
            if (this.rTag != -73715 || this.rLen != 0) {
                throw new DcmParseException(this.logMsg());
            }
        } else {
            l = this.doParse(-1, n2);
        }
        if (this.handler != null) {
            this.handler.endDataset();
        }
        return 8L + l;
    }

    private long doParse(int n, int n2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rpos:" + this.rPos + ",stopTag:" + Tags.toString(n) + ",length:" + n2);
        }
        long l = 0L;
        if (n2 != 0) {
            long l2 = (long)n2 & 0xFFFFFFFFL;
            do {
                long l3 = this.rPos;
                int n3 = this.parseHeader();
                if (n3 == -1) {
                    if (n2 == -1) break;
                    throw new EOFException();
                }
                l += (long)n3;
                if (n == this.rTag) break;
                if (this.handler != null && this.unBuf == null && this.rTag != -73715) {
                    this.handler.startElement(this.rTag, this.rVR, l3);
                }
                if (this.rLen == -1 || this.rVR == 21329) {
                    switch (this.rVR) {
                        case 20290: 
                        case 20294: 
                        case 20311: 
                        case 21329: 
                        case 21838: {
                            break;
                        }
                        default: {
                            throw new DcmParseException(this.logMsg());
                        }
                    }
                    l += this.parseSequence(this.rVR, this.rLen);
                } else {
                    this.readValue();
                    l += (long)this.rLen;
                }
                if (this.handler == null || this.unBuf != null) continue;
                this.handler.endElement();
            } while (n2 == -1 || l < l2);
            if (n2 != -1 && l > l2) {
                throw new DcmParseException(this.logMsg() + ", Read: " + l + ", Length: " + l2);
            }
        }
        return l;
    }

    private long parseSequence(int n, int n2) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rPos:" + this.rPos + "," + VRs.toString(n) + " #" + n2);
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.startSequence(n2);
        }
        long l = 0L;
        if (n2 != 0) {
            int n3;
            long l2 = (long)n2 & 0xFFFFFFFFL;
            int n4 = 0;
            block4: do {
                this.in.readFully(this.b12, 0, 8);
                this.rPos += 8L;
                if (this.unBuf != null) {
                    this.unBuf.write(this.b12, 0, 8);
                }
                l += 8L;
                int n5 = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
                n3 = this.bb12.getInt(4);
                switch (n5) {
                    case -73507: {
                        if (n2 == -1 && n3 == 0) break block4;
                        throw new DcmParseException("(fffe,e0dd), Length:" + n3);
                    }
                    case -73728: {
                        break;
                    }
                    default: {
                        throw new DcmParseException(Tags.toString(n5));
                    }
                }
            } while (n2 == -1 || (l += this.parseItem(++n4, n, n3)) < l2);
            if (n2 != -1 && l > l2) {
                throw new DcmParseException(this.logMsg() + ", Read: " + l + ", Length: " + l2);
            }
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.endSequence(n2);
        }
        return l;
    }

    private long parseItem(int n, int n2, int n3) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rPos:" + this.rPos + "," + VRs.toString(n2) + " #" + n3);
        }
        switch (n2) {
            case 21329: {
                return this.parseSQItem(n, n3);
            }
            case 21838: {
                if (n3 == -1) {
                    return this.parseUNItem(n, n3);
                }
            }
            case 20290: 
            case 20294: 
            case 20311: {
                return this.readFragment(n, n3);
            }
        }
        throw new RuntimeException(this.logMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parseUNItem(int n, int n2) throws IOException {
        long l;
        if (this.unBuf != null) {
            l = this.parseSQItem(n, n2);
        } else {
            long l2 = this.rPos;
            this.unBuf = new ByteArrayOutputStream();
            DcmDecodeParam dcmDecodeParam = this.decodeParam;
            try {
                this.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
                this.bb12.order(ByteOrder.LITTLE_ENDIAN);
                l = this.parseSQItem(n, n2);
                if (this.handler != null) {
                    this.handler.fragment(n, l2 - 8L, this.unBuf.toByteArray(), 0, this.unBuf.size() - 8);
                }
                Object var9_6 = null;
                this.setDcmDecodeParam(dcmDecodeParam);
                this.unBuf = null;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                this.setDcmDecodeParam(dcmDecodeParam);
                this.unBuf = null;
                throw throwable;
            }
        }
        return l;
    }

    private long parseSQItem(int n, int n2) throws IOException {
        long l;
        if (this.handler != null && this.unBuf == null) {
            this.handler.startItem(n, this.rPos - 8L, n2);
        }
        if (n2 == -1) {
            l = this.doParse(-73715, n2);
            if (this.rTag != -73715 || this.rLen != 0) {
                throw new DcmParseException(this.logMsg());
            }
        } else {
            l = this.doParse(-1, n2);
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.endItem(n2);
        }
        return l;
    }

    private int readValue() throws IOException {
        byte[] byArray = this.readBytes(this.rLen);
        if (this.handler != null && this.unBuf == null) {
            this.handler.value(byArray, 0, this.rLen);
        }
        if (this.rTag == 131088) {
            this.tsUID = this.decodeUID(byArray, this.rLen - 1);
        }
        return this.rLen;
    }

    private String decodeUID(byte[] byArray, int n) {
        if (n < 0) {
            log.warn("Empty Transfer Syntax UID in FMI");
            return "";
        }
        try {
            return new String(byArray, 0, byArray[n] == 0 ? n : n + 1, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn("Decoding Transfer Syntax UID in FMI failed!", unsupportedEncodingException);
            return null;
        }
    }

    private int readFragment(int n, int n2) throws IOException {
        long l = this.rPos;
        byte[] byArray = this.readBytes(n2);
        if (this.handler != null && this.unBuf == null) {
            this.handler.fragment(n, l - 8L, byArray, 0, n2);
        }
        return n2;
    }

    private byte[] readBytes(int n) throws IOException {
        if (n == 0) {
            return this.b0;
        }
        if (n < 0 || n > this.maxAlloc) {
            throw new DcmParseException(this.logMsg() + ", MaxAlloc:" + this.maxAlloc);
        }
        byte[] byArray = new byte[n];
        this.in.readFully(byArray, 0, n);
        this.rPos += (long)n;
        if (this.unBuf != null) {
            this.unBuf.write(byArray, 0, n);
        }
        return byArray;
    }
}

