/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.image.ColorModelParam;

abstract class BasicColorModelParam
implements ColorModelParam {
    protected final int dataType;
    protected final int size;
    protected final int bits;
    protected final int bits_8;
    protected final int min;
    protected final int max;
    protected final int shiftmask;

    protected BasicColorModelParam(Dataset dataset) throws DcmValueException {
        int n = dataset.getInt(2621696, 8);
        switch (n) {
            case 8: {
                this.dataType = 0;
                break;
            }
            case 16: {
                this.dataType = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("" + n + " Bits Allocated not supported!");
            }
        }
        this.bits = dataset.getInt(2621697, 8);
        if (this.bits < 8 || this.bits > 16) {
            throw new UnsupportedOperationException("Bits Stored: " + this.bits + " not supported!");
        }
        this.bits_8 = this.bits - 8;
        int n2 = dataset.getInt(2621698, this.bits - 1);
        if (n2 != this.bits - 1) {
            throw new UnsupportedOperationException("High Bit: " + n2 + " not supported!");
        }
        this.size = 1 << this.bits;
        if (dataset.getInt(2621699, 0) == 0) {
            this.min = 0;
            this.max = this.size;
        } else {
            this.min = -(this.size >> 1);
            this.max = -this.min;
        }
        this.shiftmask = 32 - this.bits;
    }

    protected BasicColorModelParam(BasicColorModelParam basicColorModelParam) {
        this.dataType = basicColorModelParam.dataType;
        this.size = basicColorModelParam.size;
        this.bits = basicColorModelParam.bits;
        this.bits_8 = basicColorModelParam.bits_8;
        this.min = basicColorModelParam.min;
        this.max = basicColorModelParam.max;
        this.shiftmask = basicColorModelParam.shiftmask;
    }

    protected final int mask(int n) {
        return this.min == 0 ? n << this.shiftmask >>> this.shiftmask : n << this.shiftmask >> this.shiftmask;
    }
}

