/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import org.dcm4che.data.Command;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4cheri.data.FileMetaInfoImpl;

class DcmObjectHandlerImpl
implements DcmHandler {
    private final DcmObject result;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private DcmObject curDcmObject;
    private int tag;
    private int vr;
    private long pos;
    private final LinkedList seqStack = new LinkedList();

    public DcmObjectHandlerImpl(DcmObject dcmObject) {
        if (dcmObject == null) {
            throw new NullPointerException();
        }
        this.result = dcmObject;
    }

    public void startCommand() {
        this.curDcmObject = (Command)this.result;
        this.seqStack.clear();
    }

    public void endCommand() {
        this.curDcmObject = null;
    }

    public void startDcmFile() {
    }

    public void endDcmFile() {
    }

    public void startFileMetaInfo(byte[] byArray) {
        if (this.result instanceof Dataset) {
            this.curDcmObject = ((Dataset)this.result).getFileMetaInfo();
            if (this.curDcmObject == null) {
                this.curDcmObject = new FileMetaInfoImpl();
                ((Dataset)this.result).setFileMetaInfo((FileMetaInfo)this.curDcmObject);
            }
        } else {
            this.curDcmObject = (FileMetaInfo)this.result;
        }
        this.seqStack.clear();
        if (byArray != null && byArray.length == 128) {
            System.arraycopy(byArray, 0, ((FileMetaInfo)this.curDcmObject).getPreamble(), 0, 128);
        }
    }

    public void endFileMetaInfo() {
        this.curDcmObject = this.result instanceof Dataset ? this.result : null;
    }

    public void startDataset() {
        this.curDcmObject = (Dataset)this.result;
        this.seqStack.clear();
    }

    public void endDataset() {
        this.curDcmObject = null;
    }

    public void setDcmDecodeParam(DcmDecodeParam dcmDecodeParam) {
        this.byteOrder = dcmDecodeParam.byteOrder;
    }

    public void startElement(int n, int n2, long l) throws IOException {
        this.tag = n;
        this.vr = n2;
        this.pos = l;
    }

    public void endElement() throws IOException {
    }

    public void startSequence(int n) throws IOException {
        this.seqStack.add(this.vr == 21329 ? this.curDcmObject.putSQ(this.tag) : this.curDcmObject.putXXsq(this.tag, this.vr));
    }

    public void endSequence(int n) throws IOException {
        this.seqStack.removeLast();
    }

    public void value(byte[] byArray, int n, int n2) throws IOException {
        this.curDcmObject.putXX(this.tag, this.vr, ByteBuffer.wrap(byArray, n, n2).order(this.byteOrder)).setStreamPosition(this.pos);
    }

    public void fragment(int n, long l, byte[] byArray, int n2, int n3) throws IOException {
        ((DcmElement)this.seqStack.getLast()).addDataFragment(ByteBuffer.wrap(byArray, n2, n3).order(this.byteOrder));
    }

    public void startItem(int n, long l, int n2) throws IOException {
        this.curDcmObject = ((DcmElement)this.seqStack.getLast()).addNewItem().setItemOffset(l);
    }

    public void endItem(int n) throws IOException {
        this.curDcmObject = ((Dataset)this.curDcmObject).getParent();
    }
}

