/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Equipment;
import org.dcm4che.srom.Patient;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.SRDocument;
import org.dcm4che.srom.Series;
import org.dcm4che.srom.Study;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.Verification;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.EquipmentImpl;
import org.dcm4cheri.srom.KeyObjectImpl;
import org.dcm4cheri.srom.PatientImpl;
import org.dcm4cheri.srom.SOPInstanceRefImpl;
import org.dcm4cheri.srom.SeriesImpl;
import org.dcm4cheri.srom.StudyImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.VerificationImpl;

class SRDocumentImpl
extends KeyObjectImpl
implements SRDocument {
    private static UIDDictionary uidDict = DictionaryFactory.getInstance().getDefaultUIDDictionary();
    private boolean complete = false;
    private String completionFlagDescription = null;
    private boolean verified = false;
    private final List verifications = new LinkedList();
    private final List predecessorDocuments = new LinkedList();
    private final List procedureCodes = new LinkedList();
    private final List otherEvidence = new LinkedList();

    SRDocumentImpl(Patient patient, Study study, Series series, Equipment equipment, String string, String string2, int n, Date date, Template template, Code code, boolean bl) {
        super(patient, study, series, equipment, string, string2, n, date, template, code, bl, "SR");
    }

    static SRDocument newSRDocument(Dataset dataset) throws DcmValueException {
        if (!"CONTAINER".equals(dataset.getString(0x40A040))) {
            throw new IllegalArgumentException(dataset.getString(0x40A040));
        }
        SRDocumentImpl sRDocumentImpl = new SRDocumentImpl(new PatientImpl(dataset), new StudyImpl(dataset), new SeriesImpl(dataset), new EquipmentImpl(dataset), dataset.getString(524310), dataset.getString(524312), dataset.getInt(2097171, -1), dataset.getDate(4235314), new TemplateImpl(dataset.getItem(4236548)), new CodeImpl(dataset.getItem(4235331)), "SEPARATE".equals(dataset.getString(4235344)));
        sRDocumentImpl.init(dataset);
        return sRDocumentImpl;
    }

    protected void init(Dataset dataset) throws DcmValueException {
        super.init(dataset);
        this.complete = "COMPLETE".equals(dataset.getString(4236433));
        this.completionFlagDescription = dataset.getString(4236434);
        this.verified = "VERIFIED".equals(dataset.getString(4236435));
        this.initVerifications(dataset.get(4235379));
        this.initSOPInstanceRefList(this.predecessorDocuments, dataset.get(4236128));
        this.setProcedureCodes(CodeImpl.newCodes(dataset.get(4236146)));
        this.initSOPInstanceRefList(this.otherEvidence, dataset.get(4236165));
    }

    private void initVerifications(DcmElement dcmElement) throws DcmValueException {
        if (dcmElement == null) {
            return;
        }
        int n = 0;
        int n2 = dcmElement.vm();
        while (n < n2) {
            this.addVerification(new VerificationImpl(dcmElement.getItem(n)));
            ++n;
        }
    }

    public String toString() {
        return uidDict.lookup(this.sopClassUID) + "[" + this.getName().getCodeMeaning() + "," + this.sopInstanceUID + ",#" + this.instanceNumber + "," + this.getContentDateTime() + (this.complete ? ",complete" : ",partial") + (this.verified ? ",verified" : ",unverified") + "]";
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean bl) {
        this.complete = bl;
    }

    public String getCompletionFlagDescription() {
        return this.completionFlagDescription;
    }

    public void setCompletionFlagDescription(String string) {
        this.completionFlagDescription = string;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public Verification[] getVerifications() {
        return this.verifications.toArray(VerificationImpl.EMPTY_ARRAY);
    }

    public void setVerifications(Verification[] verificationArray) {
        List list = KeyObjectImpl.checkList(verificationArray);
        this.verifications.clear();
        this.verifications.addAll(list);
    }

    public boolean addVerification(Verification verification) {
        if (verification == null) {
            throw new NullPointerException();
        }
        return this.verifications.add(verification);
    }

    public boolean removeVerification(Verification verification) {
        return this.verifications.remove(verification);
    }

    public SOPInstanceRef[] getPredecessorDocuments() {
        return this.predecessorDocuments.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public void setPredecessorDocuments(SOPInstanceRef[] sOPInstanceRefArray) {
        List list = KeyObjectImpl.checkList(sOPInstanceRefArray);
        this.predecessorDocuments.clear();
        this.predecessorDocuments.addAll(list);
    }

    public boolean addPredecessorDocument(SOPInstanceRef sOPInstanceRef) {
        if (sOPInstanceRef == null) {
            throw new NullPointerException();
        }
        if (this.predecessorDocuments.indexOf(sOPInstanceRef) != -1) {
            return false;
        }
        return this.predecessorDocuments.add(sOPInstanceRef);
    }

    public boolean removePredecessorDocument(RefSOP refSOP) {
        return this.predecessorDocuments.remove(refSOP);
    }

    public Code[] getProcedureCodes() {
        return this.procedureCodes.toArray(CodeImpl.EMPTY_ARRAY);
    }

    public void setProcedureCodes(Code[] codeArray) {
        List list = KeyObjectImpl.checkList(codeArray);
        this.procedureCodes.clear();
        this.procedureCodes.addAll(list);
    }

    public boolean addProcedureCode(Code code) {
        if (code == null) {
            throw new NullPointerException();
        }
        if (this.procedureCodes.indexOf(code) != -1) {
            return false;
        }
        return this.procedureCodes.add(code);
    }

    public boolean removeProcedureCode(Code code) {
        return this.procedureCodes.remove(code);
    }

    public SOPInstanceRef[] getOtherEvidence() {
        return this.otherEvidence.toArray(SOPInstanceRefImpl.EMPTY_ARRAY);
    }

    public SOPInstanceRef findOtherEvidence(RefSOP refSOP) {
        return KeyObjectImpl.findSOPInstanceRef(this.otherEvidence, refSOP);
    }

    public void setOtherEvidence(SOPInstanceRef[] sOPInstanceRefArray) {
        List list = KeyObjectImpl.checkList(sOPInstanceRefArray);
        this.otherEvidence.clear();
        this.otherEvidence.addAll(list);
    }

    public boolean addOtherEvidence(SOPInstanceRef sOPInstanceRef) {
        if (sOPInstanceRef == null) {
            throw new NullPointerException();
        }
        if (this.otherEvidence.indexOf(sOPInstanceRef) != -1) {
            return false;
        }
        return this.otherEvidence.add(sOPInstanceRef);
    }

    public boolean removeOtherEvidence(RefSOP refSOP) {
        return this.otherEvidence.remove(refSOP);
    }

    public void toDataset(Dataset dataset) {
        Iterator iterator;
        DcmElement dcmElement;
        super.toDataset(dataset);
        dataset.putCS(4236433, this.complete ? "COMPLETE" : "PARTIAL");
        dataset.putLO(4236434, this.completionFlagDescription);
        dataset.putCS(4236435, this.verified ? "VERIFIED" : "UNVERIFIED");
        if (!this.verifications.isEmpty()) {
            dcmElement = dataset.putSQ(4235379);
            iterator = this.verifications.iterator();
            while (iterator.hasNext()) {
                ((Verification)iterator.next()).toDataset(dcmElement.addNewItem());
            }
        }
        if (!this.predecessorDocuments.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.predecessorDocuments, dataset.putSQ(4236128));
        }
        if (!this.procedureCodes.isEmpty()) {
            dcmElement = dataset.putSQ(4236146);
            iterator = this.procedureCodes.iterator();
            while (iterator.hasNext()) {
                ((Code)iterator.next()).toDataset(dcmElement.addNewItem());
            }
        }
        if (!this.otherEvidence.isEmpty()) {
            KeyObjectImpl.sopInstanceRefListToSQ(this.otherEvidence, dataset.putSQ(4236165));
        }
    }
}

