/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.srom.CodeContent;
import org.dcm4che.srom.CompositeContent;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.NumContent;
import org.dcm4che.srom.PNameContent;
import org.dcm4che.srom.ReferencedContent;
import org.dcm4che.srom.RelationConstraints;
import org.dcm4che.srom.SCoordContent;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.TextContent;
import org.dcm4che.srom.UIDRefContent;
import org.dcm4che.srom.WaveformContent;

abstract class RelationConstraintsImpl
implements RelationConstraints {
    public static final RelationConstraints KEY_OBJECT = new RelationConstraints(){

        public void check(Content content, Content.RelationType relationType, Content content2) {
            if (!(content instanceof ContainerContent)) {
                throw new IllegalArgumentException("" + content);
            }
            if (relationType == Content.RelationType.CONTAINS) {
                if (!(content2 instanceof TextContent) && !(content2 instanceof CompositeContent)) {
                    throw new IllegalArgumentException("" + content2);
                }
            } else if (relationType == Content.RelationType.HAS_OBS_CONTEXT) {
                if (!(content2 instanceof TextContent || content2 instanceof CodeContent || content2 instanceof UIDRefContent || content2 instanceof PNameContent)) {
                    throw new IllegalArgumentException("" + content2);
                }
            } else if (relationType == Content.RelationType.HAS_CONCEPT_MOD) {
                if (!(content2 instanceof CodeContent)) {
                    throw new IllegalArgumentException("" + content2);
                }
            } else {
                throw new IllegalArgumentException("" + relationType);
            }
        }
    };
    public static final RelationConstraints BASIC_TEXT_SR = new RelationConstraintsImpl(){

        void checkTarget(Content content) {
            if (content instanceof ReferencedContent || content instanceof NumContent || content instanceof SCoordContent || content instanceof TCoordContent) {
                throw new IllegalArgumentException("" + content);
            }
        }

        void checkSelectedFrom(Content content, Content content2) {
            throw new IllegalArgumentException("" + Content.RelationType.SELECTED_FROM);
        }
    };
    public static final RelationConstraints ENHANCED_SR = new RelationConstraintsImpl(){

        void checkTarget(Content content) {
            if (content instanceof ReferencedContent) {
                throw new IllegalArgumentException("" + content);
            }
        }
    };

    RelationConstraintsImpl() {
    }

    public static RelationConstraints valueOf(String string) {
        if ("1.2.840.10008.5.1.4.1.1.88.11".equals(string)) {
            return BASIC_TEXT_SR;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.22".equals(string)) {
            return ENHANCED_SR;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.33".equals(string)) {
            return null;
        }
        if ("1.2.840.10008.5.1.4.1.1.88.59".equals(string)) {
            return KEY_OBJECT;
        }
        return null;
    }

    static boolean isContainerOrComposite(Content content) {
        return content instanceof ContainerContent || content instanceof CompositeContent;
    }

    void checkTarget(Content content) {
    }

    void checkContains(Content content, Content content2) {
        if (!(content instanceof ContainerContent)) {
            throw new IllegalArgumentException("" + content);
        }
    }

    void checkHasObsContext(Content content, Content content2) {
        if (!(content instanceof ContainerContent)) {
            throw new IllegalArgumentException("" + content);
        }
        if (RelationConstraintsImpl.isContainerOrComposite(content2)) {
            throw new IllegalArgumentException("" + content2);
        }
    }

    void checkHasAcqContext(Content content, Content content2) {
        if (!RelationConstraintsImpl.isContainerOrComposite(content)) {
            throw new IllegalArgumentException("" + content);
        }
        if (RelationConstraintsImpl.isContainerOrComposite(content2)) {
            throw new IllegalArgumentException("" + content2);
        }
    }

    void checkHasConceptMod(Content content, Content content2) {
        if (!(content2 instanceof TextContent) && !(content2 instanceof CodeContent)) {
            throw new IllegalArgumentException("" + content2);
        }
    }

    void checkHasProperties(Content content, Content content2) {
        if (!(content instanceof TextContent)) {
            throw new IllegalArgumentException("" + content);
        }
        if (content2 instanceof ContainerContent) {
            throw new IllegalArgumentException("" + content2);
        }
    }

    void checkInferredFrom(Content content, Content content2) {
        this.checkHasProperties(content, content2);
    }

    void checkSelectedFrom(Content content, Content content2) {
        if (content instanceof SCoordContent) {
            if (!(content2 instanceof ImageContent)) {
                throw new IllegalArgumentException("" + content2);
            }
        } else if (content instanceof TCoordContent) {
            if (!(content2 instanceof SCoordContent || content2 instanceof ImageContent || content2 instanceof WaveformContent)) {
                throw new IllegalArgumentException("" + content2);
            }
        } else {
            throw new IllegalArgumentException("" + content);
        }
    }

    public void check(Content content, Content.RelationType relationType, Content content2) {
        this.checkTarget(content2);
        if (relationType == Content.RelationType.CONTAINS) {
            this.checkContains(content, content2);
        } else if (relationType == Content.RelationType.HAS_OBS_CONTEXT) {
            this.checkHasObsContext(content, content2);
        } else if (relationType == Content.RelationType.HAS_ACQ_CONTEXT) {
            this.checkHasAcqContext(content, content2);
        } else if (relationType == Content.RelationType.HAS_CONCEPT_MOD) {
            this.checkHasConceptMod(content, content2);
        } else if (relationType == Content.RelationType.HAS_PROPERTIES) {
            this.checkHasProperties(content, content2);
        } else if (relationType == Content.RelationType.INFERRED_FROM) {
            this.checkInferredFrom(content, content2);
        } else if (relationType == Content.RelationType.SELECTED_FROM) {
            this.checkSelectedFrom(content, content2);
        } else {
            throw new IllegalArgumentException("" + relationType);
        }
    }
}

