/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Request;
import org.dcm4cheri.srom.CodeImpl;

class RequestImpl
implements Request {
    static final Request[] EMPTY_ARRAY = new Request[0];
    private final String studyInstanceUID;
    private final String accessionNumber;
    private final String fillerOrderNumber;
    private final String placerOrderNumber;
    private final String procedureID;
    private final String procedureDescription;
    private final Code procedureCode;

    public RequestImpl(String string, String string2, String string3, String string4, String string5, String string6, Code code) {
        this.studyInstanceUID = string;
        if (this.studyInstanceUID.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.accessionNumber = string2;
        this.fillerOrderNumber = string3;
        this.placerOrderNumber = string4;
        this.procedureID = string5;
        this.procedureDescription = string6;
        this.procedureCode = code;
    }

    public RequestImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(0x20000D), dataset.getString(524368), dataset.getString(4202519), dataset.getString(4202518), dataset.getString(0x401001), dataset.getString(3280992), CodeImpl.newCode(dataset.getItem(3280996)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RequestImpl)) {
            return false;
        }
        RequestImpl requestImpl = (RequestImpl)object;
        return this.studyInstanceUID.equals(requestImpl.studyInstanceUID);
    }

    public int hashCode() {
        return this.studyInstanceUID.hashCode();
    }

    public String toString() {
        return "Request[uid=" + this.studyInstanceUID + ",accession=" + this.accessionNumber + ",fillerOrd=" + this.fillerOrderNumber + ",placerOrd=" + this.placerOrderNumber + ",procedure(" + this.procedureID + "," + this.procedureDescription + "," + this.procedureCode + ")]";
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getFillerOrderNumber() {
        return this.fillerOrderNumber;
    }

    public String getPlacerOrderNumber() {
        return this.placerOrderNumber;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getProcedureID() {
        return this.procedureID;
    }

    public String getProcedureDescription() {
        return this.procedureDescription;
    }

    public Code getProcedureCode() {
        return this.procedureCode;
    }

    public void toDataset(Dataset dataset) {
        dataset.putUI(0x20000D, this.studyInstanceUID);
        dataset.putLO(524368, this.accessionNumber);
        dataset.putLO(4202519, this.fillerOrderNumber);
        dataset.putLO(4202518, this.placerOrderNumber);
        dataset.putSH(0x401001, this.procedureID);
        dataset.putLO(3280992, this.procedureDescription);
        if (this.procedureCode != null) {
            this.procedureCode.toDataset(dataset.putSQ(3280996).addNewItem());
        }
    }
}

