/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Equipment;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Patient;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Request;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.SRDocument;
import org.dcm4che.srom.SRDocumentFactory;
import org.dcm4che.srom.Series;
import org.dcm4che.srom.Study;
import org.dcm4che.srom.TCoordContent;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.Verification;
import org.dcm4cheri.srom.CodeImpl;
import org.dcm4cheri.srom.EquipmentImpl;
import org.dcm4cheri.srom.KeyObjectImpl;
import org.dcm4cheri.srom.PatientImpl;
import org.dcm4cheri.srom.RefSOPImpl;
import org.dcm4cheri.srom.RequestImpl;
import org.dcm4cheri.srom.SOPInstanceRefImpl;
import org.dcm4cheri.srom.SRDocumentImpl;
import org.dcm4cheri.srom.SeriesImpl;
import org.dcm4cheri.srom.StudyImpl;
import org.dcm4cheri.srom.TCoordContentImpl;
import org.dcm4cheri.srom.TemplateImpl;
import org.dcm4cheri.srom.VerificationImpl;

public class SRDocumentFactoryImpl
extends SRDocumentFactory {
    static final DcmObjectFactory dsfact = DcmObjectFactory.getInstance();

    public RefSOP newRefSOP(String string, String string2) {
        return new RefSOPImpl(string, string2);
    }

    public Patient newPatient(String string, String string2, Patient.Sex sex, Date date) {
        return new PatientImpl(string, string2, sex, date);
    }

    public Study newStudy(String string, String string2, Date date, String string3, String string4, String string5, Code[] codeArray) {
        return new StudyImpl(string, string2, date, string3, string4, string5, codeArray);
    }

    public Series newSeries(String string, String string2, int n, RefSOP refSOP) {
        return new SeriesImpl(string, string2, n, refSOP);
    }

    public Series newSRSeries(String string, int n, RefSOP refSOP) {
        return new SeriesImpl("SR", string, n, refSOP);
    }

    public Series newKOSeries(String string, int n, RefSOP refSOP) {
        return new SeriesImpl("KO", string, n, refSOP);
    }

    public Equipment newEquipment(String string, String string2, String string3) {
        return new EquipmentImpl(string, string2, string3);
    }

    public Code newCode(String string, String string2, String string3, String string4) {
        return new CodeImpl(string, string2, string3, string4);
    }

    public Code newCode(String string, String string2, String string3) {
        return new CodeImpl(string, string2, null, string3);
    }

    public Template newTemplate(String string, String string2, Date date, Date date2) {
        return new TemplateImpl(string, string2, date, date2);
    }

    public Template newTemplate(String string, String string2) {
        return new TemplateImpl(string, string2, null, null);
    }

    public Verification newVerification(Date date, String string, String string2, Code code) {
        return new VerificationImpl(date, string, string2, code);
    }

    public Request newRequest(String string, String string2, String string3, String string4, String string5, String string6, Code code) {
        return new RequestImpl(string, string2, string3, string4, string5, string6, code);
    }

    public SOPInstanceRef newSOPInstanceRef(String string, String string2, String string3, String string4) {
        return new SOPInstanceRefImpl(string, string2, string3, string4);
    }

    public TCoordContent.Positions.Sample newSamplePositions(int[] nArray) {
        return new TCoordContentImpl.SamplePositions(nArray);
    }

    public TCoordContent.Positions.Relative newRelativePositions(float[] fArray) {
        return new TCoordContentImpl.RelativePositions(fArray);
    }

    public TCoordContent.Positions.Absolute newAbsolutePositions(Date[] dateArray) {
        return new TCoordContentImpl.AbsolutePositions(dateArray);
    }

    public KeyObject newKeyObject(Patient patient, Study study, Series series, Equipment equipment, String string, int n, Date date, Code code, boolean bl) {
        return new KeyObjectImpl(patient, study, series, equipment, string, n, date, code, bl);
    }

    public SRDocument newSRDocument(Patient patient, Study study, Series series, Equipment equipment, String string, String string2, int n, Date date, Template template, Code code, boolean bl) {
        return new SRDocumentImpl(patient, study, series, equipment, string, string2, n, date, template, code, bl);
    }

    public Patient newPatient(Dataset dataset) throws DcmValueException {
        return new PatientImpl(dataset);
    }

    public Study newStudy(Dataset dataset) throws DcmValueException {
        return new StudyImpl(dataset);
    }

    public Series newSeries(Dataset dataset) throws DcmValueException {
        return new SeriesImpl(dataset);
    }

    public Equipment newEquipment(Dataset dataset) throws DcmValueException {
        return new EquipmentImpl(dataset);
    }

    public Code newCode(Dataset dataset) throws DcmValueException {
        return CodeImpl.newCode(dataset);
    }

    public RefSOP newRefSOP(Dataset dataset) throws DcmValueException {
        return RefSOPImpl.newRefSOP(dataset);
    }

    public Template newTemplate(Dataset dataset) throws DcmValueException {
        return TemplateImpl.newTemplate(dataset);
    }

    public SRDocument newSRDocument(Dataset dataset) throws DcmValueException {
        return SRDocumentImpl.newSRDocument(dataset);
    }

    public KeyObject newKeyObject(Dataset dataset) throws DcmValueException {
        return KeyObjectImpl.newKeyObject(dataset);
    }
}

