/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che.util;

import java.util.StringTokenizer;

public final class DcmURL {
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final int DICOM_PORT = 104;
    private static final int DELIMITER = -1;
    private static final int CALLED_AET = 0;
    private static final int CALLING_AET = 1;
    private static final int HOST = 2;
    private static final int PORT = 3;
    private static final int END = 4;
    private String calledAET;
    private String callingAET = "ANONYMOUS";
    private String host;
    private int port = 104;

    public DcmURL(String string) {
        this.parse(string.trim());
        if (this.calledAET == null) {
            throw new IllegalArgumentException("Missing called AET");
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Missing host name");
        }
    }

    public DcmURL(String string, String string2, String string3, int n) {
        this.calledAET = string;
        this.callingAET = string2;
        this.host = string3;
        this.port = n;
    }

    public final String getCallingAET() {
        return this.callingAET;
    }

    public final String getCalledAET() {
        return this.calledAET;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public String toString() {
        return "dicom://" + this.calledAET + ':' + this.callingAET + '@' + this.host + ':' + this.port;
    }

    private void parse(String string) {
        if (!string.startsWith("dicom://")) {
            throw new IllegalArgumentException("DICOM URL must starts with \"dicom://\"");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(8), ":@/", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case ':': {
                    n = bl ? 3 : 1;
                    break;
                }
                case '@': {
                    bl = true;
                    n = 2;
                    break;
                }
                case '/': {
                    return;
                }
                default: {
                    switch (n) {
                        case 0: {
                            this.calledAET = string2;
                            break;
                        }
                        case 1: {
                            this.callingAET = string2;
                            break;
                        }
                        case 2: {
                            this.host = string2;
                            break;
                        }
                        case 3: {
                            this.port = Integer.parseInt(string2);
                            return;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    n = -1;
                }
            }
        }
    }
}

