/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.imageio.plugins;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.imageio.plugins.DcmImageWriteParam;
import org.dcm4che.imageio.plugins.DcmMetadata;
import org.dcm4che.util.UIDGenerator;
import org.dcm4cheri.imageio.plugins.DcmImageWriteParamImpl;
import org.dcm4cheri.imageio.plugins.DcmMetadataImpl;

public class DcmImageWriter
extends ImageWriter {
    public static final String VERSION = "1.0";

    public DcmImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new DcmImageWriteParamImpl();
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HHmmss.SSS");
        Dataset dataset = DcmObjectFactory.getInstance().newDataset();
        UIDGenerator uIDGenerator = UIDGenerator.getInstance();
        dataset.putPN(0x100010, "PatientName");
        dataset.putLO(0x100020, "PatientID");
        dataset.putDA(0x100030, "19501031");
        dataset.putCS(0x100040, "O");
        dataset.putUI(0x20000D, uIDGenerator.createUID());
        dataset.putDA(524320, simpleDateFormat.format(date));
        dataset.putTM(524336, simpleDateFormat2.format(date));
        dataset.putPN(524432, "ReferringPhysicianName");
        dataset.putSH(0x200010, "1");
        dataset.putSH(524368, "0");
        dataset.putCS(524384, "OT");
        dataset.putUI(0x20000E, uIDGenerator.createUID());
        dataset.putIS(0x200011, "1");
        dataset.putCS(0x200060, "");
        dataset.putCS(524388, "WSD");
        dataset.putCS(524384, "OT");
        dataset.putLO(0x181010, "");
        dataset.putLO(1576982, "dcm4cheri");
        dataset.putLO(1576985, VERSION);
        dataset.putIS(2097171, "1");
        String[] stringArray = new String[]{"", ""};
        dataset.putCS(0x200020, stringArray);
        dataset.putDA(524323, simpleDateFormat.format(date));
        dataset.putTM(524339, simpleDateFormat2.format(date));
        dataset.putDA(1576978, simpleDateFormat.format(date));
        dataset.putTM(1576980, simpleDateFormat2.format(date));
        dataset.putUI(524310, "1.2.840.10008.5.1.4.1.1.7");
        dataset.putUI(524312, uIDGenerator.createUID());
        return new DcmMetadataImpl(dataset);
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("output == null" + this);
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new UnsupportedOperationException("output != ImageOutputStream" + this);
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException("image == null" + this);
        }
        if (iIOImage.getRenderedImage() == null) {
            throw new IllegalArgumentException("RenderedImage == null" + this);
        }
        if (!(iIOMetadata instanceof DcmMetadata)) {
            throw new IllegalArgumentException("streamMetadata != DcmImageMetadata" + this);
        }
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        } else if (!(imageWriteParam instanceof DcmImageWriteParam)) {
            throw new UnsupportedOperationException("param != DcmImageWriteParam" + this);
        }
        DcmImageWriteParam dcmImageWriteParam = (DcmImageWriteParam)imageWriteParam;
        Dataset dataset = ((DcmMetadata)iIOMetadata).getDataset();
        if (dcmImageWriteParam.isWriteFMI()) {
            DcmObjectFactory.getInstance().newFileMetaInfo(dataset, "1.2.840.10008.1.2").write((ImageOutputStream)this.output);
        }
        switch (((BufferedImage)iIOImage.getRenderedImage()).getType()) {
            case 10: 
            case 11: {
                if (dcmImageWriteParam.isWriteAlwaysRGB()) {
                    this.writeRGB((BufferedImage)iIOImage.getRenderedImage(), dcmImageWriteParam, dataset);
                    break;
                }
                this.writeMONOCHROME((BufferedImage)iIOImage.getRenderedImage(), dcmImageWriteParam, dataset);
                break;
            }
            case 13: {
                if (dcmImageWriteParam.isWriteAlwaysRGB() | dcmImageWriteParam.isWriteIndexedAsRGB()) {
                    this.writeRGB((BufferedImage)iIOImage.getRenderedImage(), dcmImageWriteParam, dataset);
                    break;
                }
                this.writePALETTE((BufferedImage)iIOImage.getRenderedImage(), dcmImageWriteParam, dataset);
                break;
            }
            default: {
                this.writeRGB((BufferedImage)iIOImage.getRenderedImage(), dcmImageWriteParam, dataset);
            }
        }
    }

    private void writeRGB(BufferedImage bufferedImage, DcmImageWriteParam dcmImageWriteParam, Dataset dataset) throws IOException, IllegalArgumentException {
        Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle2 = dcmImageWriteParam.getSourceRegion() == null ? rectangle : rectangle.intersection(dcmImageWriteParam.getSourceRegion());
        if (rectangle2.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        BufferedImage bufferedImage2 = new BufferedImage(rectangle2.width, rectangle2.height, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, null);
        graphics2D.dispose();
        dataset.putUS(0x280002, 3);
        dataset.putUS(2621696, 8);
        dataset.putUS(2621697, 8);
        dataset.putUS(2621698, 7);
        dataset.putCS(2621444, "RGB");
        dataset.putUS(2621456, bufferedImage2.getHeight());
        dataset.putUS(2621457, bufferedImage2.getWidth());
        dataset.putUS(2621699, 0);
        dataset.putUS(2621446, 0);
        dataset.putIS(2621492, 1);
        int[] nArray = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        ByteBuffer byteBuffer = ByteBuffer.allocate(nArray.length * 3);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            byteBuffer.put((byte)(n2 >> 16 & 0xFF));
            byteBuffer.put((byte)(n2 >> 8 & 0xFF));
            byteBuffer.put((byte)(n2 & 0xFF));
            ++n;
        }
        dataset.putOB(2145386512, byteBuffer);
        dataset.writeDataset((ImageOutputStream)this.output, DcmEncodeParam.valueOf("1.2.840.10008.1.2"));
    }

    private void writeMONOCHROME(BufferedImage bufferedImage, DcmImageWriteParam dcmImageWriteParam, Dataset dataset) throws IOException, IllegalArgumentException {
        switch (bufferedImage.getType()) {
            case 11: {
                break;
            }
            case 10: {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 11);
                byte[] byArray = ((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData();
                short[] sArray = new short[byArray.length];
                int n = 0;
                while (n < byArray.length) {
                    sArray[n] = (short)(byArray[n] & 0xFF);
                    ++n;
                }
                DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, sArray.length);
                WritableRaster writableRaster = Raster.createWritableRaster(bufferedImage2.getSampleModel(), dataBufferUShort, new Point(0, 0));
                bufferedImage2.setData(writableRaster);
                bufferedImage = bufferedImage2;
                break;
            }
            default: {
                throw new IllegalArgumentException("BufferedImage not TYPE_USHORT_GRAY or TYPE_BYTE_GRAY." + this);
            }
        }
        Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle2 = dcmImageWriteParam.getSourceRegion() == null ? rectangle : rectangle.intersection(dcmImageWriteParam.getSourceRegion());
        if (rectangle2.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        BufferedImage bufferedImage3 = new BufferedImage(rectangle2.width, rectangle2.height, 11);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight(), rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, null);
        graphics2D.dispose();
        dataset.putUS(0x280002, 1);
        if (dcmImageWriteParam.isMONOCHROME2()) {
            dataset.putCS(2621444, "MONOCHROME2");
        } else {
            dataset.putCS(2621444, "MONOCHROME1");
        }
        dataset.putUS(2621456, bufferedImage3.getHeight());
        dataset.putUS(2621457, bufferedImage3.getWidth());
        int n = 16;
        dataset.putUS(2621696, n);
        int n2 = dcmImageWriteParam.getBitsStored();
        if (n2 == -1) {
            n2 = 16;
        } else if (n2 < 1 || n2 > n) {
            n2 = 16;
        }
        dataset.putUS(2621697, n2);
        int n3 = dcmImageWriteParam.getHighBit();
        if (n3 == -1) {
            n3 = n2 - 1;
        } else if (n3 < 0 || n3 > n2 - 1) {
            n3 = n2 - 1;
        }
        dataset.putUS(2621698, n3);
        dataset.putUS(2621699, 0);
        dataset.putIS(2621492, 1);
        short[] sArray = ((DataBufferUShort)bufferedImage3.getRaster().getDataBuffer()).getData();
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2);
        int n4 = 65535;
        int n5 = 0;
        int n6 = 0;
        while (n6 < sArray.length) {
            short s = sArray[n6];
            int n7 = s & 0xFFFF;
            if (n7 > n5) {
                n5 = n7;
            }
            if (n7 < n4) {
                n4 = n7;
            }
            byteBuffer.putShort(s);
            ++n6;
        }
        dataset.putOW(2145386512, byteBuffer);
        dataset.putSS(2621702, n4);
        dataset.putSS(2621703, n5);
        if (!dataset.contains(2625618)) {
            dataset.putDS(2625618, "0");
            dataset.putDS(2625619, "1");
            dataset.putLO(2625620, "PIXELVALUE");
        }
        if (!dataset.contains(2625616)) {
            String[] stringArray = new String[]{Integer.toString((n5 + n4) / 2)};
            dataset.putDS(2625616, stringArray);
            String[] stringArray2 = new String[]{Integer.toString((n5 - n4) / 2)};
            dataset.putDS(2625617, stringArray2);
            String[] stringArray3 = new String[]{"DcmImageWriter"};
            dataset.putLO(2625621, stringArray3);
        }
        dataset.writeDataset((ImageOutputStream)this.output, DcmEncodeParam.valueOf("1.2.840.10008.1.2"));
    }

    private void writePALETTE(BufferedImage bufferedImage, DcmImageWriteParam dcmImageWriteParam, Dataset dataset) throws IOException, IllegalArgumentException {
        Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle2 = dcmImageWriteParam.getSourceRegion() == null ? rectangle : rectangle.intersection(dcmImageWriteParam.getSourceRegion());
        if (rectangle2.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + this);
        }
        BufferedImage bufferedImage2 = new BufferedImage(rectangle2.width, rectangle2.height, 13);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, null);
        graphics2D.dispose();
        dataset.putUS(0x280002, 1);
        dataset.putCS(2621444, "PALETTE COLOR");
        dataset.putUS(2621456, bufferedImage2.getHeight());
        dataset.putUS(2621457, bufferedImage2.getWidth());
        dataset.putUS(2621696, 8);
        dataset.putUS(2621697, 8);
        dataset.putUS(2621698, 7);
        dataset.putUS(2621699, 0);
        dataset.putIS(2621492, 1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.putShort((short)256);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)8);
        dataset.putXX(2625793, 21843, byteBuffer);
        dataset.putXX(2625794, 21843, byteBuffer);
        dataset.putXX(2625795, 21843, byteBuffer);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        ((IndexColorModel)bufferedImage2.getColorModel()).getReds(byArray);
        ((IndexColorModel)bufferedImage2.getColorModel()).getGreens(byArray2);
        ((IndexColorModel)bufferedImage2.getColorModel()).getBlues(byArray3);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(512);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(512);
        ByteBuffer byteBuffer4 = ByteBuffer.allocate(512);
        int n = 0;
        while (n < 256) {
            byteBuffer2.putShort((short)(byArray[n] & 0xFF));
            byteBuffer3.putShort((short)(byArray2[n] & 0xFF));
            byteBuffer4.putShort((short)(byArray3[n] & 0xFF));
            ++n;
        }
        dataset.putXX(2626049, 21843, byteBuffer2);
        dataset.putXX(2626050, 21843, byteBuffer3);
        dataset.putXX(2626051, 21843, byteBuffer4);
        byte[] byArray4 = ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
        ByteBuffer byteBuffer5 = ByteBuffer.allocate(byArray4.length);
        int n2 = 0;
        while (n2 < byArray4.length) {
            byteBuffer5.put(byArray4[n2]);
            ++n2;
        }
        dataset.putOB(2145386512, byteBuffer5);
        dataset.writeDataset((ImageOutputStream)this.output, DcmEncodeParam.valueOf("1.2.840.10008.1.2"));
    }
}

