/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.ImageContent;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.RefSOP;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.CompositeContentImpl;

class ImageContentImpl
extends CompositeContentImpl
implements ImageContent {
    private static final int[] NULL_FRAMENUMBER = new int[0];
    protected int[] frameNumbers;
    protected RefSOP refPresentationSOP;

    ImageContentImpl(KeyObject keyObject, Date date, Template template, Code code, RefSOP refSOP, int[] nArray, RefSOP refSOP2) {
        super(keyObject, date, template, code, refSOP);
        this.setFrameNumbers(nArray);
        this.refPresentationSOP = refSOP2;
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new ImageContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.refSOP, this.frameNumbers, this.refPresentationSOP);
    }

    public String toString() {
        StringBuffer stringBuffer = this.prompt().append(this.refSOP);
        int n = 0;
        while (n < this.frameNumbers.length) {
            stringBuffer.append(",[").append(this.frameNumbers[0]).append("]");
            ++n;
        }
        if (this.refPresentationSOP != null) {
            stringBuffer.append(",").append(this.refPresentationSOP);
        }
        return stringBuffer.append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.IMAGE;
    }

    public final int[] getFrameNumbers() {
        return (int[])this.frameNumbers.clone();
    }

    public final void setFrameNumbers(int[] nArray) {
        this.frameNumbers = nArray != null ? (int[])nArray.clone() : NULL_FRAMENUMBER;
    }

    public final RefSOP getRefPresentationSOP() {
        return this.refPresentationSOP;
    }

    public final void setRefPresentationSOP(RefSOP refSOP) {
        this.refPresentationSOP = refSOP;
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        if (this.frameNumbers.length == 0 && this.refPresentationSOP == null) {
            return;
        }
        Dataset dataset2 = dataset.get(528793).getItem();
        if (this.frameNumbers.length != 0) {
            dataset2.putIS(528736, this.frameNumbers);
        }
        if (this.refPresentationSOP != null) {
            this.refPresentationSOP.toDataset(dataset2.putSQ(528793).addNewItem());
        }
    }
}

