/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.sql.Time;
import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.Template;
import org.dcm4che.srom.TimeContent;
import org.dcm4cheri.srom.NamedContentImpl;

class TimeContentImpl
extends NamedContentImpl
implements TimeContent {
    private long time;

    TimeContentImpl(KeyObject keyObject, Date date, Template template, Code code, long l) {
        super(keyObject, date, template, NamedContentImpl.checkNotNull(code));
        this.time = l;
    }

    TimeContentImpl(KeyObject keyObject, Date date, Template template, Code code, Date date2) {
        this(keyObject, date, template, code, date2.getTime() % 86400000L);
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new TimeContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.time);
    }

    public final void setName(Code code) {
        this.name = NamedContentImpl.checkNotNull(code);
    }

    public String toString() {
        return this.prompt().append('(').append(this.getTime()).append(')').toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.TIME;
    }

    public final Date getTime() {
        return new Time(this.time);
    }

    public final void setTime(Date date) {
        this.time = date.getTime() % 86400000L;
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putTM(4235554, this.getTime());
    }
}

