/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Equipment;

final class EquipmentImpl
implements Equipment {
    private String manufacturer;
    private String institutionName;
    private String institutionAddress;
    private String stationName;
    private String departmentName;
    private String modelName;

    public EquipmentImpl(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.manufacturer = string;
        this.modelName = string2;
        this.stationName = string3;
    }

    public EquipmentImpl(Equipment equipment) {
        this(equipment.getManufacturer(), equipment.getModelName(), equipment.getStationName());
        this.institutionName = equipment.getInstitutionName();
        this.institutionAddress = equipment.getInstitutionAddress();
        this.departmentName = equipment.getDepartmentName();
    }

    public EquipmentImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(524400), dataset.getString(528528), dataset.getString(528400));
        this.institutionName = dataset.getString(524416);
        this.institutionAddress = dataset.getString(524417);
        this.departmentName = dataset.getString(528448);
    }

    public final String getManufacturer() {
        return this.manufacturer;
    }

    public final void setManufacturer(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.manufacturer = string;
    }

    public final String getInstitutionName() {
        return this.institutionName;
    }

    public final void setInstitutionName(String string) {
        this.institutionName = string;
    }

    public final String getInstitutionAddress() {
        return this.institutionAddress;
    }

    public final void setInstitutionAddress(String string) {
        this.institutionAddress = string;
    }

    public final String getStationName() {
        return this.stationName;
    }

    public final void setStationName(String string) {
        this.stationName = string;
    }

    public final String getDepartmentName() {
        return this.departmentName;
    }

    public final void setDepartmentName(String string) {
        this.departmentName = string;
    }

    public final String getModelName() {
        return this.modelName;
    }

    public final void setModelName(String string) {
        this.modelName = string;
    }

    public String toString() {
        return "Equipment[manufacturer=" + this.manufacturer + ",station=" + this.stationName + ",model=" + this.modelName + "]";
    }

    public void toDataset(Dataset dataset) {
        dataset.putLO(524400, this.manufacturer);
        if (this.institutionName != null) {
            dataset.putLO(524416, this.institutionName);
        }
        if (this.institutionAddress != null) {
            dataset.putST(524417, this.institutionAddress);
        }
        if (this.stationName != null) {
            dataset.putSH(528400, this.stationName);
        }
        if (this.departmentName != null) {
            dataset.putLO(528448, this.departmentName);
        }
        if (this.modelName != null) {
            dataset.putLO(528528, this.modelName);
        }
    }
}

