/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.srom.Patient;

final class PatientImpl
implements Patient {
    private final String patientID;
    private final String patientName;
    private final Patient.Sex patientSex;
    private final Long patientBirthDate;

    public PatientImpl(String string, String string2, Patient.Sex sex, Date date) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.patientID = string;
        this.patientName = string2;
        this.patientSex = sex;
        this.patientBirthDate = date != null ? new Long(date.getTime()) : null;
    }

    public PatientImpl(Dataset dataset) throws DcmValueException {
        this(dataset.getString(0x100020), dataset.getString(0x100010), Patient.Sex.valueOf(dataset.getString(0x100040)), dataset.getDate(0x100030));
    }

    public final String getPatientID() {
        return this.patientID;
    }

    public final String getPatientName() {
        return this.patientName;
    }

    public final Patient.Sex getPatientSex() {
        return this.patientSex;
    }

    public final Date getPatientBirthDate() {
        return this.patientBirthDate != null ? new Date(this.patientBirthDate) : null;
    }

    public int hashCode() {
        return this.patientID.hashCode() + this.patientName.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Patient)) {
            return false;
        }
        Patient patient = (Patient)object;
        return this.patientID.equals(patient.getPatientID()) && this.patientName.equals(patient.getPatientName());
    }

    public String toString() {
        return "Patient[" + this.patientName + ",ID=" + this.patientID + "]";
    }

    public void toDataset(Dataset dataset) {
        dataset.putLO(0x100020, this.patientID);
        dataset.putPN(0x100010, this.patientName);
        dataset.putCS(0x100040, this.patientSex != null ? this.patientSex.toString() : null);
        dataset.putDA(0x100030, this.getPatientBirthDate());
    }
}

