function eccet_internal_savenamed_quote(dv) {
	return "'"+dv.replace(/'/g,"`")+"'";
}

function eccet_internal_savenamed_quote2(dv) {
	return '"'+dv.replace(/\"/g,"")+'"';
}

function eccet_savenamed_check_file_exists(filename) {
	var rc;
	rc=eccet_cmd_run_single_with_return("CECHO ${$root.func.file.exists("+eccet_internal_savenamed_quote2(filename)+")}");
	return (rc.substr(0,10)!="303 O.K. 0");
}

function eccet_savenamed(view,filename,format) {
	var rc;
	rc=eccet_cmd_run_single_with_return("VIEW_SET "+view);
	if (rc.substr(0,3)!='303') {
		alert("Can't activate view '"+view+"'.");
		return 1;
	}
	rc=eccet_cmd_run_single_with_return("RECORDSNAP "+eccet_string_quote(filename)+" "+format);
	if (rc.substr(0,3)!='303') {
		alert("Can't take snapshot.");
		return 1;
	}
	if (!eccet_savenamed_check_file_exists(filename)) {
		alert("Resulting File not found. Snapshot not taken?");
		return 1;
	}
	return 0;
}


function eccet_savenamed_checkexists(view,filename,format) {
	var rc;
	if (eccet_savenamed_check_file_exists(filename)) {
		if (false==confirm("File "+filename+" exists - overwrite?"))
			return 1;
	}
	return eccet_savenamed(view,filename,format);
}
