/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;

class DcmElementImpl
implements DcmElement {
    static final String CLASSNAME = "org.dcm4cheri.data.DcmElementImpl";
    static final Logger log = Logger.getLogger("org.dcm4cheri.data.DcmElementImpl");
    static final TagDictionary DICT = DictionaryFactory.getInstance().getDefaultTagDictionary();
    static final byte[] BYTE0 = new byte[0];
    static final ByteBuffer EMPTY_VALUE = ByteBuffer.wrap(BYTE0).order(ByteOrder.LITTLE_ENDIAN);
    int tag;
    long streamPos = -1L;

    public DcmElementImpl(int n) {
        this.tag = n;
    }

    public final int tag() {
        return this.tag;
    }

    public int vr() {
        return 0;
    }

    public int vm() {
        return 0;
    }

    public boolean isEmpty() {
        return this.vm() == 0;
    }

    public int length() {
        return -1;
    }

    public final DcmElement setStreamPosition(long l) {
        this.streamPos = l;
        return this;
    }

    public final long getStreamPosition() {
        return this.streamPos;
    }

    public int hashCode() {
        return this.tag;
    }

    public final int compareTo(Object object) {
        return (int)(((long)this.tag & 0xFFFFFFFFL) - (long)((DcmElementImpl)object).tag & 0xFFFFFFFFL);
    }

    public String toString() {
        return DcmElementImpl.toString(this.tag, this.vr(), this.vm(), this.length(), StringUtils.promptValue(this.vr(), this.getByteBuffer(), 64));
    }

    static String toString(int n, int n2, int n3, int n4, String string) {
        return DICT.toString(n) + "," + VRs.toString(n2) + ",*" + n3 + ",#" + n4 + ",[" + string + "]";
    }

    public ByteBuffer getByteBuffer() {
        throw new UnsupportedOperationException("" + this);
    }

    public ByteBuffer getByteBuffer(ByteOrder byteOrder) {
        throw new UnsupportedOperationException("" + this);
    }

    public boolean hasDataFragments() {
        return false;
    }

    public ByteBuffer getDataFragment(int n) {
        throw new UnsupportedOperationException("" + this);
    }

    public ByteBuffer getDataFragment(int n, ByteOrder byteOrder) {
        throw new UnsupportedOperationException("" + this);
    }

    public int getDataFragmentLength(int n) {
        throw new UnsupportedOperationException("" + this);
    }

    public final String getString(Charset charset) throws DcmValueException {
        return this.getString(0, charset);
    }

    public String getString(int n, Charset charset) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public String[] getStrings(Charset charset) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public final String getBoundedString(int n, Charset charset) throws DcmValueException {
        return this.getBoundedString(n, 0, charset);
    }

    public String getBoundedString(int n, int n2, Charset charset) throws DcmValueException {
        return this.getString(n2, charset);
    }

    public String[] getBoundedStrings(int n, Charset charset) throws DcmValueException {
        return this.getStrings(charset);
    }

    public final int getInt() throws DcmValueException {
        return this.getInt(0);
    }

    public int getInt(int n) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public int[] getInts() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public final int getTag() throws DcmValueException {
        return this.getTag(0);
    }

    public int getTag(int n) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public int[] getTags() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public final float getFloat() throws DcmValueException {
        return this.getFloat(0);
    }

    public float getFloat(int n) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public float[] getFloats() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public final double getDouble() throws DcmValueException {
        return this.getDouble(0);
    }

    public double getDouble(int n) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public double[] getDoubles() {
        throw new UnsupportedOperationException("" + this);
    }

    public final Date getDate() throws DcmValueException {
        return this.getDate(0);
    }

    public Date getDate(int n) throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    public Date[] getDates() throws DcmValueException {
        throw new UnsupportedOperationException("" + this);
    }

    protected int checkIndex(int n) {
        if (n < 0 || n >= this.vm()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", VM: " + this.vm());
        }
        return n;
    }

    public void addDataFragment(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("" + this);
    }

    public boolean hasItems() {
        return false;
    }

    public Dataset addNewItem() {
        throw new UnsupportedOperationException("" + this);
    }

    public void addItem(Dataset dataset) {
        throw new UnsupportedOperationException("" + this);
    }

    public Dataset getItem() {
        return this.getItem(0);
    }

    public Dataset getItem(int n) {
        throw new UnsupportedOperationException("" + this);
    }

    static ByteOrder swap(ByteOrder byteOrder) {
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    static void swapWords(ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 1) != 0) {
            throw new IllegalArgumentException("illegal value length: " + byteBuffer);
        }
        ByteOrder byteOrder = byteBuffer.order();
        ByteOrder byteOrder2 = DcmElementImpl.swap(byteOrder);
        int n = 0;
        int n2 = byteBuffer.limit();
        while (n < n2) {
            short s = byteBuffer.getShort(n);
            byteBuffer.order(byteOrder2).putShort(n, s).order(byteOrder);
            n += 2;
        }
        byteBuffer.order(byteOrder2);
    }

    static void swapInts(ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 3) != 0) {
            throw new IllegalArgumentException("illegal value length " + byteBuffer);
        }
        ByteOrder byteOrder = byteBuffer.order();
        ByteOrder byteOrder2 = DcmElementImpl.swap(byteOrder);
        int n = 0;
        int n2 = byteBuffer.limit();
        while (n < n2) {
            int n3 = byteBuffer.getInt(n);
            byteBuffer.order(byteOrder2).putInt(n, n3).order(byteOrder);
            n += 4;
        }
        byteBuffer.order(byteOrder2);
    }

    static void swapLongs(ByteBuffer byteBuffer) {
        if ((byteBuffer.limit() & 7) != 0) {
            throw new IllegalArgumentException("illegal value length " + byteBuffer);
        }
        ByteOrder byteOrder = byteBuffer.order();
        ByteOrder byteOrder2 = DcmElementImpl.swap(byteOrder);
        int n = 0;
        int n2 = byteBuffer.limit();
        while (n < n2) {
            long l = byteBuffer.getLong(n);
            byteBuffer.order(byteOrder2).putLong(n, l).order(byteOrder);
            n += 8;
        }
        byteBuffer.order(byteOrder2);
    }
}

