/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.image;

import java.awt.image.ColorModel;
import java.util.WeakHashMap;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.image.ColorModelFactory;
import org.dcm4che.image.ColorModelParam;
import org.dcm4cheri.image.MonochromeParam;
import org.dcm4cheri.image.PaletteColorParam;

public class ColorModelFactoryImpl
extends ColorModelFactory {
    private static final WeakHashMap cache = new WeakHashMap();

    public ColorModel getColorModel(ColorModelParam colorModelParam) {
        if (!colorModelParam.isCacheable()) {
            return colorModelParam.newColorModel();
        }
        ColorModel colorModel = (ColorModel)cache.get(colorModelParam);
        if (colorModel == null) {
            colorModel = colorModelParam.newColorModel();
            cache.put(colorModelParam, colorModel);
        }
        return colorModel;
    }

    public ColorModelParam makeParam(Dataset dataset) throws DcmValueException {
        String string = dataset.getString(2621444, "MONOCHROME2");
        if ("PALETTE COLOR".equals(string)) {
            return new PaletteColorParam(dataset);
        }
        if ("MONOCHROME1".equals(string)) {
            return new MonochromeParam(dataset, "INVERSE");
        }
        if ("MONOCHROME2".equals(string)) {
            return new MonochromeParam(dataset, "IDENTITY");
        }
        throw new UnsupportedOperationException("Photometric Interpretation " + string + " not supported!");
    }
}

