/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class DcmHandlerAdapter
implements DcmHandler {
    private static final Attributes EMPTY_ATTR = new AttributesImpl();
    private final ContentHandler handler;
    private final TagDictionary dict;
    private boolean explicitVR;
    private ByteOrder byteOrder;
    private static final int UNDEF = 0;
    private static final int COMMAND = 1;
    private static final int FILEMETAINFO = 2;
    private static final int DATASET = 3;
    private static final int DCMFILE = 4;
    private int docType = 0;
    private int vr;

    public DcmHandlerAdapter(ContentHandler contentHandler, TagDictionary tagDictionary) {
        this.handler = contentHandler;
        this.dict = tagDictionary;
    }

    public void startCommand() throws IOException {
        this.start(1, "command", EMPTY_ATTR);
    }

    public void endCommand() throws IOException {
        this.end(1, "command");
    }

    public void startFileMetaInfo(byte[] byArray) throws IOException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (byArray != null) {
            attributesImpl.addAttribute("", "preamble", "preamble", "", StringUtils.promptBytes(byArray, 0, byArray.length));
        }
        this.start(2, "filemetainfo", attributesImpl);
    }

    public void endFileMetaInfo() throws IOException {
        this.end(2, "filemetainfo");
    }

    public void startDataset() throws IOException {
        this.start(3, "dataset", EMPTY_ATTR);
    }

    public void endDataset() throws IOException {
        this.end(3, "dataset");
    }

    public void startDcmFile() throws IOException {
        this.start(4, "dicomfile", EMPTY_ATTR);
    }

    public void endDcmFile() throws IOException {
        this.end(4, "dicomfile");
    }

    private void start(int n, String string, Attributes attributes) throws IOException {
        try {
            if (this.docType == 0) {
                this.docType = n;
                this.handler.startDocument();
            }
            this.handler.startElement("", string, string, attributes);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in start " + string).initCause(sAXException);
        }
    }

    private void end(int n, String string) throws IOException {
        try {
            this.handler.endElement("", string, string);
            if (this.docType == n) {
                this.handler.endDocument();
                n = 0;
            }
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in end " + string).initCause(sAXException);
        }
    }

    public void setDcmDecodeParam(DcmDecodeParam dcmDecodeParam) {
        this.byteOrder = dcmDecodeParam.byteOrder;
        this.explicitVR = this.explicitVR;
    }

    public void startElement(int n, int n2, long l) throws IOException {
        this.vr = n2;
        try {
            TagDictionary.Entry entry;
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "tag", "tag", "", Tags.toHexString(n, 8));
            attributesImpl.addAttribute("", "vr", "vr", "", VRs.toString(n2));
            attributesImpl.addAttribute("", "pos", "pos", "", "" + l);
            if (this.dict != null && (entry = this.dict.lookup(n)) != null) {
                attributesImpl.addAttribute("", "name", "name", "", entry.name);
            }
            this.handler.startElement("", "elm", "elm", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in startElement").initCause(sAXException);
        }
    }

    public void startSequence(int n) throws IOException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "len", "len", "", "" + n);
            this.handler.startElement("", "seq", "seq", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in startElement").initCause(sAXException);
        }
    }

    public void fragment(int n, long l, byte[] byArray, int n2, int n3) throws IOException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "id", "id", "", "" + n);
            attributesImpl.addAttribute("", "pos", "pos", "", "" + l);
            attributesImpl.addAttribute("", "len", "len", "", "" + n3);
            attributesImpl.addAttribute("", "data", "data", "", StringUtils.promptValue(this.vr, ByteBuffer.wrap(byArray, n2, n3).order(this.byteOrder)));
            this.handler.startElement("", "frag", "frag", attributesImpl);
            this.handler.endElement("", "frag", "frag");
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in fragment").initCause(sAXException);
        }
    }

    public int vm(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        switch (this.vr) {
            case 19540: 
            case 20290: 
            case 20311: 
            case 21332: 
            case 21838: 
            case 21844: {
                return 1;
            }
            case 21331: 
            case 21843: {
                return n2 >> 1;
            }
            case 16724: 
            case 17996: 
            case 21324: 
            case 21836: {
                return n2 >> 2;
            }
            case 17988: {
                return n2 >> 3;
            }
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            if (byArray[n5] == 92) {
                ++n3;
            }
            ++n4;
            ++n5;
        }
        return n3;
    }

    public void value(byte[] byArray, int n, int n2) throws IOException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "vm", "vm", "", "" + this.vm(byArray, n, n2));
            attributesImpl.addAttribute("", "len", "len", "", "" + n2);
            attributesImpl.addAttribute("", "data", "data", "", StringUtils.promptValue(this.vr, ByteBuffer.wrap(byArray, n, n2).order(this.byteOrder)));
            this.handler.startElement("", "val", "val", attributesImpl);
            this.handler.endElement("", "val", "val");
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in value").initCause(sAXException);
        }
    }

    public void endElement() throws IOException {
        try {
            this.handler.endElement("", "elm", "elm");
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in endElement").initCause(sAXException);
        }
    }

    public void endSequence(int n) throws IOException {
        try {
            this.handler.endElement("", "seq", "seq");
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in endSequence").initCause(sAXException);
        }
    }

    public void startItem(int n, long l, int n2) throws IOException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "id", "id", "", "" + n);
            attributesImpl.addAttribute("", "pos", "pos", "", "" + l);
            attributesImpl.addAttribute("", "len", "len", "", "" + n2);
            this.handler.startElement("", "item", "item", attributesImpl);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in startItem").initCause(sAXException);
        }
    }

    public void endItem(int n) throws IOException {
        try {
            this.handler.endElement("", "item", "item");
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Exception in endItem").initCause(sAXException);
        }
    }
}

