/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.net;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.dcm4che.Implementation;
import org.dcm4che.net.AAssociateAC;
import org.dcm4che.net.AAssociateRQ;
import org.dcm4che.net.AcceptorPolicy;
import org.dcm4che.net.AsyncOpsWindow;
import org.dcm4che.net.ExtNegotiation;
import org.dcm4che.net.ExtNegotiator;
import org.dcm4che.net.PDU;
import org.dcm4che.net.PresContext;
import org.dcm4che.net.RoleSelection;
import org.dcm4cheri.net.AAssociateACImpl;
import org.dcm4cheri.net.AAssociateRJImpl;
import org.dcm4cheri.net.AsyncOpsWindowImpl;
import org.dcm4cheri.net.ExtNegotiationImpl;
import org.dcm4cheri.net.PresContextImpl;
import org.dcm4cheri.net.RoleSelectionImpl;
import org.dcm4cheri.util.StringUtils;

class AcceptorPolicyImpl
implements AcceptorPolicy {
    private int maxLength = 16352;
    private AsyncOpsWindow aow = null;
    private String implClassUID = Implementation.getClassUID();
    private String implVers = Implementation.getVersionName();
    private HashMap appCtxMap = new HashMap();
    private HashSet calledAETs = null;
    private HashSet callingAETs = null;
    private HashMap policyForCalledAET = new HashMap();
    private HashMap policyForCallingAET = new HashMap();
    private HashMap presCtxMap = new HashMap();
    private HashMap roleSelectionMap = new HashMap();
    private HashMap extNegotiaionMap = new HashMap();

    public AcceptorPolicyImpl() {
        this.addPresContext("1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"});
    }

    public void setMaxPDULength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxLength:" + n);
        }
        this.maxLength = n;
    }

    public int getMaxPDULength() {
        return this.maxLength;
    }

    public AsyncOpsWindow getAsyncOpsWindow() {
        return this.aow;
    }

    public void setAsyncOpsWindow(int n, int n2) {
        this.aow = new AsyncOpsWindowImpl(n, n2);
    }

    public void setAsyncOpsWindow(AsyncOpsWindow asyncOpsWindow) {
        this.aow = asyncOpsWindow;
    }

    public void setImplClassUID(String string) {
        this.implClassUID = StringUtils.checkUID(string);
    }

    public String getImplClassUID() {
        return this.implClassUID;
    }

    public void setImplVersionName(String string) {
        this.implVers = string != null ? StringUtils.checkAET(string) : null;
    }

    public String getImplVersionName() {
        return this.implVers;
    }

    public String putApplicationContextName(String string, String string2) {
        return this.appCtxMap.put(StringUtils.checkUID(string), StringUtils.checkUID(string2));
    }

    public boolean addCalledAET(String string) {
        StringUtils.checkAET(string);
        if (this.calledAETs == null) {
            this.calledAETs = new HashSet();
        }
        this.calledAETs.add(string);
        return this.calledAETs.add(string);
    }

    public boolean removeCalledAET(String string) {
        return this.calledAETs != null && this.calledAETs.remove(string);
    }

    public void setCalledAETs(String[] stringArray) {
        this.calledAETs = stringArray != null ? new HashSet<String>(Arrays.asList(StringUtils.checkAETs(stringArray))) : null;
    }

    public String[] getCalledAETs() {
        return this.calledAETs != null ? this.calledAETs.toArray(new String[this.calledAETs.size()]) : null;
    }

    public boolean addCallingAET(String string) {
        StringUtils.checkAET(string);
        if (this.callingAETs == null) {
            this.callingAETs = new HashSet();
        }
        return this.callingAETs.add(string);
    }

    public boolean removeCallingAET(String string) {
        return this.callingAETs != null && this.callingAETs.remove(string);
    }

    public void setCallingAETs(String[] stringArray) {
        this.callingAETs = stringArray != null ? new HashSet<String>(Arrays.asList(StringUtils.checkAETs(stringArray))) : null;
    }

    public String[] getCallingAETs() {
        return this.callingAETs != null ? this.callingAETs.toArray(new String[this.callingAETs.size()]) : null;
    }

    public AcceptorPolicy addPolicyForCalledAET(String string, AcceptorPolicy acceptorPolicy) {
        if (acceptorPolicy == null) {
            throw new NullPointerException();
        }
        return this.policyForCalledAET.put(StringUtils.checkAET(string), acceptorPolicy);
    }

    public AcceptorPolicy getPolicyForCalledAET(String string) {
        return (AcceptorPolicy)this.policyForCalledAET.get(string);
    }

    public AcceptorPolicy addPolicyForCallingAET(String string, AcceptorPolicy acceptorPolicy) {
        if (acceptorPolicy == null) {
            throw new NullPointerException();
        }
        return this.policyForCallingAET.put(StringUtils.checkAET(string), acceptorPolicy);
    }

    public AcceptorPolicy getPolicyForCallingAET(String string) {
        return (AcceptorPolicy)this.policyForCallingAET.get(string);
    }

    public final PresContext addPresContext(String string, String[] stringArray) {
        return this.presCtxMap.put(string, new PresContextImpl(32, 1, 0, StringUtils.checkUID(string), StringUtils.checkUIDs(stringArray)));
    }

    public PresContext getPresContext(String string) {
        return (PresContext)this.presCtxMap.get(string);
    }

    public PresContext removePresContext(String string) {
        return (PresContext)this.presCtxMap.remove(string);
    }

    public RoleSelection addRoleSelection(RoleSelection roleSelection) {
        return this.roleSelectionMap.put(roleSelection.getSOPClassUID(), roleSelection);
    }

    public RoleSelection getRoleSelection(String string) {
        return (RoleSelection)this.roleSelectionMap.get(string);
    }

    public RoleSelection removeRoleSelection(String string) {
        return (RoleSelection)this.roleSelectionMap.remove(string);
    }

    public ExtNegotiator addExtNegPolicy(String string, ExtNegotiator extNegotiator) {
        return this.extNegotiaionMap.put(string, extNegotiator);
    }

    public ExtNegotiator getExtNegPolicy(String string) {
        return (ExtNegotiator)this.extNegotiaionMap.get(string);
    }

    public ExtNegotiator removeExtNegPolicy(String string) {
        return (ExtNegotiator)this.extNegotiaionMap.remove(string);
    }

    public PDU negotiate(AAssociateRQ aAssociateRQ) {
        if ((aAssociateRQ.getProtocolVersion() & 1) == 0) {
            return new AAssociateRJImpl(1, 2, 2);
        }
        String string = aAssociateRQ.getCalledAET();
        if (this.calledAETs != null && !this.calledAETs.contains(string)) {
            return new AAssociateRJImpl(1, 1, 7);
        }
        AcceptorPolicyImpl acceptorPolicyImpl = (AcceptorPolicyImpl)this.getPolicyForCalledAET(string);
        if (acceptorPolicyImpl == null) {
            acceptorPolicyImpl = this;
        }
        String string2 = aAssociateRQ.getCalledAET();
        if (acceptorPolicyImpl.callingAETs != null && !acceptorPolicyImpl.callingAETs.contains(string2)) {
            return new AAssociateRJImpl(1, 1, 3);
        }
        AcceptorPolicyImpl acceptorPolicyImpl2 = (AcceptorPolicyImpl)acceptorPolicyImpl.getPolicyForCallingAET(string2);
        if (acceptorPolicyImpl2 == null) {
            acceptorPolicyImpl2 = acceptorPolicyImpl;
        }
        return acceptorPolicyImpl2.doNegotiate(aAssociateRQ);
    }

    private PDU doNegotiate(AAssociateRQ aAssociateRQ) {
        String string = this.negotiateAppCtx(aAssociateRQ.getApplicationContext());
        if (string == null) {
            return new AAssociateRJImpl(1, 1, 2);
        }
        AAssociateACImpl aAssociateACImpl = new AAssociateACImpl();
        aAssociateACImpl.setApplicationContext(string);
        aAssociateACImpl.setCalledAET(aAssociateRQ.getCalledAET());
        aAssociateACImpl.setCallingAET(aAssociateRQ.getCallingAET());
        aAssociateACImpl.setMaxPDULength(this.maxLength);
        aAssociateACImpl.setImplClassUID(this.implClassUID);
        aAssociateACImpl.setImplVersionName(this.implVers);
        aAssociateACImpl.setAsyncOpsWindow(this.negotiateAOW(aAssociateRQ.getAsyncOpsWindow()));
        this.negotiatePresCtx(aAssociateRQ, aAssociateACImpl);
        this.negotiateRoleSelection(aAssociateRQ, aAssociateACImpl);
        this.negotiateExt(aAssociateRQ, aAssociateACImpl);
        return aAssociateACImpl;
    }

    private String negotiateAppCtx(String string) {
        String string2 = (String)this.appCtxMap.get(string);
        if (string2 != null) {
            return string2;
        }
        if ("1.2.840.10008.3.1.1.1".equals(string)) {
            return string;
        }
        return null;
    }

    private void negotiatePresCtx(AAssociateRQ aAssociateRQ, AAssociateAC aAssociateAC) {
        Iterator iterator = aAssociateRQ.listPresContext().iterator();
        while (iterator.hasNext()) {
            aAssociateAC.addPresContext(this.negotiatePresCtx((PresContext)iterator.next()));
        }
    }

    private PresContext negotiatePresCtx(PresContext presContext) {
        int n = 3;
        String string = "1.2.840.10008.1.2";
        PresContext presContext2 = this.getPresContext(presContext.getAbstractSyntaxUID());
        if (presContext2 != null) {
            n = 4;
            Iterator iterator = presContext2.getTransferSyntaxUIDs().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (presContext.getTransferSyntaxUIDs().indexOf(string) == -1) continue;
                n = 0;
                break;
            }
        }
        return new PresContextImpl(33, presContext.pcid(), n, null, new String[]{string});
    }

    private void negotiateRoleSelection(AAssociateRQ aAssociateRQ, AAssociateAC aAssociateAC) {
        Iterator iterator = aAssociateRQ.listRoleSelections().iterator();
        while (iterator.hasNext()) {
            aAssociateAC.addRoleSelection(this.negotiateRoleSelection((RoleSelection)iterator.next()));
        }
    }

    private RoleSelection negotiateRoleSelection(RoleSelection roleSelection) {
        boolean bl = roleSelection.scu();
        boolean bl2 = false;
        RoleSelection roleSelection2 = this.getRoleSelection(roleSelection.getSOPClassUID());
        if (roleSelection2 != null) {
            bl = roleSelection.scu() && roleSelection2.scu();
            bl2 = roleSelection.scp() && roleSelection2.scp();
        }
        return new RoleSelectionImpl(roleSelection.getSOPClassUID(), bl, bl2);
    }

    private void negotiateExt(AAssociateRQ aAssociateRQ, AAssociateAC aAssociateAC) {
        Iterator iterator = aAssociateRQ.listExtNegotiations().iterator();
        while (iterator.hasNext()) {
            ExtNegotiation extNegotiation = (ExtNegotiation)iterator.next();
            String string = extNegotiation.getSOPClassUID();
            ExtNegotiator extNegotiator = this.getExtNegPolicy(string);
            if (extNegotiator == null) continue;
            aAssociateAC.addExtNegotiation(new ExtNegotiationImpl(string, extNegotiator.negotiate(extNegotiation.info())));
        }
    }

    private AsyncOpsWindow negotiateAOW(AsyncOpsWindow asyncOpsWindow) {
        if (asyncOpsWindow == null) {
            return null;
        }
        if (this.aow == null) {
            return AsyncOpsWindowImpl.DEFAULT;
        }
        return new AsyncOpsWindowImpl(AcceptorPolicyImpl.minAOW(asyncOpsWindow.getMaxOpsInvoked(), this.aow.getMaxOpsInvoked()), AcceptorPolicyImpl.minAOW(asyncOpsWindow.getMaxOpsPerformed(), this.aow.getMaxOpsPerformed()));
    }

    static int minAOW(int n, int n2) {
        return n == 0 ? n2 : (n2 == 0 ? n : Math.min(n, n2));
    }
}

