/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.srom;

import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.srom.Code;
import org.dcm4che.srom.ContainerContent;
import org.dcm4che.srom.Content;
import org.dcm4che.srom.KeyObject;
import org.dcm4che.srom.SOPInstanceRef;
import org.dcm4che.srom.Template;
import org.dcm4cheri.srom.NamedContentImpl;

class ContainerContentImpl
extends NamedContentImpl
implements ContainerContent {
    private boolean separate;

    ContainerContentImpl(KeyObject keyObject, Date date, Template template, Code code, boolean bl) {
        super(keyObject, date, template, code);
        this.separate = bl;
    }

    Content clone(KeyObject keyObject, boolean bl) {
        return new ContainerContentImpl(keyObject, this.getObservationDateTime(bl), this.template, this.name, this.separate);
    }

    public String toString() {
        return this.prompt().append(this.separate ? "separate" : "continuous").toString();
    }

    public final Content.ValueType getValueType() {
        return Content.ValueType.CONTAINER;
    }

    public final boolean isSeparate() {
        return this.separate;
    }

    public final void setSeparate(boolean bl) {
        this.separate = bl;
    }

    public void toDataset(Dataset dataset) {
        super.toDataset(dataset);
        dataset.putCS(4235344, this.separate ? "SEPARATE" : "CONTINUOUS");
    }

    public void insertCompositeContent(Code code, SOPInstanceRef sOPInstanceRef) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createCompositeContent(null, null, code, sOPInstanceRef));
        this.owner.addCurrentEvidence(sOPInstanceRef);
    }

    public void insertImageContent(Code code, SOPInstanceRef sOPInstanceRef, int[] nArray, SOPInstanceRef sOPInstanceRef2) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createImageContent(null, null, code, sOPInstanceRef, nArray, sOPInstanceRef2));
        this.owner.addCurrentEvidence(sOPInstanceRef);
        if (sOPInstanceRef2 != null) {
            this.owner.addCurrentEvidence(sOPInstanceRef2);
        }
    }

    public void insertWaveformContent(Code code, SOPInstanceRef sOPInstanceRef, int[] nArray) {
        this.appendChild(Content.RelationType.CONTAINS, this.owner.createWaveformContent(null, null, code, sOPInstanceRef, nArray));
        this.owner.addCurrentEvidence(sOPInstanceRef);
    }
}

